/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.internal.execution.local.common.ActiveAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.GetPropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.KillProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessExitedCommand;
import org.eclipse.hyades.internal.execution.local.common.PropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.RegisteredProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.SimpleProcessCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentImpl;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.NotImplementedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.SecureConnectionImpl;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;

class NodeImpl
implements Node {
    protected String _name;
    protected InetAddress[] _addr;
    protected Vector _listeners = new Vector(10);
    protected Connection _connection;
    protected Application _application;
    private User _user;
    private Object propLock = new Object();
    private ISecureClientParameters _securityParms = null;
    protected Hashtable _processes = new Hashtable(300);
    protected String[] props = null;
    private ProcessListener _processListener = null;
    private long _listProcessesWaitingCommandCount = 0L;
    private Object _listProcessesLock = new Object();

    public NodeImpl(String string, InetAddress inetAddress) {
        this._name = string;
        try {
            this._addr = InetAddress.getAllByName(inetAddress.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this._processListener = new ProcessListener(){

            public synchronized void processLaunched(Process process) {
                try {
                    Long l = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(l);
                    NodeImpl.this._processes.put(l, process);
                }
                catch (InactiveProcessException inactiveProcessException) {}
            }

            public synchronized void processExited(Process process) {
                try {
                    Long l = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(l);
                }
                catch (InactiveProcessException inactiveProcessException) {}
            }
        };
    }

    public NodeImpl(String string, InetAddress[] inetAddressArray) {
        this._name = string;
        this._addr = inetAddressArray;
        this._processListener = new ProcessListener(){

            public synchronized void processLaunched(Process process) {
                try {
                    Long l = new Long(process.getProcessId());
                    if (!NodeImpl.this._processes.containsKey(l)) {
                        NodeImpl.this._processes.put(l, process);
                    }
                }
                catch (InactiveProcessException inactiveProcessException) {}
            }

            public synchronized void processExited(Process process) {
                try {
                    Long l = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(l);
                }
                catch (InactiveProcessException inactiveProcessException) {}
            }
        };
    }

    public void killProcess(Process process) throws InactiveProcessException, NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        if (!process.isActive()) {
            throw new InactiveProcessException();
        }
        ControlMessage controlMessage = new ControlMessage();
        KillProcessCommand killProcessCommand = new KillProcessCommand();
        killProcessCommand.setProcessId(Long.parseLong(process.getProcessId()));
        controlMessage.appendCommand(killProcessCommand);
        try {
            this._connection.sendMessage(controlMessage, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement commandElement) {
                }
            });
        }
        catch (IOException iOException) {}
    }

    public void shutdown(long l) throws NotConnectedException {
        throw new NotImplementedException();
    }

    public void reboot(long l) throws NotConnectedException {
        throw new NotImplementedException();
    }

    public Enumeration listMonitors() throws NotConnectedException {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration listProcesses() throws NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        NodeImpl nodeImpl = this;
        ControlMessage controlMessage = new ControlMessage();
        QueryProcessListCommand queryProcessListCommand = new QueryProcessListCommand();
        controlMessage.appendCommand(queryProcessListCommand);
        ConnectionListener connectionListener = new ConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connectionClosed(Connection connection) {
                Object object = NodeImpl.this._listProcessesLock;
                synchronized (object) {
                    NodeImpl.this._listProcessesLock.notifyAll();
                }
            }
        };
        Object object = this._listProcessesLock;
        synchronized (object) {
            this._connection.addConnectionListener(connectionListener);
            try {
                this._connection.sendMessage(controlMessage, new CommandHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void incommingCommand(Node node, CommandElement commandElement) {
                        switch ((int)commandElement.getTag()) {
                            case 33: {
                                Object object;
                                RegisteredProcessListCommand registeredProcessListCommand = (RegisteredProcessListCommand)commandElement;
                                long[] lArray = registeredProcessListCommand.getProcessList();
                                long l = lArray.length;
                                Enumeration enumeration = NodeImpl.this._processes.elements();
                                while (enumeration.hasMoreElements()) {
                                    long l2 = 0L;
                                    object = (Process)enumeration.nextElement();
                                    try {
                                        l2 = Long.parseLong(object.getProcessId());
                                    }
                                    catch (InactiveProcessException inactiveProcessException) {
                                        continue;
                                    }
                                    long l3 = 0L;
                                    while (l3 < l) {
                                        if (l2 == lArray[(int)l3]) {
                                            if (object.isActive()) break;
                                            l3 = l;
                                        }
                                        ++l3;
                                    }
                                    if (l3 != l) continue;
                                    NodeImpl.this._processes.remove(new Long(l2));
                                    try {
                                        ProcessExitedCommand processExitedCommand = new ProcessExitedCommand();
                                        processExitedCommand.setProcessId(l2);
                                        ((ProcessImpl)object).handleCommand(processExitedCommand);
                                    }
                                    catch (ClassCastException classCastException) {
                                        // empty catch block
                                    }
                                }
                                if (l == 0L) {
                                    Object object2 = NodeImpl.this._listProcessesLock;
                                    synchronized (object2) {
                                        NodeImpl.this._listProcessesLock.notify();
                                        break;
                                    }
                                }
                                ControlMessage controlMessage = new ControlMessage();
                                int n = 0;
                                while ((long)n < l) {
                                    object = new QueryAgentListCommand();
                                    ((SimpleProcessCommand)object).setProcessId(lArray[n]);
                                    controlMessage.appendCommand((CommandElement)object);
                                    ++n;
                                }
                                try {
                                    object = NodeImpl.this._listProcessesLock;
                                    synchronized (object) {
                                        NodeImpl.this._listProcessesWaitingCommandCount = l;
                                    }
                                    NodeImpl.this._connection.sendMessage(controlMessage, new CommandHandler(this){
                                        private final /* synthetic */ 5 this$1;
                                        {
                                            this.this$1 = var1_1;
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void incommingCommand(Node node, CommandElement commandElement) {
                                            Object object;
                                            switch ((int)commandElement.getTag()) {
                                                case 34: {
                                                    Object object2;
                                                    object = (ActiveAgentListCommand)commandElement;
                                                    Long l = new Long(((SimpleProcessCommand)object).getProcessId());
                                                    Process process = (Process)5.access$200(this.this$1)._processes.get(l);
                                                    if (process == null) {
                                                        process = new ProcessImpl(node, ((ActiveAgentListCommand)object).getProcessName(), ((SimpleProcessCommand)object).getProcessId());
                                                        try {
                                                            process.addProcessListener(NodeImpl.access$300(5.access$200(this.this$1)));
                                                        }
                                                        catch (ClassCastException classCastException) {
                                                            // empty catch block
                                                        }
                                                        5.access$200(this.this$1)._processes.put(l, process);
                                                    } else if (!process.getExecutable().equals(((ActiveAgentListCommand)object).getProcessName()) && !((ActiveAgentListCommand)object).getProcessName().equals("unknown")) {
                                                        object2 = new ProcessExitedCommand();
                                                        ((SimpleProcessCommand)object2).setProcessId(((SimpleProcessCommand)object).getProcessId());
                                                        ((ProcessImpl)process).handleCommand((CommandElement)object2);
                                                        5.access$200(this.this$1)._processes.remove(l);
                                                        process = new ProcessImpl(node, ((ActiveAgentListCommand)object).getProcessName(), ((SimpleProcessCommand)object).getProcessId());
                                                        try {
                                                            process.addProcessListener(NodeImpl.access$300(5.access$200(this.this$1)));
                                                        }
                                                        catch (ClassCastException classCastException) {
                                                            // empty catch block
                                                        }
                                                        5.access$200(this.this$1)._processes.put(l, process);
                                                    }
                                                    ((ProcessImpl)process).removeAllAgents();
                                                    object2 = ((ActiveAgentListCommand)object).getAgents();
                                                    int n = 0;
                                                    while (n < ((String[])object2).length) {
                                                        ControlMessage controlMessage = new ControlMessage();
                                                        QueryAgentDetailsCommand queryAgentDetailsCommand = new QueryAgentDetailsCommand();
                                                        queryAgentDetailsCommand.setProcessId(((SimpleProcessCommand)object).getProcessId());
                                                        queryAgentDetailsCommand.setAgentName((String)object2[n]);
                                                        controlMessage.appendCommand(queryAgentDetailsCommand);
                                                        try {
                                                            Object object3 = NodeImpl.access$000(5.access$200(this.this$1));
                                                            synchronized (object3) {
                                                                NodeImpl.access$108(5.access$200(this.this$1));
                                                            }
                                                            5.access$200(this.this$1)._connection.sendMessage(controlMessage, new CommandHandler(this){
                                                                private final /* synthetic */ 6 this$2;
                                                                {
                                                                    this.this$2 = var1_1;
                                                                }

                                                                /*
                                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                                 */
                                                                public void incommingCommand(Node node, CommandElement commandElement) {
                                                                    switch ((int)commandElement.getTag()) {
                                                                        case 40: {
                                                                            AgentDetailsCommand agentDetailsCommand = (AgentDetailsCommand)commandElement;
                                                                            Process process = (Process)5.access$200(6.access$400(this.this$2))._processes.get(new Long(agentDetailsCommand.getProcessId()));
                                                                            if (process == null) break;
                                                                            ((ProcessImpl)process).setUUID(agentDetailsCommand.getProcessUUID());
                                                                            Agent agent = process.getAgent(agentDetailsCommand.getAgentName());
                                                                            if (agent != null) break;
                                                                            agent = new AgentImpl(process, agentDetailsCommand.getAgentName(), agentDetailsCommand.getAgentType(), true);
                                                                            ((AgentImpl)agent).setUUID(agentDetailsCommand.getAgentUUID());
                                                                            try {
                                                                                ((ProcessImpl)process).addAgent(agent);
                                                                                agent.addAgentListener((ProcessImpl)process);
                                                                            }
                                                                            catch (ClassCastException classCastException) {}
                                                                            break;
                                                                        }
                                                                    }
                                                                    Object object = NodeImpl.access$000(5.access$200(6.access$400(this.this$2)));
                                                                    synchronized (object) {
                                                                        NodeImpl.access$110(5.access$200(6.access$400(this.this$2)));
                                                                        if (NodeImpl.access$100(5.access$200(6.access$400(this.this$2))) == 0L) {
                                                                            NodeImpl.access$000(5.access$200(6.access$400(this.this$2))).notify();
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        catch (IOException iOException) {
                                                            // empty catch block
                                                        }
                                                        ++n;
                                                    }
                                                    break;
                                                }
                                            }
                                            object = NodeImpl.access$000(5.access$200(this.this$1));
                                            synchronized (object) {
                                                NodeImpl.access$110(5.access$200(this.this$1));
                                                if (NodeImpl.access$100(5.access$200(this.this$1)) == 0L) {
                                                    NodeImpl.access$000(5.access$200(this.this$1)).notify();
                                                }
                                            }
                                        }

                                        static /* synthetic */ 5 access$400(6 var0) {
                                            return var0.this$1;
                                        }
                                    });
                                    break;
                                }
                                catch (IOException iOException) {
                                    Object object3 = NodeImpl.this._listProcessesLock;
                                    synchronized (object3) {
                                        NodeImpl.this._listProcessesWaitingCommandCount = 0L;
                                        NodeImpl.this._listProcessesLock.notify();
                                        break;
                                    }
                                }
                            }
                        }
                    }

                    static /* synthetic */ NodeImpl access$200(5 var0) {
                        return var0.NodeImpl.this;
                    }
                });
            }
            catch (IOException iOException) {
                return null;
            }
            try {
                this._listProcessesLock.wait(7000L);
                this._connection.removeConnectionListener(connectionListener);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ((Hashtable)this._processes.clone()).elements();
    }

    public synchronized Process getProcess(String string) {
        return (Process)this._processes.get(new Long(string));
    }

    public InetAddress getInetAddress() {
        if (this._addr != null) {
            return this._addr[0];
        }
        return null;
    }

    public InetAddress[] getAllInetAddresses() {
        return this._addr;
    }

    public String getName() {
        return this._name;
    }

    public boolean isConnected() {
        if (this._connection != null) {
            return this._connection.isActive();
        }
        return false;
    }

    public synchronized Connection connect(int n) throws AgentControllerUnavailableException, SecureConnectionRequiredException, UntrustedAgentControllerException, LoginFailedException {
        if (this._connection == null || !this._connection.isActive()) {
            try {
                if (this._securityParms == null) {
                    this._connection = new ConnectionImpl();
                    ((ConnectionImpl)this._connection).connect(this, n);
                } else {
                    this._connection = new SecureConnectionImpl();
                    if (this._connection != null) {
                        this._connection.connect(this, n);
                    }
                }
            }
            catch (IOException iOException) {
                this._connection = null;
                throw new AgentControllerUnavailableException();
            }
        }
        return this._connection;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public ProcessListener getProcessListener() {
        return this._processListener;
    }

    public void setUser(User user) {
        this._user = user;
    }

    public User getUser() {
        return this._user;
    }

    public void setApplication(Application application) {
        this._application = application;
    }

    public Application getApplication() {
        return this._application;
    }

    public void setSecurityParameters(ISecureClientParameters iSecureClientParameters) {
        this._securityParms = iSecureClientParameters;
    }

    public ISecureClientParameters getSecurityParameters() {
        return this._securityParms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProperties() throws NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        NodeImpl nodeImpl = this;
        ControlMessage controlMessage = new ControlMessage();
        GetPropertyListCommand getPropertyListCommand = new GetPropertyListCommand();
        controlMessage.appendCommand(getPropertyListCommand);
        Object object = this.propLock;
        synchronized (object) {
            try {
                this._connection.sendMessage(controlMessage, new CommandHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void incommingCommand(Node node, CommandElement commandElement) {
                        switch ((int)commandElement.getTag()) {
                            case 42: {
                                PropertyListCommand propertyListCommand = (PropertyListCommand)commandElement;
                                NodeImpl.this.props = propertyListCommand.getPropertyList();
                                Object object = NodeImpl.this.propLock;
                                synchronized (object) {
                                    NodeImpl.this.propLock.notify();
                                    break;
                                }
                            }
                        }
                    }
                });
                this.propLock.wait(10000L);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.props;
    }

    static /* synthetic */ ProcessListener access$300(NodeImpl nodeImpl) {
        return nodeImpl._processListener;
    }

    static /* synthetic */ long access$108(NodeImpl nodeImpl) {
        return nodeImpl._listProcessesWaitingCommandCount++;
    }

    static /* synthetic */ long access$110(NodeImpl nodeImpl) {
        return nodeImpl._listProcessesWaitingCommandCount--;
    }

    static /* synthetic */ long access$100(NodeImpl nodeImpl) {
        return nodeImpl._listProcessesWaitingCommandCount;
    }
}

