/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.LogFilterCriteria;
import org.eclipse.hyades.log.ui.internal.actions.provider.LogFindCriteria;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.FiltersDialog;
import org.eclipse.hyades.log.ui.internal.util.LogRecordSearch;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.util.RecordFilterSearchUtil;
import org.eclipse.hyades.log.ui.internal.util.SearchRecordDialog;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.sd.logc.internal.uml2sd.SourceOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.TargetOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.sd.logc.internal.util.LogCorrelationSelectionDialog;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogInteractions
implements IUml2SDLoader,
ISelectionListener,
ISelectionChangedListener,
IViewSelectionChangedListener,
ISDAdvancedPagingProvider,
IExtendedFilterProvider,
IExtendedFindProvider,
ILogFilterProvider,
ILogFindProvider,
IProfileEventListener {
    protected CorrelationContainerProxy correlationContainerProxy;
    protected EObject inputObject;
    protected Map graphNodes = new HashMap();
    protected Map lifelinesMap = new HashMap();
    protected List eventsList = new ArrayList();
    protected Map currentPageEvents = new HashMap();
    protected List agentsList = new ArrayList();
    protected SDView view;
    private Map sourceOutOfPageMessages;
    private Map targetOutOfPageMessages;
    private IConfigurationElement correlationType;
    private LogRecordComparator comparator;
    private CBECommonBaseEvent currentSelection;
    private int currentPageIndex = 0;
    private int nrOfPages = 0;
    private int PAGE_SIZE = 0;
    private int MAX_NR_OF_RECORDS = 99999;
    private int totalSize = 0;
    private ArrayList filterTableElements = null;
    private ArrayList findTableElements = null;
    private RecordFilterSearchUtil recordFilterSearch = null;
    private boolean displayOnlyCorrelations = true;
    private Object[] pageCache;
    private LogRecordSearch logRecordSearch = null;
    private Label lblMessage;
    private Object lastMatch = null;
    protected LogInteractionsFrame frame;
    protected static LifelineCategories[] traceCategories = new LifelineCategories[1];
    protected static IImage image;
    public static final int CATEGORY_LOGS = 0;

    public LogInteractions() {
        UIPlugin.getDefault().addSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
        this.recordFilterSearch = new RecordFilterSearchUtil();
    }

    public void setViewer(SDView sDView) {
        this.view = sDView;
        sDView.setSDPagingProvider((ISDPagingProvider)this);
        sDView.setExtendedFilterProvider((IExtendedFilterProvider)this);
        sDView.setExtendedFindProvider((IExtendedFindProvider)this);
        sDView.getSDWidget().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        WorkbenchHelp.setHelp((Control)this.view.getSDWidget(), (String)ContextIds.INTERACTION_VIEW);
    }

    public void aboutToBeReplaced() {
        UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        if (this.view != null) {
            this.view.getSDWidget().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.clearDiagramCaches();
        this.recordFilterSearch = null;
    }

    public void generateLogInteractions(EObject eObject, boolean bl) {
        this.view.setFrame((Frame)this.parseModel(eObject, bl));
    }

    public void generateLogInteractions(EObject eObject, IConfigurationElement iConfigurationElement) {
        this.setCorrelationType(iConfigurationElement);
        this.view.setFrame((Frame)this.parseModel((EObject)CorrelationHelper.getInstance().createCorrelationContainer(this.correlationType, (Object)eObject, this.correlationType.getAttribute("name")), false));
    }

    public LogInteractionsFrame parseModel(EObject eObject, final boolean bl) {
        this.inputObject = eObject;
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        this.displayOnlyCorrelations = iPreferenceStore.getString("pd_filter_show_correlation_only").equals("1");
        this.correlationContainerProxy = null;
        this.clearDiagramCaches();
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.loadCorrelations(bl);
                LogInteractions.this.createPartition();
                LogInteractions.this.frame = LogInteractions.this.createPage();
            }
        });
        return this.frame;
    }

    public LogInteractionsFrame parseModel(EObject eObject) {
        return this.parseModel(eObject, false);
    }

    protected List getFilteredEvents(List list) {
        if (list == null) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (this.isFilterApplied((EObject)e)) {
                arrayList.add(e);
            }
            ++n;
        }
        Collections.sort(arrayList, this.getComparator());
        return arrayList;
    }

    private boolean isFilterApplied(EObject eObject) {
        if (this.filterTableElements == null || this.filterTableElements.size() == 0) {
            return true;
        }
        return this.recordFilterSearch.isAdvFilterApply(eObject, this.filterTableElements);
    }

    protected void clearTemporaryCaches() {
        this.graphNodes.clear();
        this.lifelinesMap.clear();
        this.currentPageEvents.clear();
        if (this.sourceOutOfPageMessages != null) {
            this.sourceOutOfPageMessages.clear();
        }
        if (this.targetOutOfPageMessages != null) {
            this.targetOutOfPageMessages.clear();
        }
    }

    protected void clearDiagramCaches() {
        this.clearTemporaryCaches();
        this.agentsList.clear();
        if (this.eventsList != null) {
            this.eventsList.clear();
        }
        if (this.pageCache != null) {
            int n = 0;
            while (n < this.pageCache.length) {
                this.pageCache[n] = null;
                ++n;
            }
            this.pageCache = null;
        }
    }

    protected void loadCorrelations(boolean bl) {
        if (this.inputObject instanceof CorrelationContainerProxy) {
            this.correlationContainerProxy = (CorrelationContainerProxy)this.inputObject;
        } else if (bl) {
            this.showCorrelationDialog();
        }
        if (this.correlationContainerProxy != null) {
            this.agentsList.addAll(this.correlationContainerProxy.getCorrelatedAgents());
        } else {
            this.agentsList.addAll(HyadesUtil.getLogAgents((EObject)this.inputObject));
        }
        this.loadEvents();
        this.eventsList = this.getFilteredEvents(this.eventsList);
    }

    protected void loadEvents() {
        if (!this.displayOnlyCorrelations) {
            Iterator iterator = this.agentsList.iterator();
            while (iterator.hasNext()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
                if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy()) continue;
                this.addEvents(tRCAgentProxy);
            }
        } else {
            this.loadEventsFromCorrelations();
        }
    }

    protected void loadEventsFromCorrelations() {
        if (this.correlationContainerProxy == null) {
            return;
        }
        EMap eMap = this.correlationContainerProxy.getCorrelationContainer().getCorrelations();
        this.eventsList = new UniqueEList();
        Iterator iterator = eMap.iterator();
        while (iterator.hasNext()) {
            CorrelationEntryImpl correlationEntryImpl = (CorrelationEntryImpl)iterator.next();
            this.eventsList.add(correlationEntryImpl.getKey());
            List list = (List)correlationEntryImpl.getValue();
            if (list == null || list.size() <= 0) continue;
            this.eventsList.addAll(list);
        }
    }

    protected Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new LogRecordComparator();
        }
        return this.comparator;
    }

    protected void generateDiagram() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.generateGraphNodes();
                LogInteractions.this.generateGraphConnections();
            }
        });
    }

    protected void generateGraphNodes() {
        EObject eObject = null;
        CBECommonBaseEvent cBECommonBaseEvent = null;
        TraceLifeline traceLifeline = null;
        LogGraphNode logGraphNode = null;
        LogGraphNode logGraphNode2 = null;
        LogGraphNode logGraphNode3 = null;
        int n = this.getMaxCurrentPageRangeIndex();
        int n2 = this.currentPageIndex * this.PAGE_SIZE;
        int n3 = this.currentPageIndex * this.PAGE_SIZE + n;
        int n4 = n2;
        while (n4 < n3) {
            eObject = (EObject)this.eventsList.get(n4);
            if (eObject instanceof CBECommonBaseEvent) {
                cBECommonBaseEvent = (CBECommonBaseEvent)eObject;
                traceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent)));
                if (this.graphNodes.get(cBECommonBaseEvent) == null) {
                    logGraphNode = this.createLogGraphNode(traceLifeline, cBECommonBaseEvent, logGraphNode2, logGraphNode3);
                    this.cacheLogGraphNode(logGraphNode);
                    if (logGraphNode2 != null && this.getComparator().compare(logGraphNode.getElement(), logGraphNode2.getElement()) == 0 && ((CBECommonBaseEvent)logGraphNode2.getElement()).getAgent().getAgentProxy() == ((CBECommonBaseEvent)logGraphNode.getElement()).getAgent().getAgentProxy()) {
                        logGraphNode3 = logGraphNode2;
                    }
                    logGraphNode2 = logGraphNode;
                }
            }
            ++n4;
        }
    }

    protected Object getLifelinesMapKey(CBECommonBaseEvent cBECommonBaseEvent) {
        return cBECommonBaseEvent.getAgent().getAgentProxy();
    }

    protected void cacheLogGraphNode(LogGraphNode logGraphNode) {
        if (this.correlationContainerProxy == null) {
            return;
        }
        CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)logGraphNode.getElement();
        this.graphNodes.put(cBECommonBaseEvent, logGraphNode);
    }

    protected void generateGraphConnections() {
        if (this.correlationContainerProxy == null) {
            return;
        }
        CBECommonBaseEvent cBECommonBaseEvent = null;
        List list = null;
        CorrelationEntryImpl correlationEntryImpl = null;
        Object object = null;
        EMap eMap = this.correlationContainerProxy.getCorrelationContainer().getCorrelations();
        Iterator iterator = eMap.iterator();
        while (iterator.hasNext()) {
            correlationEntryImpl = (CorrelationEntryImpl)iterator.next();
            object = correlationEntryImpl.getKey();
            if (!(object instanceof CBECommonBaseEvent)) continue;
            cBECommonBaseEvent = (CBECommonBaseEvent)object;
            list = (List)correlationEntryImpl.getValue();
            if (list == null) continue;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                CBECommonBaseEvent cBECommonBaseEvent2 = (CBECommonBaseEvent)list.get(n2);
                if (this.currentPageEvents.get(cBECommonBaseEvent) == null) {
                    if (this.currentPageEvents.get(cBECommonBaseEvent2) != null) {
                        this.createSourceOutOfPageMessage(cBECommonBaseEvent, cBECommonBaseEvent2);
                    }
                } else if (this.currentPageEvents.get(cBECommonBaseEvent2) != null) {
                    this.createAsyncMessage(cBECommonBaseEvent, cBECommonBaseEvent2);
                } else {
                    this.createTargetOutOfPageMessage(cBECommonBaseEvent, cBECommonBaseEvent2);
                }
                ++n2;
            }
        }
    }

    private void createSourceOutOfPageMessage(CBECommonBaseEvent cBECommonBaseEvent, CBECommonBaseEvent cBECommonBaseEvent2) {
        SourceOutOfPageMessage sourceOutOfPageMessage = this.getSourceMessage(cBECommonBaseEvent2);
        ArrayList<CBECommonBaseEvent> arrayList = null;
        if (sourceOutOfPageMessage == null) {
            arrayList = new ArrayList<CBECommonBaseEvent>();
            arrayList.add(cBECommonBaseEvent);
            sourceOutOfPageMessage = new SourceOutOfPageMessage();
            sourceOutOfPageMessage.setEndLifeline((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent2))));
            LogGraphNode logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent2));
            sourceOutOfPageMessage.setEndOccurrence(logGraphNode.getEndOccurrence());
            sourceOutOfPageMessage.setSource(arrayList);
            this.sourceOutOfPageMessages.put(cBECommonBaseEvent2, sourceOutOfPageMessage);
        } else {
            arrayList = sourceOutOfPageMessage.getSource();
            arrayList.add(cBECommonBaseEvent);
        }
        this.frame.addMessage((BaseMessage)sourceOutOfPageMessage);
    }

    protected LogInteractionsFrame createPage() {
        if (this.currentPageIndex > this.pageCache.length - 1) {
            this.frame = new LogInteractionsFrame();
        } else {
            LogInteractionsFrame logInteractionsFrame = (LogInteractionsFrame)((Object)this.pageCache[this.currentPageIndex]);
            if (logInteractionsFrame != null) {
                this.frame = logInteractionsFrame;
                return this.frame;
            }
            this.frame = new LogInteractionsFrame();
        }
        this.frame.setLifelineCategories(traceCategories);
        this.clearTemporaryCaches();
        this.generateLifelines();
        int n = this.getMaxCurrentPageRangeIndex();
        int n2 = this.currentPageIndex * this.PAGE_SIZE;
        int n3 = this.currentPageIndex * this.PAGE_SIZE + n;
        if (n3 > this.eventsList.size()) {
            this.currentPageIndex = 0;
            n = this.getMaxCurrentPageRangeIndex();
            n2 = 0;
            n3 = n;
        }
        int n4 = n2;
        while (n4 < n3) {
            EObject eObject = (EObject)this.eventsList.get(n4);
            if (eObject instanceof CBECommonBaseEvent) {
                this.currentPageEvents.put(eObject, ((CBECommonBaseEvent)eObject).getGlobalInstanceId());
            }
            ++n4;
        }
        this.frame.setName(this.getFrameTitle());
        this.generateDiagram();
        this.pageCache[this.currentPageIndex] = this.frame;
        return this.frame;
    }

    protected String getFrameTitle() {
        return SDLogcPlugin.getString("STR_MENU_LOR") + ":      " + this.getFrameName();
    }

    protected void generateLifelines() {
        Iterator iterator = this.getLifelineArtifactsList().iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            TraceLifeline traceLifeline = new TraceLifeline();
            traceLifeline.setName(tRCAgentProxy.getName());
            traceLifeline.setCategory(0);
            this.lifelinesMap.put(tRCAgentProxy, traceLifeline);
            this.frame.addLifeLine(traceLifeline);
        }
    }

    protected List getLifelineArtifactsList() {
        return this.agentsList;
    }

    private int getMaxCurrentPageRangeIndex() {
        int n = this.totalSize % this.PAGE_SIZE;
        if (this.totalSize == 0) {
            return 0;
        }
        if (this.currentPageIndex + 1 < this.nrOfPages) {
            return this.PAGE_SIZE;
        }
        if (n == 0) {
            return this.PAGE_SIZE;
        }
        return n;
    }

    protected LogGraphNode createLogGraphNode(TraceLifeline traceLifeline, CBECommonBaseEvent cBECommonBaseEvent, LogGraphNode logGraphNode, LogGraphNode logGraphNode2) {
        LogGraphNode logGraphNode3 = new LogGraphNode((EObject)cBECommonBaseEvent);
        if (logGraphNode != null) {
            if (this.getComparator().compare(cBECommonBaseEvent, logGraphNode.getElement()) == 1) {
                traceLifeline.setCurrentEventOccurrence(this.frame.getMaxEventOccurrence());
                logGraphNode3.setStartOccurrence(traceLifeline.getNewEventOccurrence());
                logGraphNode3.setEndOccurrence(traceLifeline.getNewEventOccurrence());
            } else if (((CBECommonBaseEvent)logGraphNode.getElement()).getAgent() == cBECommonBaseEvent.getAgent()) {
                logGraphNode3.setStartOccurrence(traceLifeline.getNewEventOccurrence());
                logGraphNode3.setEndOccurrence(traceLifeline.getNewEventOccurrence());
            } else {
                if (logGraphNode2 != null) {
                    traceLifeline.setCurrentEventOccurrence(logGraphNode2.getStartOccurrence());
                } else {
                    traceLifeline.setCurrentEventOccurrence(logGraphNode.getStartOccurrence());
                }
                logGraphNode3.setStartOccurrence(traceLifeline.getEventOccurrence());
                logGraphNode3.setEndOccurrence(traceLifeline.getNewEventOccurrence());
            }
        } else {
            logGraphNode3.setStartOccurrence(traceLifeline.getNewEventOccurrence());
            logGraphNode3.setEndOccurrence(traceLifeline.getNewEventOccurrence());
        }
        logGraphNode3.setName(cBECommonBaseEvent.getMsg());
        logGraphNode3.setBackgroundColor();
        traceLifeline.addExecution(logGraphNode3);
        return logGraphNode3;
    }

    private void createAsyncMessage(CBECommonBaseEvent cBECommonBaseEvent, CBECommonBaseEvent cBECommonBaseEvent2) {
        TraceLifeline traceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent)));
        TraceLifeline traceLifeline2 = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent2)));
        LogGraphNode logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent));
        LogGraphNode logGraphNode2 = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent2));
        AsyncMessage asyncMessage = new AsyncMessage();
        asyncMessage.setStartLifeline((Lifeline)traceLifeline);
        asyncMessage.setEndLifeline((Lifeline)traceLifeline2);
        asyncMessage.setStartOccurrence(logGraphNode.getStartOccurrence());
        asyncMessage.setEndOccurrence(logGraphNode2.getStartOccurrence());
        this.frame.addMessage((BaseMessage)asyncMessage);
    }

    private void createTargetOutOfPageMessage(CBECommonBaseEvent cBECommonBaseEvent, CBECommonBaseEvent cBECommonBaseEvent2) {
        TraceLifeline traceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(cBECommonBaseEvent)));
        LogGraphNode logGraphNode = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent));
        ArrayList<CBECommonBaseEvent> arrayList = null;
        TargetOutOfPageMessage targetOutOfPageMessage = this.getTargetMessage(cBECommonBaseEvent);
        if (targetOutOfPageMessage == null) {
            arrayList = new ArrayList<CBECommonBaseEvent>();
            arrayList.add(cBECommonBaseEvent2);
            targetOutOfPageMessage = new TargetOutOfPageMessage();
            targetOutOfPageMessage.setStartLifeline(traceLifeline);
            targetOutOfPageMessage.setStartOccurrence(logGraphNode.getEndOccurrence());
            targetOutOfPageMessage.setTarget(arrayList);
            this.targetOutOfPageMessages.put(cBECommonBaseEvent, targetOutOfPageMessage);
            this.frame.addMessage((BaseMessage)targetOutOfPageMessage);
        } else {
            arrayList = targetOutOfPageMessage.getTarget();
            arrayList.add(cBECommonBaseEvent2);
        }
    }

    protected void addEvents(TRCAgentProxy tRCAgentProxy) {
        this.eventsList.addAll(tRCAgentProxy.getAgent().getDefaultEvents());
    }

    protected LogGraphNode getGraphNodeFromArtifact(CBECommonBaseEvent cBECommonBaseEvent) {
        LogGraphNode logGraphNode = null;
        LogGraphNode logGraphNode2 = null;
        logGraphNode2 = (LogGraphNode)((Object)this.graphNodes.get(cBECommonBaseEvent));
        if (logGraphNode2 != null) {
            return logGraphNode2;
        }
        TraceLifeline traceLifeline = null;
        int n = 0;
        while (n < this.frame.getLifelines().size()) {
            traceLifeline = (TraceLifeline)((Object)this.frame.getLifelines().get(n));
            int n2 = 0;
            while (n2 < traceLifeline.getExecutions().size()) {
                logGraphNode = (LogGraphNode)((Object)traceLifeline.getExecutions().get(n2));
                if (logGraphNode != null && cBECommonBaseEvent == logGraphNode.getElement()) {
                    logGraphNode2 = logGraphNode;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (logGraphNode2 != null) {
            this.graphNodes.put(cBECommonBaseEvent, logGraphNode2);
        }
        return logGraphNode2;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        EObject eObject;
        if (iWorkbenchPart instanceof INavigator && !((INavigator)iWorkbenchPart).isLinkingEnabled()) {
            return;
        }
        if (this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed() && (eObject = HyadesUtil.getMofObject()) != null && eObject != this.inputObject) {
            this.view.setFrame((Frame)this.parseModel(eObject));
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelection() == null || ((IStructuredSelection)selectionChangedEvent.getSelection()).size() == 0) {
            return;
        }
        Object object = ((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
        if (object instanceof LogGraphNode) {
            LogUtil.notifyViewSelectionChanged((Object)this, (Object)((LogGraphNode)((Object)object)).getElement());
            this.currentSelection = (CBECommonBaseEvent)((LogGraphNode)((Object)object)).getElement();
        }
    }

    public boolean isDisplayingOnlyCorrelations() {
        return this.displayOnlyCorrelations;
    }

    public boolean isLifelineSupported() {
        return true;
    }

    public boolean isSyncMessageSupported() {
        return true;
    }

    public boolean isSyncMessageReturnSupported() {
        return true;
    }

    public boolean isAsyncMessageSupported() {
        return true;
    }

    public boolean isAsyncMessageReturnSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    public boolean hasNextPage() {
        return this.currentPageIndex + 1 < this.nrOfPages;
    }

    public boolean hasPrevPage() {
        return this.currentPageIndex > 0;
    }

    public void nextPage() {
        if (this.currentPageIndex + 1 < this.nrOfPages) {
            ++this.currentPageIndex;
            this.view.setFrame((Frame)this.createPage());
        }
    }

    public void prevPage() {
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
            this.view.setFrame((Frame)this.createPage());
        }
    }

    protected void createPartition() {
        this.totalSize = this.eventsList.size();
        this.PAGE_SIZE = (int)SDLogcPlugin.getDefault().getPreferenceStore().getLong("page_size");
        this.nrOfPages = this.totalSize % this.PAGE_SIZE > 0 ? this.totalSize / this.PAGE_SIZE + 1 : this.totalSize / this.PAGE_SIZE;
        this.pageCache = this.nrOfPages == 0 ? new Object[1] : new Object[this.nrOfPages];
    }

    public String getTitleString() {
        String string = SDLogcPlugin.getString("STR_VIEW_TITLE") + ": " + SDLogcPlugin.getString("STR_MENU_LOR");
        if (this.correlationContainerProxy != null) {
            string = string + " <" + this.correlationContainerProxy.getCorrelationEngine().getName() + "> ";
        }
        return string;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        Object object;
        Object object2 = viewSelectionChangedEvent.getSource();
        if (object2 != this && (object = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement()) instanceof CBECommonBaseEvent) {
            this.setSelection((CBECommonBaseEvent)object);
        }
    }

    private void showCorrelationDialog() {
        LogCorrelationSelectionDialog logCorrelationSelectionDialog = new LogCorrelationSelectionDialog(null, CorrelationHelper.getInstance().getCorrelationExtensions());
        logCorrelationSelectionDialog.open();
        if (logCorrelationSelectionDialog.getReturnCode() == 0) {
            this.setCorrelationType(logCorrelationSelectionDialog.getSelectedCorrelation());
            this.correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(this.correlationType, (Object)this.inputObject, this.correlationType.getAttribute("name"));
            this.inputObject = this.correlationContainerProxy;
            LogUtil.selectInLogNavigator((EObject)this.correlationContainerProxy);
        }
    }

    public void setSelection(CBECommonBaseEvent cBECommonBaseEvent) {
        this.view.getSDWidget().clearSelection();
        if (this.eventsList != null) {
            int n = this.eventsList.indexOf(cBECommonBaseEvent);
            int n2 = 0;
            if (n > -1) {
                n2 = n / this.PAGE_SIZE;
            }
            this.goToPage(n2);
            LogGraphNode logGraphNode = this.getGraphNodeFromArtifact(cBECommonBaseEvent);
            this.view.getSDWidget().addSelection((GraphNode)logGraphNode);
            this.view.getSDWidget().ensureVisible((GraphNode)logGraphNode);
            this.currentSelection = cBECommonBaseEvent;
        }
    }

    private void goToPage(int n) {
        this.currentPageIndex = n;
        this.view.setFrame((Frame)this.createPage());
        this.view.updateCoolBar();
    }

    public IConfigurationElement getCorrelationType() {
        return this.correlationType;
    }

    public void setCorrelationType(IConfigurationElement iConfigurationElement) {
        this.correlationType = iConfigurationElement;
    }

    public Action getFilterAction() {
        String string = SDLogcPlugin.getString("STR_FILTER_RECORD");
        Action action = new Action(string){

            public void run() {
                LogInteractions.this.filter();
            }
        };
        action.setText(string);
        action.setDescription(string);
        action.setToolTipText(string);
        return action;
    }

    public void filter() {
        FiltersDialog filtersDialog = new FiltersDialog(this.view.getViewSite().getShell(), SDLogcPlugin.getString("STR_ST_FILTER_SETTINGS"), null, (ILogFilterProvider)this, true);
        filtersDialog.open();
    }

    public Action getFindAction() {
        String string = SDLogcPlugin.getString("STR_FIND_RECORD");
        Action action = new Action(string){

            public void run() {
                LogInteractions.this.find();
            }
        };
        action.setText(string);
        action.setDescription(string);
        action.setToolTipText(string);
        return action;
    }

    public void find() {
        SearchRecordDialog searchRecordDialog = new SearchRecordDialog(this.view.getViewSite().getShell(), SDLogcPlugin.getString("STR_ST_FIND_SETTINGS"), null, (ILogFindProvider)this);
        searchRecordDialog.open();
    }

    public boolean filterRecord(LogFilterCriteria logFilterCriteria) {
        this.filterTableElements = logFilterCriteria.getFilters();
        this.displayOnlyCorrelations = logFilterCriteria.isShowCorrelationOnly();
        this.generateLogInteractions(this.inputObject, false);
        return true;
    }

    public boolean findRecord(LogFindCriteria logFindCriteria) {
        this.lblMessage = logFindCriteria.getFindMessage();
        Object object = this.getRecordSearchEngine().search(logFindCriteria.getFilters(), logFindCriteria.isForwardDirection() ? 1 : -1, (Object)this.currentSelection);
        this.selectFindRecord(object);
        return true;
    }

    public LogRecordSearch getRecordSearchEngine() {
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
        }
        Object object = this.getStartNode();
        this.logRecordSearch.initialize(this.eventsList, object);
        return this.logRecordSearch;
    }

    private Object getStartNode() {
        return this.currentSelection;
    }

    private void selectFindRecord(Object object) {
        if (object == null) {
            this.lblMessage.setText(SDLogcPlugin.getString("STR_STRING_NOT_FOUND"));
            return;
        }
        this.setSelection((CBECommonBaseEvent)object);
    }

    public boolean storeFindOptions(LogFindCriteria logFindCriteria) {
        FilterTableElement.saveFilters((ArrayList)logFindCriteria.getFilters(), (String)"uml2sd_extend_find_options", (IPreferenceStore)SDLogcPlugin.getDefault().getPreferenceStore());
        SDLogcPlugin.getDefault().getPreferenceStore().setValue("uml2sd_extend_find_direction_options", logFindCriteria.isForwardDirection() ? "1" : "-1");
        return true;
    }

    public String loadFindPreferenceString() {
        IPreferenceStore iPreferenceStore = SDLogcPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getString("uml2sd_extend_find_options");
    }

    public boolean loadFindDirection() {
        return SDLogcPlugin.getDefault().getPreferenceStore().getString("uml2sd_extend_find_direction_options").equals("1");
    }

    private SourceOutOfPageMessage getSourceMessage(CBECommonBaseEvent cBECommonBaseEvent) {
        if (this.sourceOutOfPageMessages == null) {
            this.sourceOutOfPageMessages = new HashMap();
        }
        return (SourceOutOfPageMessage)((Object)this.sourceOutOfPageMessages.get(cBECommonBaseEvent));
    }

    private TargetOutOfPageMessage getTargetMessage(CBECommonBaseEvent cBECommonBaseEvent) {
        if (this.targetOutOfPageMessages == null) {
            this.targetOutOfPageMessages = new HashMap();
        }
        return (TargetOutOfPageMessage)((Object)this.targetOutOfPageMessages.get(cBECommonBaseEvent));
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        if ((profileEvent.getType() == 64 || profileEvent.getType() == 32) && profileEvent.getSource() instanceof EObject) {
            this.parseModel(this.inputObject);
        }
    }

    public int currentPage() {
        if (this.nrOfPages == 0) {
            return -1;
        }
        return this.currentPageIndex;
    }

    public String itemsText() {
        return SDLogcPlugin.getString("STR_ITEMS");
    }

    public int itemsTotalCount() {
        return this.eventsList.size();
    }

    public int maxItemsByPageCount() {
        return this.PAGE_SIZE;
    }

    public String noItemsText() {
        return SDLogcPlugin.getString("STR_ITEMS");
    }

    public String oneItemText() {
        return SDLogcPlugin.getString("STR_ITEM");
    }

    public int pagesCount() {
        return this.nrOfPages;
    }

    public void pageSettingsChanged(int n, int n2) {
        if (0 <= n2 && n2 < this.nrOfPages) {
            this.goToPage(n2);
        }
        if (n > this.MAX_NR_OF_RECORDS) {
            n = this.MAX_NR_OF_RECORDS;
        }
        if (this.PAGE_SIZE != n) {
            SDLogcPlugin.getDefault().getPreferenceStore().setValue("page_size", n);
            this.PAGE_SIZE = n;
        }
    }

    public void pageNumberChanged(int n) {
        this.goToPage(n);
    }

    public CorrelationContainerProxy getCorrelationContainerProxy() {
        return this.correlationContainerProxy;
    }

    public String getFrameName() {
        return MessageFormat.format(SDLogcPlugin.getString("STR_PAGE_INFO"), String.valueOf(this.currentPage() + 1), String.valueOf(this.nrOfPages));
    }

    static {
        LogInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName("");
        image = SDLogcPluginImages.getImage("log_obj.gif");
        traceCategories[0].setImage(image);
    }

    protected class LogRecordComparator
    implements Comparator {
        protected LogRecordComparator() {
        }

        public int compare(Object object, Object object2) {
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object)) > CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object2))) {
                return 1;
            }
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object)) == CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object2))) {
                if (((CBECommonBaseEvent)object).getSequenceNumber() > ((CBECommonBaseEvent)object2).getSequenceNumber()) {
                    return 1;
                }
                if (((CBECommonBaseEvent)object).getSequenceNumber() == ((CBECommonBaseEvent)object2).getSequenceNumber()) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    }

    public class TraceLifeline
    extends Lifeline {
        public EObject model;
        public int start;
        public int end;
    }

    public class LogInteractionsFrame
    extends Frame {
        public int getMaxEventOccurrence() {
            return super.getMaxEventOccurrence();
        }

        public List getLifelines() {
            return super.getLifelines();
        }
    }
}

