/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyFactoryImpl;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.TraceSelection;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

public class TraceUIManager
implements ISelectionChangedListener {
    private static TraceUIManager traceUIManager;
    protected ResourceSet resourceSet;
    protected HierarchyFactory factory;
    protected HashMap fSelectionModel = new HashMap();
    protected ProfileEvent fProfileEvent = new ProfileEvent();
    protected ViewSelectionChangedEvent pdViewEvent = new ViewSelectionChangedEvent();
    protected ProfileEvent updateModelEvent = new ProfileEvent(32);
    protected ProfileEvent refreshViewsEvent = new ProfileEvent(64);
    private boolean isLinkingEnabled = false;
    protected ListenerList fProfileEventListeners = new ListenerList(20);
    protected ListenerList fPDViewEventListeners = new ListenerList(20);
    protected List fSelectionParts = new ArrayList(2);
    protected List fSelectionProviders = new ArrayList(2);
    protected ListenerList fListeners = new ListenerList(2);
    protected ArrayList fDeleteListener = new ArrayList(1);

    private TraceUIManager() {
    }

    public static TraceUIManager getTraceUIManager() {
        if (traceUIManager == null) {
            traceUIManager = new TraceUIManager();
        }
        return traceUIManager;
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        this.fListeners.add((Object)iSelectionListener);
    }

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.fListeners.remove((Object)iSelectionListener);
    }

    public void addSelectionProvider(ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        this.fSelectionProviders.add(iSelectionProvider);
        this.fSelectionParts.add(iWorkbenchPart);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void deregisterLaunchProcess(IProcess iProcess) {
        ProcessAdapter processAdapter = (ProcessAdapter)iProcess;
        if (DebugPlugin.getDefault() != null) {
            ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            int n = 0;
            while (n < iLaunchArray.length) {
                ILaunch iLaunch = iLaunchArray[n];
                IProcess[] iProcessArray = iLaunch.getProcesses();
                int n2 = 0;
                while (n2 < iProcessArray.length) {
                    IProcess iProcess2 = iProcessArray[n2];
                    if (iProcess2.equals(processAdapter)) {
                        iLaunch.removeProcess(iProcess2);
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public HierarchyFactory getPerftraceFactory() {
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            HierarchyPackageImpl.init();
            this.factory = new HierarchyFactoryImpl();
            this.resourceSet = HierarchyResourceSetImpl.getInstance();
        }
        return this.resourceSet;
    }

    public void registerLaunchProcess(IProcess iProcess) {
        Launch launch = new Launch(null, "profile", null);
        ProcessAdapter processAdapter = (ProcessAdapter)iProcess;
        processAdapter.setLaunch((ILaunch)launch);
        launch.addProcess((IProcess)processAdapter);
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
        IConsole iConsole = this.getConsole(iProcess);
        this.showConsole(iConsole);
    }

    public void removeSelectionProvider(ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        this.fSelectionProviders.remove(iSelectionProvider);
        this.fSelectionParts.remove(iWorkbenchPart);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionChanged(null);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        int n;
        Object[] objectArray = this.fListeners.getListeners();
        ISelection iSelection = null;
        ISelectionProvider iSelectionProvider = null;
        IWorkbenchPart iWorkbenchPart = null;
        if (selectionChangedEvent != null) {
            iSelection = selectionChangedEvent.getSelection();
            iSelectionProvider = (ISelectionProvider)selectionChangedEvent.getSource();
            n = this.fSelectionProviders.indexOf(iSelectionProvider);
            if (n == -1) {
                return;
            }
        } else {
            return;
        }
        iWorkbenchPart = (IWorkbenchPart)this.fSelectionParts.get(n);
        this.selectionChanged(iWorkbenchPart, iSelection);
        n = 0;
        while (n < objectArray.length) {
            ISelectionListener iSelectionListener = (ISelectionListener)objectArray[n];
            iSelectionListener.selectionChanged(iWorkbenchPart, iSelection);
            ++n;
        }
    }

    private IConsole getConsole(IProcess iProcess) {
        IConsoleManager iConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = iConsoleManager.getConsoles();
        int n = 0;
        while (n < iConsoleArray.length) {
            ProcessConsole processConsole;
            IConsole iConsole = iConsoleArray[n];
            if (iConsole instanceof ProcessConsole && (processConsole = (ProcessConsole)iConsole).getProcess().equals(iProcess)) {
                return processConsole;
            }
            ++n;
        }
        return null;
    }

    private TRCProcessProxy getProcessFromInput(Object object) {
        TRCProcessProxy tRCProcessProxy = null;
        if (object instanceof TRCProcessProxy) {
            tRCProcessProxy = (TRCProcessProxy)object;
        } else if (object instanceof TRCAgentProxy) {
            tRCProcessProxy = ((TRCAgentProxy)object).getProcessProxy();
        }
        return tRCProcessProxy;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection != null && !iSelection.isEmpty()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IProcess iProcess = ProcessMap.get(this.getProcessFromInput(iStructuredSelection.getFirstElement()));
            IConsole iConsole = this.getConsole(iProcess);
            this.showConsole(iConsole);
        }
    }

    private void showConsole(IConsole iConsole) {
        IViewPart iViewPart;
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iViewPart = iWorkbenchPage.findView("org.eclipse.ui.console.ConsoleView")) != null && iViewPart instanceof IConsoleView) {
            ((IConsoleView)iViewPart).display(iConsole);
        }
    }

    public void dispose() {
        this.fListeners.clear();
        this.fDeleteListener.clear();
        this.fSelectionParts.clear();
        this.fSelectionProviders.clear();
        this.resourceSet = null;
        this.factory = null;
        this.fPDViewEventListeners.clear();
        this.fDeleteListener.clear();
        this.fProfileEventListeners.clear();
        this.fSelectionModel.clear();
        this.fProfileEvent = null;
        this.pdViewEvent = null;
        this.refreshViewsEvent = null;
        this.updateModelEvent = null;
        traceUIManager = null;
    }

    public void addProfileEventListener(IProfileEventListener iProfileEventListener) {
        this.fProfileEventListeners.add((Object)iProfileEventListener);
    }

    public void removeProfileEventListener(IProfileEventListener iProfileEventListener) {
        this.fProfileEventListeners.remove((Object)iProfileEventListener);
    }

    public void addDeleteListener(IDeleteListener iDeleteListener) {
        this.fDeleteListener.add(iDeleteListener);
    }

    public void addViewSelectionChangedListener(IViewSelectionChangedListener iViewSelectionChangedListener) {
        this.fPDViewEventListeners.add((Object)iViewSelectionChangedListener);
    }

    public void addSelectionModel(EObject eObject, ITraceSelection iTraceSelection) {
        this.fSelectionModel.put(eObject, iTraceSelection);
    }

    public ArrayList getDeleteListeners() {
        return this.fDeleteListener;
    }

    public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
        return this.pdViewEvent;
    }

    public ProfileEvent getProfileEvent() {
        return this.fProfileEvent;
    }

    public ProfileEvent getRefreshViewEvent(Object object) {
        this.refreshViewsEvent.setSource(object);
        return this.refreshViewsEvent;
    }

    public ITraceSelection getSelectionModel(EObject eObject) {
        Object object = this.fSelectionModel.get(eObject);
        if (object == null) {
            object = new TraceSelection();
            this.fSelectionModel.put(eObject, object);
        }
        return (ITraceSelection)object;
    }

    public ProfileEvent getUpdateModelEvent(Object object) {
        this.updateModelEvent.setSource(object);
        return this.updateModelEvent;
    }

    public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        Object[] objectArray = this.fPDViewEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IViewSelectionChangedListener)objectArray[n]).handleViewSelectionChangedEvent(viewSelectionChangedEvent);
            ++n;
        }
    }

    public void notifyProfileEventListener(ProfileEvent profileEvent) {
        Object[] objectArray = this.fProfileEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IProfileEventListener)objectArray[n]).handleProfileEvent(profileEvent);
            ++n;
        }
    }

    public void removeDeleteListener(IDeleteListener iDeleteListener) {
        this.fDeleteListener.remove(iDeleteListener);
    }

    public void removeViewSelectionChangedListener(IViewSelectionChangedListener iViewSelectionChangedListener) {
        this.fPDViewEventListeners.remove((Object)iViewSelectionChangedListener);
    }

    public void removeSelectionModel(EObject eObject) {
        this.fSelectionModel.remove(eObject);
    }
}

