/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.SaveUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class SaveAction
extends SelectionProviderAction
implements ISelectionChangedListener,
IRunnableWithProgress {
    private INavigator fViewer;
    private Object[] fSelections;
    private IResource fResSelection;
    private IResource[] fResSelections;
    private Shell fShell;

    public SaveAction(INavigator iNavigator) {
        super((ISelectionProvider)iNavigator.getViewer(), UIPlugin.getResourceString("SAVE"));
        this.setDescription(UIPlugin.getResourceString("SAVE"));
        PDPluginImages.setImageDescriptors((IAction)this, "lcl16", "save.gif");
        this.fViewer = iNavigator;
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".save0000"));
    }

    public void run() {
        String string = UIPlugin.getResourceString("TRACE_MSG");
        String string2 = "";
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getViewer().getSelection();
        this.fSelections = iStructuredSelection.toArray();
        this.fShell = this.fViewer.getViewSite().getShell();
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && iStructuredSelection instanceof IStructuredSelection) {
            string2 = iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() != null && iStructuredSelection.getFirstElement() instanceof IProject ? UIPlugin.getResourceString("SAVE_PROJECT_Q") : UIPlugin.getResourceString("SAVE_RES_Q");
        }
        if (!MessageDialog.openQuestion((Shell)this.fShell, (String)UIPlugin.getResourceString("SAVTOLOCACT_DIA_TITLE"), (String)string2)) {
            return;
        }
        int n = 0;
        int n2 = iStructuredSelection.size();
        this.fResSelections = new IResource[n2];
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            this.fResSelections[n++] = HyadesUtil.getSelectionFolder(iterator.next());
        }
        this.fResSelection = this.fResSelections[0];
        try {
            new ProgressMonitorDialog(this.fShell).run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this));
        }
        catch (InterruptedException interruptedException) {
            try {
                if (this.fResSelection != null && this.fResSelection.exists()) {
                    this.fResSelection.getProject().refreshLocal(2, null);
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            this.fResSelection = null;
            this.fResSelections = null;
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            this.fResSelection = null;
            this.fResSelections = null;
            return;
        }
        try {
            if (this.fResSelection != null && this.fResSelection.exists()) {
                this.fResSelection.getProject().refreshLocal(2, null);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.fResSelection = null;
        this.fResSelections = null;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        SaveUtil.save(Arrays.asList(this.fSelections), iProgressMonitor, this.fViewer.getID());
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        this.fResSelection = null;
        this.fResSelections = null;
        this.fShell = null;
        this.fSelections = null;
    }
}

