/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class EnvironmentDialog
extends Dialog
implements SelectionListener {
    private Table _table;
    private TableViewer _tableViewer;
    private Button _editBtn;
    private Button _addBtn;
    private Button _deleteBtn;
    private ArrayList _data = new ArrayList();
    private EnvList _envList;
    private boolean _buttonEnable;
    private String _title;

    public EnvironmentDialog(Shell shell, String string, ArrayList arrayList, boolean bl) {
        super(shell);
        this._title = string;
        this._buttonEnable = bl;
        if (arrayList != null) {
            this._data.addAll(arrayList);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 15;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 200;
        gridData.widthHint = 400;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(UIPlugin.getResourceString("ENV_VAR_DESC"));
        this.initializeTable(composite2);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        composite3.setLayoutData((Object)gridData);
        this._addBtn = new Button(composite3, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 128;
        this._addBtn.setLayoutData((Object)gridData);
        this._addBtn.setText(UIPlugin.getResourceString("ADD_BUTTON"));
        this._editBtn = new Button(composite3, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 128;
        this._editBtn.setLayoutData((Object)gridData);
        this._editBtn.setText(UIPlugin.getResourceString("EDIT_BUTTON"));
        this._deleteBtn = new Button(composite3, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 128;
        this._deleteBtn.setLayoutData((Object)gridData);
        this._deleteBtn.setText(UIPlugin.getResourceString("DELETE_TEXT"));
        this._table.addSelectionListener((SelectionListener)this);
        this._addBtn.addSelectionListener((SelectionListener)this);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._deleteBtn.addSelectionListener((SelectionListener)this);
        this._addBtn.setEnabled(this._buttonEnable);
        this._deleteBtn.setEnabled(false);
        this._editBtn.setEnabled(false);
        return composite2;
    }

    private void createColumns() {
        TableLayout tableLayout = new TableLayout();
        this._table.setLayout((Layout)tableLayout);
        this._table.setHeaderVisible(true);
        String[] stringArray = new String[]{UIPlugin.getResourceString("VARIABLE_TEXT"), UIPlugin.getResourceString("VALUE_TEXT")};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(280, true)};
        TableColumn[] tableColumnArray = new TableColumn[stringArray.length];
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            tableLayout.addColumnData(columnLayoutDataArray[n]);
            TableColumn tableColumn = new TableColumn(this._table, 0, n);
            tableColumn.setResizable(columnLayoutDataArray[n].resizable);
            tableColumn.setText(stringArray[n]);
            tableColumnArray[n] = tableColumn;
            ++n;
        }
    }

    protected void initializeTable(Composite composite) {
        this._table = new Table(composite, 68356);
        this._table.setLinesVisible(false);
        this._table.setLayoutData((Object)GridUtil.createFill());
        this._tableViewer = new TableViewer(this._table);
        this.createColumns();
        EnvContentProvider envContentProvider = new EnvContentProvider(this._tableViewer);
        this._tableViewer.setContentProvider((IContentProvider)new EnvContentProvider(this._tableViewer));
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new EnvLabelProvider());
        this._envList = new EnvList(envContentProvider);
        this.populateTable();
        this._tableViewer.setInput((Object)this._envList);
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void okPressed() {
        this._data.clear();
        int n = 0;
        while (n < this._envList.getSize()) {
            this._data.add(this._envList.getElementAt(n));
            ++n;
        }
        super.okPressed();
    }

    private void populateTable() {
        int n = 0;
        while (n < this._data.size()) {
            this._envList.add((EnvTableElement)this._data.get(n));
            ++n;
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        int n2;
        if (selectionEvent.widget == this._addBtn) {
            EditDialog editDialog = new EditDialog(this.getShell(), null, null);
            editDialog.open();
            if (editDialog.getReturnCode() == 0) {
                EnvTableElement envTableElement = new EnvTableElement(editDialog.name(), editDialog.value());
                if (envTableElement.name() != "") {
                    this._envList.add(envTableElement);
                }
                this._tableViewer.refresh();
            }
        } else if (selectionEvent.widget == this._editBtn) {
            int n3 = this._table.getSelectionIndex();
            if (n3 != -1) {
                EnvTableElement envTableElement = (EnvTableElement)this._envList.getElementAt(n3);
                EditDialog editDialog = new EditDialog(this.getShell(), envTableElement.name(), envTableElement.value());
                editDialog.open();
                if (editDialog.getReturnCode() == 0) {
                    envTableElement.value(editDialog.value());
                    envTableElement.name(editDialog.name());
                    this._tableViewer.refresh();
                }
            }
        } else if (selectionEvent.widget == this._deleteBtn && (n2 = this._table.getSelectionIndex()) != -1) {
            this._envList.removeElementAt(n2);
            this._tableViewer.refresh();
        }
        this._editBtn.setEnabled((n = this._table.getSelectionIndex()) != -1 && this._buttonEnable);
        this._deleteBtn.setEnabled(n != -1 && this._buttonEnable);
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private String _value;
        private Text _nameText;
        private Text _valueText;

        public EditDialog(Shell shell, String string, String string2) {
            super(shell);
            this._name = string;
            this._value = string2;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(UIPlugin.getResourceString("ENV_VARIABLE"));
        }

        public void name(String string) {
            this._name = string;
        }

        public String name() {
            return this._name;
        }

        public void value(String string) {
            this._value = string;
        }

        public String value() {
            return this._value;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridUtil.createFill();
            gridData.heightHint = 50;
            gridData.widthHint = 400;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(UIPlugin.getResourceString("VAR_NAME"));
            this._nameText = new Text(composite2, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(composite2, 0);
            label.setText(UIPlugin.getResourceString("VAR_VALUE"));
            this._valueText = new Text(composite2, 2048);
            this._valueText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._nameText.addModifyListener((ModifyListener)this);
            this._valueText.addModifyListener((ModifyListener)this);
            if (this._name != null) {
                this._nameText.setText(this._name);
            }
            if (this._value != null) {
                this._valueText.setText(this._value);
            }
            return composite2;
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if ((modifyEvent.widget == this._nameText || modifyEvent.widget == this._valueText) && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._nameText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            this._value = this._valueText.getText().trim();
            super.okPressed();
        }
    }

    class EnvLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public Image getColumnImage(Viewer viewer, Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (n == 0) {
                return ((EnvTableElement)object).name();
            }
            if (n == 1) {
                return ((EnvTableElement)object).value();
            }
            return "";
        }

        public String getColumnText(Viewer viewer, Object object, int n) {
            if (n == 0) {
                return ((EnvTableElement)object).name();
            }
            if (n == 1) {
                return ((EnvTableElement)object).value();
            }
            return "";
        }
    }

    class EnvContentProvider
    implements IStructuredContentProvider {
        private TableViewer _viewer;
        protected EnvTableElement fChangedElement;

        public EnvContentProvider(TableViewer tableViewer) {
            this._viewer = tableViewer;
        }

        public void dispose() {
        }

        public void elementChanged(EnvTableElement envTableElement, String string) {
            this.fChangedElement = envTableElement;
            this._viewer.getControl().getDisplay().asyncExec(new Runnable(this){
                private final /* synthetic */ EnvContentProvider this$1;
                {
                    this.this$1 = envContentProvider;
                }

                public void run() {
                    EnvContentProvider.access$000(this.this$1).refresh((Object)this.this$1.fChangedElement);
                }
            });
        }

        public Object[] getElements(Object object) {
            return ((EnvList)object).getValues().toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        static /* synthetic */ TableViewer access$000(EnvContentProvider envContentProvider) {
            return envContentProvider._viewer;
        }
    }

    class EnvList
    implements IBasicPropertyConstants {
        ArrayList _values = new ArrayList();
        EnvContentProvider _listener;

        public EnvList(EnvContentProvider envContentProvider) {
            this._listener = envContentProvider;
        }

        public void add(EnvTableElement envTableElement) {
            this.add(envTableElement, -1);
        }

        public void add(EnvTableElement envTableElement, int n) {
            if (n < 0) {
                this._values.add(envTableElement);
            } else {
                this._values.add(n, envTableElement);
            }
        }

        public void fireElementChanged(EnvTableElement envTableElement, String string) {
            this._listener.elementChanged(envTableElement, string);
        }

        public Object getElementAt(int n) {
            return this._values.get(n);
        }

        public ArrayList getValues() {
            return this._values;
        }

        public int getSize() {
            return this._values.size();
        }

        public void removeAll() {
            this._values.clear();
        }

        public Object removeElementAt(int n) {
            Object e = this._values.get(n);
            if (e == null) {
                return null;
            }
            this._values.remove(e);
            return e;
        }
    }
}

