/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceLocationUI
extends AbstractChangeable
implements SelectionListener {
    private Button _browseLocation;
    private Text _location;
    private Text _monitor;
    private Button _browseMonitor;
    private Label _locationLabel;

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createHorizontalFill();
        composite2.setLayoutData((Object)gridData);
        this._locationLabel = new Label(composite2, 0);
        this._locationLabel.setText(UIPlugin.getResourceString("STR_TRACE_LOCATION"));
        this._location = new Text(composite2, 2048);
        this._location.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._browseLocation = new Button(composite2, 0);
        this._browseLocation.setText(UIPlugin.getResourceString("BROWSE"));
        Label label = new Label(composite2, 0);
        label.setText(UIPlugin.getResourceString("STR_MON_LOCATION"));
        this._monitor = new Text(composite2, 2048);
        this._monitor.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._browseMonitor = new Button(composite2, 0);
        this._browseMonitor.setText(UIPlugin.getResourceString("BROWSE1"));
        this._browseLocation.addSelectionListener((SelectionListener)this);
        this._browseMonitor.addSelectionListener((SelectionListener)this);
        this._location.setFocus();
        WorkbenchHelp.setHelp((Control)this._location, (String)(UIPlugin.getPluginId() + ".tloc0001"));
        WorkbenchHelp.setHelp((Control)this._browseLocation, (String)(UIPlugin.getPluginId() + ".tloc0002"));
        WorkbenchHelp.setHelp((Control)this._monitor, (String)(UIPlugin.getPluginId() + ".tloc0003"));
        WorkbenchHelp.setHelp((Control)this._browseMonitor, (String)(UIPlugin.getPluginId() + ".tloc0004"));
        this.initialize();
        return composite2;
    }

    public void initialize() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this._location.setText(iPreferenceStore.getString("prj_name"));
        this._monitor.setText(iPreferenceStore.getString("mon_name"));
    }

    public Label getLocationLabel() {
        return this._locationLabel;
    }

    public Text getLocation() {
        return this._location;
    }

    public Text getMonitor() {
        return this._monitor;
    }

    public void setEnabled(boolean bl) {
        this._location.setEnabled(bl);
        this._browseLocation.setEnabled(bl);
        this._monitor.setEnabled(bl);
        this._browseMonitor.setEnabled(bl);
    }

    public void setEnabledBrowse(boolean bl) {
        this._browseLocation.setEnabled(bl);
        this._browseMonitor.setEnabled(bl);
    }

    public void setEnabledLocation(boolean bl) {
        this._location.setEnabled(bl);
    }

    public void setLocation(String string) {
        this._location.setText(string);
    }

    public void setMonitor(String string) {
        this._monitor.setText(string);
    }

    private void showMonitorsDialog() {
        Object[] objectArray;
        MonitorSelectionDialog monitorSelectionDialog = new MonitorSelectionDialog(UIPlugin.getActiveWorkbenchShell(), UIPlugin.getResourceString("STR_RES_DLG_MSG"));
        if (monitorSelectionDialog.open() == 0 && (objectArray = monitorSelectionDialog.getResult()) != null && objectArray.length == 1 && objectArray[0] != null) {
            IPath iPath = (IPath)objectArray[0];
            this._monitor.setText(iPath.lastSegment());
            this._location.setText(iPath.uptoSegment(iPath.segmentCount() - 1).toOSString());
            this._monitor.setFocus();
        }
    }

    private void showResourceDialog() {
        ContainerSelectionDialog containerSelectionDialog;
        Path path = new Path(this._location.getText().trim());
        IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
        IContainer iContainer = null;
        if (iResource != null && iResource.exists() && iResource instanceof IContainer) {
            iContainer = (IContainer)iResource;
        }
        if ((containerSelectionDialog = new ContainerSelectionDialog(UIPlugin.getActiveWorkbenchShell(), iContainer, true, UIPlugin.getResourceString("STR_RES_DLG_MSG"))).open() == 0) {
            Object[] objectArray = containerSelectionDialog.getResult();
            if (objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                this._location.setText(((IPath)objectArray[0]).toOSString());
            }
            this._location.setFocus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._browseLocation) {
            this.showResourceDialog();
        } else if (selectionEvent.widget == this._browseMonitor) {
            this.showMonitorsDialog();
        }
    }
}

