/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.editors;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TRCMonitorEditor
extends EditorPart {
    private TRCMonitor fMonitor;

    public void createPartControl(Composite composite) {
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".mone0000"));
        TraceLocationUI traceLocationUI = new TraceLocationUI();
        Composite composite2 = traceLocationUI.createControl(composite);
        traceLocationUI.setEnabled(false);
        if (this.fMonitor == null) {
            return;
        }
        Path path = new Path(TString.resourcePath(this.fMonitor.eResource().getURI()));
        traceLocationUI.getLocation().setText(path.uptoSegment(path.segmentCount() - 1).toOSString());
        traceLocationUI.getMonitor().setText(this.fMonitor.getName());
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (iEditorInput instanceof IFileEditorInput) {
            this.setSite((IWorkbenchPartSite)iEditorSite);
            this.setInput(iEditorInput);
            this.loadMonitorDoc();
            if (this.fMonitor != null) {
                this.setTitle(this.fMonitor.getName());
            } else {
                this.setTitle("Unknown monitor");
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private TRCMonitor loadMonitorDoc() {
        block4: {
            if (this.fMonitor != null) break block4;
            try {
                String string = ((FileEditorInput)this.getEditorInput()).getFile().getFullPath().toString();
                ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)("platform:/resource" + string)), true);
                if (resource == null) {
                    return this.fMonitor;
                }
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof TRCMonitor)) continue;
                    this.fMonitor = (TRCMonitor)e;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fMonitor;
    }

    public void setFocus() {
    }
}

