/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileHostTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ProfileMainTab
extends AbstractLaunchConfigurationTab {
    private LaunchProcessUI _ui;
    private ProfileHostTab _hostTab;

    public ProfileMainTab(ProfileHostTab profileHostTab) {
        this._hostTab = profileHostTab;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(composite2, 1);
        this._ui = new LaunchProcessUI();
        this._ui.createControl(composite2);
        this._ui.enable(true, true, this._hostTab.isLocal(), this._hostTab.isLocal(), true);
        this._ui.addListener(new Listener(){

            public void handleEvent(Event event) {
                ProfileMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this._ui.enable(true, true, this._hostTab.isLocal(), this._hostTab.isLocal(), true);
        try {
            String string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            String string2 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, "");
            String string3 = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            String string4 = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            ArrayList<EnvTableElement> arrayList = new ArrayList<EnvTableElement>();
            Map map = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_ENVIRONMENT_VARIABLES, (Map)null);
            if (map != null) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    arrayList.add(new EnvTableElement(string5, (String)map.get(string5)));
                }
            }
            this._ui.setClassName(string);
            this._ui.setClassPath(string2);
            this._ui.setProgramArgs(string3);
            this._ui.setVMArgs(string4);
            this._ui.setEnvData(arrayList);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this._ui.getClassName());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, this._ui.getClassPath());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this._ui.getParameters());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this._ui.getVMArgs());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = this._ui.getEnvData().iterator();
        while (iterator.hasNext()) {
            EnvTableElement envTableElement = (EnvTableElement)iterator.next();
            hashMap.put(envTableElement.name(), envTableElement.value());
        }
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_ENVIRONMENT_VARIABLES, hashMap);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this._ui.getClassName().trim().length() == 0) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_MAIN"));
            return false;
        }
        if (this._ui.getClassPath().trim().length() == 0) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_CLASSPATH"));
            return false;
        }
        return true;
    }

    public String getName() {
        return UIPlugin.getResourceString("TAB_NAME_MAIN");
    }

    public Image getImage() {
        return PDPluginImages.getImage("class_obj.gif");
    }
}

