/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.piclient;

import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.AgentPeerListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PIProcessListener
implements ProcessListener,
AgentPeerListener {
    protected ArrayList _monitoredAgents = new ArrayList();
    protected ArrayList _processVariableList = new ArrayList();
    protected TRCNode fNode;
    protected TRCProcessProxy fProcess;
    protected boolean _autoMonitoring = true;
    protected boolean _monitor = false;
    protected int _launchMode = 0;

    public PIProcessListener(TRCNode tRCNode) {
        this.fNode = tRCNode;
    }

    public PIProcessListener(TRCNode tRCNode, TRCProcessProxy tRCProcessProxy) {
        this(tRCNode);
        this.fProcess = tRCProcessProxy;
    }

    public void setAutoMonitoring(boolean bl) {
        this._autoMonitoring = bl;
    }

    public void setLaunchMode(int n) {
        this._launchMode = n;
    }

    public ArrayList getProcessVariableList() {
        return this._processVariableList;
    }

    public synchronized void agentActive(Agent agent) {
        Object object;
        CustomCommand customCommand;
        if (this.fProcess == null) {
            return;
        }
        if (this._monitoredAgents.contains(agent.getName())) {
            this._monitor = false;
        } else {
            this._monitoredAgents.add(agent.getName());
        }
        if (!this._monitor) {
            return;
        }
        TRCAgentProxy tRCAgentProxy = PDCoreUtil.getCorrespondingAgent(this.fProcess, agent, false);
        if (tRCAgentProxy == null) {
            return;
        }
        tRCAgentProxy.setRuntimeId(agent.getUUID());
        LoadersUtils.registerAgentInstance((TRCAgentProxy)tRCAgentProxy, (Object)agent);
        tRCAgentProxy.setAttached(true);
        tRCAgentProxy.setProfileFile(agent.getProfileFile());
        if (tRCAgentProxy.isActive()) {
            final TRCAgentProxy tRCAgentProxy2 = tRCAgentProxy;
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                    profileEvent.setSource(tRCAgentProxy2);
                    profileEvent.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                }
            });
            return;
        }
        tRCAgentProxy.setActive(true);
        try {
            agent.publishConfiguration();
            customCommand = new CustomCommand();
            customCommand.setData("APPLYFILTERS");
            agent.invokeCustomCommand(customCommand);
            object = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)tRCAgentProxy);
            if (object == null) {
                object = new XMLTraceDataProcessor(tRCAgentProxy);
                LoadersUtils.registerDataProcessor((TRCAgentProxy)tRCAgentProxy, (XMLLoader)object);
            }
            if (tRCAgentProxy.isToProfileFile()) {
                ((XMLTraceDataProcessor)((Object)object)).setProfileFileName(tRCAgentProxy.getProfileFile());
                ((XMLTraceDataProcessor)((Object)object)).createWriter();
                if (((XMLTraceDataProcessor)((Object)object)).isNewProfileFile()) {
                    ((XMLTraceDataProcessor)((Object)object)).writeXMLVersion(((XMLTraceDataProcessor)((Object)object)).getWriter());
                    ((XMLTraceDataProcessor)((Object)object)).startTrace(((XMLTraceDataProcessor)((Object)object)).getWriter());
                }
            }
            tRCAgentProxy.setAttached(true);
            if (this._autoMonitoring) {
                agent.startMonitoring((DataProcessor)object);
                tRCAgentProxy.setMonitored(true);
            }
            tRCAgentProxy.setCollectionData(true);
            customCommand.setData("RESUME");
            agent.invokeCustomCommand(customCommand);
        }
        catch (InactiveAgentException inactiveAgentException) {
            inactiveAgentException.printStackTrace();
        }
        customCommand = tRCAgentProxy;
        object = Display.getDefault();
        object.asyncExec(new Runnable((TRCAgentProxy)customCommand){
            private final /* synthetic */ TRCAgentProxy val$agentTemp;
            {
                this.val$agentTemp = tRCAgentProxy;
            }

            public void run() {
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource(this.val$agentTemp);
                profileEvent.setType(1);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            }
        });
    }

    public synchronized void agentInactive(Agent agent) {
        if (this.fProcess == null) {
            return;
        }
        TRCAgentProxy tRCAgentProxy = PDCoreUtil.getCorrespondingAgent(this.fProcess, agent, true);
        if (tRCAgentProxy == null) {
            return;
        }
        tRCAgentProxy.setActive(false);
        tRCAgentProxy.setAttached(false);
        tRCAgentProxy.setMonitored(false);
        this.fProcess.setActive(false);
        final TRCAgentProxy tRCAgentProxy2 = tRCAgentProxy;
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource(tRCAgentProxy2);
                profileEvent.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            }
        });
    }

    public void dispose() {
        this._monitoredAgents.clear();
        this.fNode = null;
        this.fProcess = null;
        this._processVariableList.clear();
    }

    public void error(Agent agent, String string, String string2) {
        final String string3 = string2;
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                Status status = new Status(2, "org.eclipse.core.resources", 566, string3, null);
                ErrorDialog.openError((Shell)new Shell(), (String)UIPlugin.getResourceString("LAUNCH_JAVA_PROBLEM_ERROR_"), (String)UIPlugin.getResourceString("PROBLEM_WHILE_PROCESS_WARN_"), (IStatus)status);
            }
        });
    }

    public void handleCommand(Agent agent, CommandElement commandElement) {
    }

    public void monitor(boolean bl) {
        this._monitor = bl;
        this._monitoredAgents.clear();
    }

    public void peerWaiting(Agent agent, Agent agent2) {
        final TRCMonitor tRCMonitor = this.fNode.getMonitor();
        final Process process = agent2.getProcess();
        final Agent agent3 = agent2;
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                Node node;
                TRCNode tRCNode = null;
                try {
                    node = process.getNode();
                    tRCNode = PDCoreUtil.createNode(tRCMonitor, node.getName(), String.valueOf(node.getConnection().getPort()));
                }
                catch (InactiveProcessException inactiveProcessException) {
                    inactiveProcessException.printStackTrace();
                    return;
                }
                node = PDCoreUtil.createProcess(tRCNode, process);
                node.setActive(true);
                TRCAgentProxy tRCAgentProxy = PDCoreUtil.createAgent((TRCProcessProxy)node, agent3);
                PIProcessListener pIProcessListener = (PIProcessListener)LoadersUtils.locateAgentListener((TRCAgentProxy)tRCAgentProxy);
                if (pIProcessListener == null) {
                    pIProcessListener = new PIProcessListener(tRCNode, (TRCProcessProxy)node);
                    LoadersUtils.registerAgentListener((TRCAgentProxy)tRCAgentProxy, (Object)pIProcessListener);
                    agent3.addAgentListener((AgentListener)pIProcessListener);
                } else {
                    agent3.addAgentListener((AgentListener)pIProcessListener);
                }
                pIProcessListener.monitor(true);
                LoadersUtils.registerAgentInstance((TRCAgentProxy)tRCAgentProxy, (Object)agent3);
                XMLTraceDataProcessor xMLTraceDataProcessor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)tRCAgentProxy);
                if (xMLTraceDataProcessor == null) {
                    xMLTraceDataProcessor = new XMLTraceDataProcessor(tRCAgentProxy);
                    LoadersUtils.registerDataProcessor((TRCAgentProxy)tRCAgentProxy, (XMLLoader)xMLTraceDataProcessor);
                }
                if (agent3.isAttached()) {
                    try {
                        agent3.startMonitoring((DataProcessor)xMLTraceDataProcessor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    tRCAgentProxy.setCollectionData(true);
                    tRCAgentProxy.setActive(true);
                    tRCAgentProxy.setAttached(true);
                    tRCAgentProxy.setMonitored(true);
                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                    profileEvent.setSource(tRCAgentProxy);
                    profileEvent.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                    return;
                }
                XMLTraceDataProcessor xMLTraceDataProcessor2 = xMLTraceDataProcessor;
                agent3.addAgentListener(new AgentListener(this, tRCAgentProxy, xMLTraceDataProcessor2){
                    private final /* synthetic */ TRCAgentProxy val$ag;
                    private final /* synthetic */ XMLTraceDataProcessor val$processor;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$ag = tRCAgentProxy;
                        this.val$processor = xMLTraceDataProcessor;
                    }

                    public void agentActive(Agent agent) {
                        try {
                            if (!agent.isMonitored()) {
                                this.val$ag.setCollectionData(true);
                                agent.startMonitoring((DataProcessor)this.val$processor);
                            }
                        }
                        catch (Exception exception) {
                            Status status = new Status(2, "org.eclipse.core.resources", 566, exception.toString(), null);
                            ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("LAUNCH_JAVA_PROBLEM_ERROR_"), (String)UIPlugin.getResourceString("PROBLEM_WHILE_PROCESS_WARN_"), (IStatus)status);
                            exception.printStackTrace();
                        }
                    }

                    public void agentInactive(Agent agent) {
                    }

                    public void error(Agent agent, String string, String string2) {
                    }

                    public void handleCommand(Agent agent, CommandElement commandElement) {
                    }
                });
                try {
                    agent3.attach();
                }
                catch (InactiveAgentException inactiveAgentException) {
                    inactiveAgentException.printStackTrace();
                }
                catch (InactiveProcessException inactiveProcessException) {
                    inactiveProcessException.printStackTrace();
                }
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource(tRCAgentProxy);
                profileEvent.setType(128);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            }
        });
    }

    public synchronized void processExited(Process process) {
        if (this.fProcess != null) {
            this.fProcess.setActive(false);
        }
    }

    public synchronized void processLaunched(Process process) {
        try {
            if (process.getProcessId() == null || process.getProcessId().equals("-1")) {
                return;
            }
            this.fProcess = this.createProcess(process);
            if (this.fProcess == null) {
                return;
            }
            Enumeration enumeration = process.listAgents();
            while (enumeration.hasMoreElements()) {
                this.createAgent((Agent)enumeration.nextElement(), this.fProcess);
            }
        }
        catch (InactiveProcessException inactiveProcessException) {
            String string = UIPlugin.getResourceString("LAUNCH_ERROR_");
            string = TString.change(string, "%1", process.getName());
            String string2 = UIPlugin.getResourceString("RAC_CONFIG_ERROR_");
            Status status = new Status(2, "org.eclipse.core.resources", 566, string2, null);
            ErrorDialog.openError((Shell)UIPlugin.getDefault().getViewer().getShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)string, (IStatus)status);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Agent sendConfigurationToAgent(TRCAgentProxy tRCAgentProxy, String string, String string2) {
        try {
            Node node = PDCoreUtil.profileConnect(string, String.valueOf(tRCAgentProxy.getProcessProxy().getNode().getPort()));
            if (node == null) {
                return null;
            }
            Process process = node.getProcess(string2);
            if (process != null) {
                Agent agent = process.getAgent(tRCAgentProxy.getName());
                PDCoreUtil.setAgentConfiguration(tRCAgentProxy, agent);
                if (agent != null && agent.isActive()) {
                    agent.publishConfiguration();
                    CustomCommand customCommand = new CustomCommand();
                    customCommand.setData("APPLYFILTERS");
                    agent.invokeCustomCommand(customCommand);
                }
                return agent;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private void addEnvironment(TRCProcessProxy tRCProcessProxy) {
        int n = 0;
        while (n < this._processVariableList.size()) {
            Variable variable = (Variable)this._processVariableList.get(n);
            HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
            if (!variable.getName().equals("UICLASSPATH")) {
                TRCEnvironmentVariable tRCEnvironmentVariable = hierarchyFactory.createTRCEnvironmentVariable();
                tRCEnvironmentVariable.setName(variable.getName());
                tRCEnvironmentVariable.setValue(variable.getValue());
                tRCProcessProxy.getEnvironmentVariables().add((Object)tRCEnvironmentVariable);
            } else {
                tRCProcessProxy.setClasspath(variable.getValue());
            }
            ++n;
        }
    }

    private TRCAgentProxy createAgent(Agent agent, TRCProcessProxy tRCProcessProxy) {
        if (tRCProcessProxy == null) {
            return null;
        }
        TRCAgentProxy tRCAgentProxy = PDCoreUtil.createAgent(tRCProcessProxy, agent);
        LoadersUtils.registerAgentListener((TRCAgentProxy)tRCAgentProxy, (Object)this);
        return tRCAgentProxy;
    }

    private TRCProcessProxy createProcess(Process process, TRCNode tRCNode) {
        try {
            String string;
            String string2;
            TRCNode tRCNode2 = tRCNode;
            TRCMonitor tRCMonitor = tRCNode2.getMonitor();
            String string3 = process.getProcessId();
            if (string3 == null) {
                string3 = "-1";
            }
            if ((string2 = process.getParameters()) == null) {
                string2 = "unknown";
            }
            String string4 = "";
            String string5 = "";
            if (process.getExecutable().startsWith("java")) {
                int n;
                string = process.getParameters();
                if (string == null) {
                    string = "unknown";
                }
                if (!string.startsWith("-X")) {
                    string = "-X " + string;
                }
                if ((n = string.indexOf(" ")) != -1 && n < string.length() + 1) {
                    string = string.substring(n + 1);
                }
                while (string.startsWith("-")) {
                    n = this.findVMendIdx(string);
                    if (n != -1) {
                        string5 = string5 + " " + string.substring(0, n);
                        string = string.substring(n + 1);
                        continue;
                    }
                    string5 = string;
                    string = "";
                }
                n = string.indexOf(" ");
                if (n != -1) {
                    string4 = string.substring(n);
                    string = string.substring(0, n);
                }
                string2 = string;
            }
            if ((string = ((ProcessImpl)process).getUUID()) == null) {
                string = "";
            }
            String string6 = tRCMonitor.getName() + "_" + tRCNode2.getName() + "_" + TString.change(string2, " ", "") + string3 + "_" + string + "." + "trcpxmi";
            String string7 = tRCNode2.eResource().getURI().toString();
            Path path = new Path(string7);
            if (path.segmentCount() > 1) {
                string7 = path.removeLastSegments(1).toString();
            }
            IPath iPath = new Path(string7).append(string6);
            URI uRI = URI.createURI((String)iPath.toString());
            HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
            Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
            resource.setModified(true);
            EList eList = resource.getContents();
            UIPlugin.getDefault().getResourceSet().getResources().add((Object)resource);
            TRCProcessProxy tRCProcessProxy = hierarchyFactory.createTRCProcessProxy();
            tRCProcessProxy.setPid(Integer.parseInt(string3));
            tRCProcessProxy.setRuntimeId(string);
            tRCProcessProxy.setName(string2);
            tRCProcessProxy.setLocation(((ProcessImpl)process).getlocation());
            tRCProcessProxy.setNode(tRCNode2);
            this.addEnvironment(tRCProcessProxy);
            tRCProcessProxy.setParameters(string4.trim());
            tRCProcessProxy.setVmArguments(string5.trim());
            tRCProcessProxy.setLaunchMode(this._launchMode);
            tRCProcessProxy.setActive(true);
            eList.add((Object)tRCProcessProxy);
            tRCNode2.getProcessProxies().add((Object)tRCProcessProxy);
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                    profileEvent.setSource(null);
                    profileEvent.setType(128);
                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                }
            });
            this._processVariableList.clear();
            return tRCProcessProxy;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private TRCProcessProxy createProcess(Process process) {
        return this.createProcess(process, this.fNode);
    }

    private int findVMendIdx(String string) {
        int n;
        String string2 = " ";
        String string3 = "\"";
        int n2 = 0;
        int n3 = string.indexOf(string2);
        if (n3 != -1 && (n = string.substring(n2, n3).indexOf(string3)) != -1) {
            n2 = n3 + string.substring(n3 + 1).indexOf(string3) + 1;
            n3 = n2 + this.findVMendIdx(string.substring(n2 + 1)) + 1;
        }
        return n3;
    }
}

