/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLogUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class LoggingAgentsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TraceLogUI _options;

    public LoggingAgentsPreferencePage() {
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
    }

    private void addAgents(String string) {
        if (string != null && !string.equals("")) {
            int n = 0;
            while (n != -1) {
                n = string.indexOf(",");
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    this._options.addAgent(string2);
                    string = string.substring(n + 1);
                    continue;
                }
                this._options.addAgent(string);
            }
        }
    }

    protected Control createContents(Composite composite) {
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".lapp0000"));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this._options = new TraceLogUI();
        this._options.createControl(composite2);
        this.initializeValues();
        return composite2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this._options.reset();
        String string = iPreferenceStore.getDefaultString("log_agents");
        this.addAgents(string);
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = iPreferenceStore.getString("log_agents");
        this.addAgents(string);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = "";
        String[] stringArray = this._options.getAgents();
        int n = 0;
        while (n < stringArray.length) {
            string = string + "," + stringArray[n].trim();
            ++n;
        }
        if (string.startsWith(",") && string.length() > 1) {
            string = string.substring(1);
        }
        iPreferenceStore.setValue("log_agents", string);
    }
}

