/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.EMFUtil;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMIResourceImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;

public class DeleteUtil {
    public static void deleteAgent(TRCAgentProxy tRCAgentProxy, boolean bl, boolean bl2) {
        if (tRCAgentProxy == null) {
            return;
        }
        TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        if (tRCProcessProxy == null) {
            return;
        }
        DeleteUtil.deleteExternalItems(tRCAgentProxy, bl, bl2);
        DeleteUtil.removeDoc(tRCAgentProxy, bl2);
        tRCAgentProxy.setProcessProxy(null);
        if (tRCProcessProxy.getAgentProxies().size() == 0) {
            DeleteUtil.deleteProcess(tRCProcessProxy, bl, bl2);
        }
        if (bl) {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public static void deleteMonitor(TRCMonitor tRCMonitor, boolean bl, boolean bl2) {
        Object object;
        TRCNode tRCNode;
        if (tRCMonitor == null) {
            return;
        }
        Iterator iterator = tRCMonitor.getNodes().iterator();
        while (iterator.hasNext()) {
            tRCNode = (TRCNode)iterator.next();
            object = tRCNode.getProcessProxies().iterator();
            while (object.hasNext()) {
                TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)object.next();
                Iterator iterator2 = tRCProcessProxy.getAgentProxies().iterator();
                while (iterator2.hasNext()) {
                    TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator2.next();
                    DeleteUtil.deleteExternalItems(tRCAgentProxy, bl, bl2);
                }
                DeleteUtil.deleteExternalItems(tRCProcessProxy, bl, bl2);
            }
            DeleteUtil.deleteExternalItems(tRCNode, bl, bl2);
        }
        DeleteUtil.deleteExternalItems(tRCMonitor, bl, bl2);
        tRCNode = new Path(TString.resourcePath(tRCMonitor.eResource().getURI()));
        if (tRCNode.segmentCount() > 1) {
            tRCNode = tRCNode.removeLastSegments(1);
        }
        PDContentProvider.removeMonitor(tRCNode.toOSString(), tRCMonitor);
        DeleteUtil.removeDoc(tRCMonitor, bl2);
        if (bl) {
            object = UIPlugin.getDefault().getProfileEvent();
            ((ProfileEvent)object).setSource(null);
            ((ProfileEvent)object).setType(128);
            UIPlugin.getDefault().notifyProfileEventListener((ProfileEvent)object);
        }
    }

    public static void deleteNode(TRCNode tRCNode, boolean bl, boolean bl2) {
        if (tRCNode == null) {
            return;
        }
        TRCMonitor tRCMonitor = tRCNode.getMonitor();
        if (tRCMonitor == null) {
            return;
        }
        if (tRCMonitor.getNodes().size() == 1) {
            DeleteUtil.deleteMonitor(tRCMonitor, bl, bl2);
        } else {
            DeleteUtil.removeDoc(tRCNode, bl2);
            DeleteUtil.deleteExternalItems(tRCNode, bl, bl2);
            tRCNode.setMonitor(null);
        }
        if (bl) {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public static void deleteProcess(TRCProcessProxy tRCProcessProxy, boolean bl, boolean bl2) {
        if (tRCProcessProxy == null) {
            return;
        }
        TRCNode tRCNode = tRCProcessProxy.getNode();
        if (tRCNode == null) {
            return;
        }
        if (tRCNode.getProcessProxies().size() == 1) {
            DeleteUtil.deleteNode(tRCNode, bl, bl2);
        } else {
            DeleteUtil.removeDoc(tRCProcessProxy, bl2);
            DeleteUtil.deleteExternalItems(tRCProcessProxy, bl, bl2);
            tRCProcessProxy.setNode(null);
        }
        if (bl) {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public static void deleteContainer(IContainer iContainer, boolean bl) throws CoreException {
        if (iContainer == null || !iContainer.exists()) {
            return;
        }
        IResource[] iResourceArray = iContainer.members();
        if (iResourceArray.length > 0) {
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n] instanceof IFolder) {
                    IFolder iFolder = (IFolder)iResourceArray[n];
                    DeleteUtil.deleteContainer((IContainer)iFolder, bl);
                }
                ++n;
            }
        }
        ArrayList arrayList = PDContentProvider.getMonitors(iContainer);
        int n = 0;
        while (n < arrayList.size()) {
            TRCMonitor tRCMonitor;
            if (arrayList.get(n) instanceof TRCMonitor && (tRCMonitor = (TRCMonitor)arrayList.get(n)) != null) {
                DeleteUtil.deleteMonitor(tRCMonitor, true, bl);
            }
            ++n;
        }
        DeleteUtil.deleteExternalItems(iContainer, true, bl);
        PDContentProvider.removeContainer(iContainer);
        iContainer.delete(true, null);
    }

    public static void deleteResource(IResource iResource, boolean bl) {
        if (iResource == null) {
            return;
        }
        try {
            IContainer iContainer = iResource.getParent();
            if (iResource == null || !iResource.exists()) {
                return;
            }
            if (iResource instanceof IProject || iResource instanceof IFolder) {
                DeleteUtil.deleteContainer((IContainer)iResource, bl);
            } else {
                iResource.delete(true, null);
            }
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static void deleteExternalItems(Object object, boolean bl, boolean bl2) {
        INavigatorContribution[] iNavigatorContributionArray = NavigatorExtensionUtil.getContributions(null);
        int n = 0;
        while (n < iNavigatorContributionArray.length) {
            List list = iNavigatorContributionArray[n].getChildren(object);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                INavigatorItem iNavigatorItem = (INavigatorItem)iterator.next();
                if (!iNavigatorItem.isDeleteEnabled()) continue;
                iNavigatorItem.delete(bl, bl2);
            }
            ++n;
        }
    }

    public static void removeDoc(TRCAgentProxy tRCAgentProxy, boolean bl) {
        Node node;
        Object object;
        ArrayList arrayList;
        if (tRCAgentProxy == null || tRCAgentProxy.getAgent() == null || tRCAgentProxy.getAgent().eResource() == null) {
            return;
        }
        XMLLoader xMLLoader = LoadersUtils.locateDataProcessor((TRCAgentProxy)tRCAgentProxy);
        if (xMLLoader != null && xMLLoader instanceof XMLTraceDataProcessor) {
            ((XMLTraceDataProcessor)xMLLoader).dispose();
        }
        LoadersUtils.deregisterDataProcessor((TRCAgentProxy)tRCAgentProxy);
        Object object2 = LoadersUtils.locateAgentListener((TRCAgentProxy)tRCAgentProxy);
        if (object2 != null && object2 instanceof PIProcessListener) {
            ((PIProcessListener)object2).dispose();
        }
        LoadersUtils.deregisterAgentListener((TRCAgentProxy)tRCAgentProxy);
        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)tRCAgentProxy);
        LoadersUtils.deregisterAgentProxyContext((TRCAgentProxy)tRCAgentProxy);
        if (bl) {
            arrayList = new Path(TString.resourcePath(tRCAgentProxy.getAgent().eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)arrayList);
            DeleteUtil.deleteResource(iResource, true);
        }
        arrayList = UIPlugin.getDefault().getDeleteListeners();
        int n = 0;
        while (n < arrayList.size()) {
            ((IDeleteListener)arrayList.get(n)).deregister(tRCAgentProxy);
            ++n;
        }
        TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        TRCNode tRCNode = tRCProcessProxy.getNode();
        if (tRCProcessProxy == null || tRCNode == null) {
            return;
        }
        try {
            Agent agent;
            Object object3;
            object = tRCNode.getName();
            node = NodeFactory.createNode((String)object);
            if (node.isConnected() && (object3 = LoadersUtils.locateAgentInstance((TRCAgentProxy)tRCAgentProxy)) != null && object3 instanceof Agent && (agent = (Agent)object3).isAttached()) {
                agent.detach();
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DeleteUtil.unloadDoc((EObject)tRCAgentProxy.getAgent());
        object = EMFUtil.delete((EObject)tRCAgentProxy, (ResourceSet)tRCAgentProxy.eResource().getResourceSet()).iterator();
        while (object.hasNext()) {
            node = (Resource)object.next();
            if (node == null) continue;
            node.setModified(true);
        }
    }

    public static void removeDoc(TRCMonitor tRCMonitor, boolean bl) {
        Path path;
        if (tRCMonitor == null) {
            return;
        }
        ArrayList arrayList = UIPlugin.getDefault().getDeleteListeners();
        int n = 0;
        while (n < arrayList.size()) {
            ((IDeleteListener)arrayList.get(n)).deregister(tRCMonitor);
            ++n;
        }
        if (tRCMonitor.eResource() != null && bl) {
            path = new Path(TString.resourcePath(tRCMonitor.eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(iResource, true);
        }
        path = tRCMonitor.getNodes().toArray();
        int n2 = 0;
        while (n2 < ((Path)path).length) {
            TRCNode tRCNode = (TRCNode)path[n2];
            if (!tRCNode.eIsProxy()) {
                DeleteUtil.removeDoc(tRCNode, bl);
            }
            ++n2;
        }
        DeleteUtil.unloadDoc((EObject)tRCMonitor);
    }

    public static void removeDoc(TRCNode tRCNode, boolean bl) {
        TRCMonitor tRCMonitor;
        Path path;
        if (tRCNode == null) {
            return;
        }
        ArrayList arrayList = UIPlugin.getDefault().getDeleteListeners();
        int n = 0;
        while (n < arrayList.size()) {
            ((IDeleteListener)arrayList.get(n)).deregister(tRCNode);
            ++n;
        }
        if (tRCNode.eResource() != null && bl) {
            path = new Path(TString.resourcePath(tRCNode.eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(iResource, true);
        }
        path = tRCNode.getProcessProxies().toArray();
        int n2 = 0;
        while (n2 < ((Path)path).length) {
            tRCMonitor = (TRCProcessProxy)path[n2];
            if (!tRCMonitor.eIsProxy()) {
                DeleteUtil.removeDoc((TRCProcessProxy)tRCMonitor, bl);
            }
            ++n2;
        }
        tRCMonitor = tRCNode.getMonitor();
        if (tRCMonitor == null) {
            return;
        }
        tRCMonitor.getNodes().remove((Object)tRCNode);
        if (bl) {
            Path path2 = new Path(TString.resourcePath(tRCMonitor.eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path2);
            if (iResource != null) {
                try {
                    SaveUtil.saveResource(null, (Resource)tRCMonitor.eResource());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        DeleteUtil.unloadDoc((EObject)tRCNode);
    }

    public static void removeDoc(TRCProcessProxy tRCProcessProxy, boolean bl) {
        ArrayList arrayList;
        TRCNode tRCNode;
        Path path;
        if (tRCProcessProxy == null) {
            return;
        }
        if (bl) {
            path = new Path(TString.resourcePath(tRCProcessProxy.eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(iResource, true);
        }
        path = tRCProcessProxy.getAgentProxies().toArray();
        int n = 0;
        while (n < ((Path)path).length) {
            tRCNode = (TRCAgentProxy)path[n];
            if (!tRCNode.eIsProxy()) {
                DeleteUtil.removeDoc((TRCAgentProxy)tRCNode, bl);
            }
            ++n;
        }
        tRCNode = tRCProcessProxy.getNode();
        if (tRCNode != null) {
            tRCNode.getProcessProxies().remove((Object)tRCProcessProxy);
            if (bl) {
                arrayList = new Path(TString.resourcePath(tRCNode.eResource().getURI()));
                IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)arrayList);
                if (iResource != null) {
                    try {
                        SaveUtil.saveResource(null, (Resource)tRCNode.eResource());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        UIPlugin.getDefault().deregisterLaunchProcess(ProcessMap.get(tRCProcessProxy));
        arrayList = UIPlugin.getDefault().getDeleteListeners();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            ((IDeleteListener)arrayList.get(n2)).deregister(tRCProcessProxy);
            ++n2;
        }
        DeleteUtil.unloadDoc((EObject)tRCProcessProxy);
    }

    public static void unloadDoc(EObject eObject) {
        if (eObject == null || eObject.eResource() == null) {
            return;
        }
        UIPlugin.getDefault().removeSelectionModel(eObject);
        ((HierarchyXMIResourceImpl)eObject.eResource()).doShallowDelete();
    }

    public static void deleteCorrelationContainer(CorrelationContainerProxy correlationContainerProxy, boolean bl, boolean bl2) {
        Object object;
        Iterator iterator;
        Resource resource;
        if (correlationContainerProxy == null) {
            return;
        }
        CorrelationContainer correlationContainer = correlationContainerProxy.getCorrelationContainer();
        if (correlationContainer != null && !correlationContainer.eIsProxy()) {
            if (bl2) {
                resource = new Path(TString.resourcePath(correlationContainer.eResource().getURI()));
                iterator = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)resource);
                DeleteUtil.deleteResource((IResource)iterator, true);
            }
            ((HierarchyXMIResourceImpl)correlationContainer.eResource()).doShallowDelete();
            correlationContainer.setCorrelationContainerProxy(null);
        }
        resource = correlationContainerProxy.getMonitor().eResource();
        correlationContainerProxy.setMonitor(null);
        if (resource != null && bl2) {
            try {
                SaveUtil.saveResource(null, (Resource)resource);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        iterator = correlationContainerProxy.getCorrelatedAgents().iterator();
        while (iterator.hasNext()) {
            object = (TRCAgentProxy)iterator.next();
            if (!object.getInternalCorrelations().contains((Object)correlationContainerProxy)) continue;
            object.getInternalCorrelations().remove((Object)correlationContainerProxy);
        }
        correlationContainerProxy.getCorrelatedAgents().clear();
        if (bl) {
            object = UIPlugin.getDefault().getProfileEvent();
            ((ProfileEvent)object).setSource(null);
            ((ProfileEvent)object).setType(128);
            UIPlugin.getDefault().notifyProfileEventListener((ProfileEvent)object);
        }
    }
}

