/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;

public class ProfilingSetsManagerCopy
extends ProfilingSetsManager {
    public ProfilingSetsManagerCopy() {
        this.initialize();
        this.setDefaultSet(ProfilingSetsManager.instance.getDefaultSet());
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILINGSET, "");
            String string2 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILINGSETS, "");
            String string3 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILINGFILTERS, "");
            this.readSets(string2, string);
            this.readFilters(string3);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static ProfilingSetsManager instance() {
        return null;
    }

    public void applyChanges() {
        ProfilingSetsManager profilingSetsManager = ProfilingSetsManager.instance();
        profilingSetsManager.getProfilingSets().clear();
        profilingSetsManager.getProfilingSets().putAll(this.getProfilingSets());
        profilingSetsManager.getProfilingTypes().clear();
        profilingSetsManager.getProfilingTypes().putAll(this.getProfilingTypes());
        profilingSetsManager.getProfilingTypesGroups().clear();
        profilingSetsManager.getProfilingTypesGroups().putAll(this.getProfilingTypesGroups());
        profilingSetsManager.getFilterSets().clear();
        profilingSetsManager.getFilterSets().putAll(this.getFilterSets());
        profilingSetsManager.setDefaultSet(this.getDefaultSet());
        profilingSetsManager.setDefaultFilterSet(this.getDefaultFilterSet());
        this.writeSetsToPreferences();
    }

    protected void initializeProfilingTypesGroups() {
        this.profilingTypesGroups = new HashMap();
        Map map = ProfilingSetsManager.instance().getProfilingTypesGroups();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            IProfilingSetTypeGroup iProfilingSetTypeGroup = (IProfilingSetTypeGroup)map.get(string);
            this.profilingTypesGroups.put(string, new ProfilingSetTypeGroup(iProfilingSetTypeGroup.getId(), iProfilingSetTypeGroup.getName(), iProfilingSetTypeGroup.getIcon()));
        }
    }

    protected void initializeProfilingTypes() {
        this.profilingTypes = new HashMap();
        Map map = ProfilingSetsManager.instance().getProfilingTypes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            IProfilingSetType iProfilingSetType = (IProfilingSetType)map.get(string);
            this.profilingTypes.put(string, new ProfilingSetType(iProfilingSetType.getId(), iProfilingSetType.getName(), iProfilingSetType.getDescription(), iProfilingSetType.getImage(), iProfilingSetType.isUseFilters(), iProfilingSetType.getGroup(), iProfilingSetType.getProfilingType()));
        }
    }

    protected void initializeProfilingSets() {
        this.profilingSets = new HashMap();
        Map map = ProfilingSetsManager.instance().getProfilingSets();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            IProfilingSet iProfilingSet = (IProfilingSet)map.get(string);
            ProfilingSet profilingSet = new ProfilingSet(iProfilingSet.getId(), iProfilingSet.getName(), iProfilingSet.getDescription());
            profilingSet.getProfilingTypes().addAll(iProfilingSet.getProfilingTypes());
            profilingSet.getAttributes().putAll(iProfilingSet.getAttributes());
            this.profilingSets.put(string, profilingSet);
        }
    }

    protected void initializeFilterSets() {
        this.filterSets = new HashMap();
        Map map = ProfilingSetsManager.instance().getFilterSets();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            FilterSetElement filterSetElement = (FilterSetElement)map.get(string);
            FilterSetElement filterSetElement2 = new FilterSetElement(filterSetElement.getName(), filterSetElement.getEnabled());
            ArrayList arrayList = filterSetElement.getChildren();
            ArrayList<FilterTableElement> arrayList2 = new ArrayList<FilterTableElement>();
            int n = 0;
            while (n < arrayList.size()) {
                FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
                arrayList2.add(new FilterTableElement(filterTableElement.getText(), filterTableElement.getMethod(), filterTableElement.getVisibility()));
                ++n;
            }
            filterSetElement2.setChildren(arrayList2);
            this.filterSets.put(string, filterSetElement2);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        Object object;
        Object object2;
        try {
            object2 = iLaunchConfigurationWorkingCopy.getAttributes().keySet().iterator();
            while (object2.hasNext()) {
                object = object2.next().toString();
                if (!((String)object).startsWith("SETFILTER_") && !((String)object).startsWith("SETOPTION_")) continue;
                iLaunchConfigurationWorkingCopy.setAttribute((String)object, (String)null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = this.getDefaultSet();
        if (object2 == null) {
            return;
        }
        object = object2.getAttributes().values().iterator();
        while (object.hasNext()) {
            ProfilingAttribute profilingAttribute = (ProfilingAttribute)object.next();
            iLaunchConfigurationWorkingCopy.setAttribute(profilingAttribute.getName(), profilingAttribute.getValue());
        }
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILINGSET, object2.getId());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILINGSETS, this.getProfilingSetsString().toString());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILINGFILTERS, this.getProfilingFiltersString().toString());
    }
}

