/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.util.Vector;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DataPoolRowDialog
extends Dialog {
    private static final String TAG_EQUIVALENCE_CLASSES = "equivalenceClasses";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final String TAG_RECORD = "record";
    private static final int HEIGHT = 40;
    private static final int WIDTH = 380;
    private Shell shell = null;
    private IDatapool datapool = null;
    private String title = null;
    private boolean insertionMode = false;
    private Table table = null;
    private TableItem previousTableItem = null;
    private TableItem selectedTableItem = null;
    private Combo equivalenceClassCombo = null;
    private Combo recordIndexCombo = null;
    private int insertionEquivalenceClassIndex = -1;
    private int insertionRecordIndex = -1;
    private TableItem insertionTableItem = null;
    private SelectionListener equivalenceClassListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
            Combo combo = (Combo)selectionEvent.widget;
            DataPoolRowDialog.this.insertionEquivalenceClassIndex = combo.getSelectionIndex();
            IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray = (IDatapoolEquivalenceClass[])combo.getData(DataPoolRowDialog.TAG_EQUIVALENCE_CLASSES);
            iDatapoolEquivalenceClass = iDatapoolEquivalenceClassArray[DataPoolRowDialog.this.insertionEquivalenceClassIndex];
            String[] stringArray = DataPoolRowDialog.this.getRecordIndexLabels(iDatapoolEquivalenceClass);
            DataPoolRowDialog.this.recordIndexCombo.setItems(stringArray);
            DataPoolRowDialog.this.recordIndexCombo.select(0);
            if (iDatapoolEquivalenceClass != null) {
                String string = DataPoolRowDialog.this.recordIndexCombo.getText();
                Integer n = new Integer(string);
                DataPoolRowDialog.this.insertionRecordIndex = n;
            } else {
                DataPoolRowDialog.this.insertionRecordIndex = -1;
            }
            DataPoolRowDialog.this.recordIndexCombo.setData(DataPoolRowDialog.TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
            DataPoolRowDialog.this.enableOK();
        }
    };
    private SelectionListener recordIndexListener = new SelectionAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void widgetSelected(SelectionEvent selectionEvent) {
            Combo combo = (Combo)selectionEvent.widget;
            String string = combo.getText();
            try {
                try {
                    Integer n = new Integer(string);
                    DataPoolRowDialog.this.insertionRecordIndex = n;
                }
                catch (NumberFormatException numberFormatException) {
                    DataPoolRowDialog.this.insertionRecordIndex = -1;
                    Object var6_7 = null;
                    DataPoolRowDialog.this.enableOK();
                    return;
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                DataPoolRowDialog.this.enableOK();
                throw throwable;
            }
            DataPoolRowDialog.this.enableOK();
        }
    };

    public DataPoolRowDialog(Shell shell, IDatapool iDatapool, Table table, TableItem tableItem, TableItem tableItem2, String string) {
        super(shell);
        this.shell = shell;
        this.datapool = iDatapool;
        this.title = string;
        this.table = table;
        this.selectedTableItem = tableItem;
        this.previousTableItem = tableItem2;
        if (string.equals(DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_INS"))) {
            this.insertionMode = true;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 40;
        gridData.widthHint = 380;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        if (this.insertionMode) {
            label.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_INS"));
        } else {
            label.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_MOVE"));
        }
        this.equivalenceClassCombo = new Combo(composite2, 12);
        IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray = this.getEquivalenceClasses(null);
        String[] stringArray = this.getEquivalenceClassLabels(iDatapoolEquivalenceClassArray);
        this.equivalenceClassCombo.setItems(stringArray);
        this.equivalenceClassCombo.setData(TAG_EQUIVALENCE_CLASSES, (Object)iDatapoolEquivalenceClassArray);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 150;
        this.equivalenceClassCombo.setLayoutData((Object)gridData);
        this.equivalenceClassCombo.addSelectionListener(this.equivalenceClassListener);
        Label label2 = new Label(composite2, 0);
        label2.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_INDEX"));
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        IDatapoolRecord iDatapoolRecord = null;
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = null;
        IDatapoolRecord iDatapoolRecord2 = null;
        if (this.selectedTableItem != null) {
            iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.selectedTableItem.getData(TAG_EQUIVALENCE_CLASS);
            iDatapoolRecord = (IDatapoolRecord)this.selectedTableItem.getData(TAG_RECORD);
        }
        if (this.previousTableItem != null) {
            iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)this.previousTableItem.getData(TAG_EQUIVALENCE_CLASS);
            iDatapoolRecord2 = (IDatapoolRecord)this.previousTableItem.getData(TAG_RECORD);
        }
        String[] stringArray2 = null;
        stringArray2 = this.insertionMode ? this.getRecordIndexLabels(iDatapoolEquivalenceClass2) : this.getRecordIndexLabels(iDatapoolEquivalenceClass);
        this.recordIndexCombo = new Combo(composite2, 12);
        if (stringArray2 != null) {
            this.recordIndexCombo.setItems(stringArray2);
        }
        this.recordIndexCombo.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass2);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 55;
        this.recordIndexCombo.setLayoutData((Object)gridData);
        this.recordIndexCombo.addSelectionListener(this.recordIndexListener);
        if (!(this.insertionMode || iDatapoolEquivalenceClass2 != null && iDatapoolEquivalenceClass2.equals(iDatapoolEquivalenceClass))) {
            int n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
            if (n != -1) {
                this.equivalenceClassCombo.select(n);
                this.insertionEquivalenceClassIndex = n;
            }
            this.recordIndexCombo.select(this.recordIndexCombo.getItemCount() - 1);
            this.insertionRecordIndex = -1;
        } else {
            int n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass2.getId());
            int n2 = this.getRecordIndex(iDatapoolEquivalenceClass2, iDatapoolRecord2);
            if (n2 != -1) {
                this.recordIndexCombo.select(n2);
                this.insertionRecordIndex = n2;
            }
            if (n != -1) {
                this.equivalenceClassCombo.select(n);
                this.insertionEquivalenceClassIndex = n;
            }
        }
        return composite2;
    }

    private boolean enableOK() {
        this.getButton(0).setEnabled(true);
        return true;
    }

    private IDatapoolEquivalenceClass[] getEquivalenceClasses(String string) {
        Object object;
        int n = this.datapool.getEquivalenceClassCount();
        Vector<IDatapoolEquivalenceClass> vector = new Vector<IDatapoolEquivalenceClass>();
        int n2 = 0;
        while (n2 < n) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n2);
            object = iDatapoolEquivalenceClass.getId();
            if (!((String)object).equals(string)) {
                vector.add(iDatapoolEquivalenceClass);
            }
            ++n2;
        }
        int n3 = vector.size();
        object = new IDatapoolEquivalenceClass[n3];
        vector.toArray((T[])object);
        return object;
    }

    private String[] getEquivalenceClassLabels(IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray) {
        if (iDatapoolEquivalenceClassArray == null) {
            return null;
        }
        int n = iDatapoolEquivalenceClassArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = iDatapoolEquivalenceClassArray[n2];
            stringArray[n2] = iDatapoolEquivalenceClass.getName();
            ++n2;
        }
        return stringArray;
    }

    private String[] getRecordIndexLabels(IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        int n = 0;
        if (iDatapoolEquivalenceClass != null) {
            n = iDatapoolEquivalenceClass.getRecordCount();
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = String.valueOf(n2);
            ++n2;
        }
        stringArray[n] = DatapoolPlugin.getResourceString("DATA_ROW_DLG_HEAD_INDEX_VAR");
        return stringArray;
    }

    private int findEquivalenceClassIndexInCombo(IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray, IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        if (iDatapoolEquivalenceClassArray == null || iDatapoolEquivalenceClass == null) {
            return -1;
        }
        int n = 0;
        while (n < iDatapoolEquivalenceClassArray.length) {
            if (iDatapoolEquivalenceClassArray[n].equals(iDatapoolEquivalenceClass)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getInsertionEquivalenceClassIndex() {
        return this.insertionEquivalenceClassIndex;
    }

    public int getInsertionRecordIndex() {
        return this.insertionRecordIndex;
    }

    private int getRecordIndex(IDatapoolEquivalenceClass iDatapoolEquivalenceClass, IDatapoolRecord iDatapoolRecord) {
        int n = 0;
        while (n < iDatapoolEquivalenceClass.getRecordCount()) {
            org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord iDatapoolRecord2 = iDatapoolEquivalenceClass.getRecord(n);
            if (iDatapoolRecord2.equals(iDatapoolRecord)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

