/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.Enumeration;

public class TypeChecker {
    public static final String JAVA_TYPE_VOID = "void";
    public static final String JAVA_TYPE_BOOLEAN = "boolean";
    public static final String JAVA_TYPE_BYTE = "byte";
    public static final String JAVA_TYPE_SHORT = "short";
    public static final String JAVA_TYPE_INT = "int";
    public static final String JAVA_TYPE_LONG = "long";
    public static final String JAVA_TYPE_FLOAT = "float";
    public static final String JAVA_TYPE_DOUBLE = "double";
    public static final String JAVA_TYPE_CHAR = "char";
    public static final String JAVA_OBJ_TYPE_BOOLEAN = "java.lang.Boolean";
    public static final String JAVA_OBJ_TYPE_BYTE = "java.lang.Byte";
    public static final String JAVA_OBJ_TYPE_SHORT = "java.lang.Short";
    public static final String JAVA_OBJ_TYPE_INTEGER = "java.lang.Integer";
    public static final String JAVA_OBJ_TYPE_LONG = "java.lang.Long";
    public static final String JAVA_OBJ_TYPE_FLOAT = "java.lang.Float";
    public static final String JAVA_OBJ_TYPE_DOUBLE = "java.lang.Double";
    public static final String JAVA_OBJ_TYPE_CHAR = "java.lang.Character";
    public static final String JAVA_OBJ_TYPE_STRING = "java.lang.String";
    public static final String JAVA_OBJ_TYPE_BOOLEAN_SN = "Boolean";
    public static final String JAVA_OBJ_TYPE_BYTE_SN = "Byte";
    public static final String JAVA_OBJ_TYPE_SHORT_SN = "Short";
    public static final String JAVA_OBJ_TYPE_INTEGER_SN = "Integer";
    public static final String JAVA_OBJ_TYPE_LONG_SN = "Long";
    public static final String JAVA_OBJ_TYPE_FLOAT_SN = "Float";
    public static final String JAVA_OBJ_TYPE_DOUBLE_SN = "Double";
    public static final String JAVA_OBJ_TYPE_CHAR_SN = "Character";
    public static final String JAVA_OBJ_TYPE_STRING_SN = "String";
    public static final String CSHARP_TYPE_BOOL = "bool";
    public static final String CSHARP_TYPE_SBYTE = "sbyte";
    public static final String CSHARP_TYPE_BYTE = "byte";
    public static final String CSHARP_TYPE_USHORT = "ushort";
    public static final String CSHARP_TYPE_SHORT = "short";
    public static final String CSHARP_TYPE_UINT = "uint";
    public static final String CSHARP_TYPE_INT = "int";
    public static final String CSHARP_TYPE_ULONG = "ulong";
    public static final String CSHARP_TYPE_LONG = "long";
    public static final String CSHARP_TYPE_FLOAT = "float";
    public static final String CSHARP_TYPE_DOUBLE = "double";
    public static final String CSHARP_TYPE_DECIMAL = "decimal";
    public static final String CSHARP_TYPE_CHAR = "char";
    public static final String CSHARP_TYPE_STRING = "string";
    public static final String CSHARP_OBJ_TYPE_BOOL = "System.Boolean";
    public static final String CSHARP_OBJ_TYPE_SBYTE = "System.SByte";
    public static final String CSHARP_OBJ_TYPE_BYTE = "System.Byte";
    public static final String CSHARP_OBJ_TYPE_USHORT = "System.UInt16";
    public static final String CSHARP_OBJ_TYPE_SHORT = "System.Int16";
    public static final String CSHARP_OBJ_TYPE_UINT = "System.UInt32";
    public static final String CSHARP_OBJ_TYPE_INT = "System.Int32";
    public static final String CSHARP_OBJ_TYPE_ULONG = "System.UInt64";
    public static final String CSHARP_OBJ_TYPE_LONG = "System.Int64";
    public static final String CSHARP_OBJ_TYPE_FLOAT = "System.Single";
    public static final String CSHARP_OBJ_TYPE_DOUBLE = "System.Double";
    public static final String CSHARP_OBJ_TYPE_DECIMAL = "System.Decimal";
    public static final String CSHARP_OBJ_TYPE_CHAR = "System.Char";
    public static final String CSHARP_OBJ_TYPE_STRING = "System.String";
    public static final String CSHARP_OBJ_TYPE_BOOL_SN = "Boolean";
    public static final String CSHARP_OBJ_TYPE_SBYTE_SN = "SByte";
    public static final String CSHARP_OBJ_TYPE_BYTE_SN = "Byte";
    public static final String CSHARP_OBJ_TYPE_USHORT_SN = "UInt16";
    public static final String CSHARP_OBJ_TYPE_SHORT_SN = "Int16";
    public static final String CSHARP_OBJ_TYPE_UINT_SN = "UInt32";
    public static final String CSHARP_OBJ_TYPE_INT_SN = "Int32";
    public static final String CSHARP_OBJ_TYPE_ULONG_SN = "UInt64";
    public static final String CSHARP_OBJ_TYPE_LONG_SN = "Int64";
    public static final String CSHARP_OBJ_TYPE_FLOAT_SN = "Single";
    public static final String CSHARP_OBJ_TYPE_DOUBLE_SN = "Double";
    public static final String CSHARP_OBJ_TYPE_DECIMAL_SN = "Decimal";
    public static final String CSHARP_OBJ_TYPE_CHAR_SN = "Char";
    public static final String CSHARP_OBJ_TYPE_STRING_SN = "String";
    public static final String CPP_TYPE_VOID = "void";
    public static final String CPP_TYPE_CHAR = "char";
    public static final String CPP_TYPE_SINT = "short int";
    public static final String CPP_TYPE_INT = "int";
    public static final String CPP_TYPE_LINT = "long int";
    public static final String CPP_TYPE_FLOAT = "float";
    public static final String CPP_TYPE_DOUBLE = "double";
    public static final String CPP_TYPE_LDOUBLE = "long double";
    public static final String CPP_TYPE_S_CHAR = "signed char";
    public static final String CPP_TYPE_S_SINT = "signed short int";
    public static final String CPP_TYPE_S_INT = "signed int";
    public static final String CPP_TYPE_S_LINT = "signed long int";
    public static final String CPP_TYPE_U_CHAR = "unsigned char";
    public static final String CPP_TYPE_U_SINT = "unsigned short int";
    public static final String CPP_TYPE_U_INT = "unsigned int";
    public static final String CPP_TYPE_U_LINT = "unsigned long int";
    public static final int LANG_JAVA = 1;
    public static final int LANG_CSHARP = 2;
    public static final int LANG_CPP = 3;
    private int languageType = 0;
    private static final TypeChecker instance = new TypeChecker();

    public static TypeChecker getInstance() {
        return instance;
    }

    protected TypeChecker() {
    }

    public void setLanguageType(int n) {
        if (n < 1 || n > 3) {
            return;
        }
        this.languageType = n;
    }

    public boolean isNumber(String string) {
        if ((this.languageType == 0 || this.languageType == 1) && (string.equals("double") || string.equals("float") || string.equals("long") || string.equals("short") || string.equals(JAVA_OBJ_TYPE_DOUBLE) || string.equals("Double") || string.equals(JAVA_OBJ_TYPE_FLOAT) || string.equals(JAVA_OBJ_TYPE_FLOAT_SN) || string.equals(JAVA_OBJ_TYPE_INTEGER) || string.equals(JAVA_OBJ_TYPE_INTEGER_SN) || string.equals(JAVA_OBJ_TYPE_LONG) || string.equals(JAVA_OBJ_TYPE_LONG_SN) || string.equals(JAVA_OBJ_TYPE_SHORT) || string.equals(JAVA_OBJ_TYPE_SHORT_SN))) {
            return true;
        }
        if ((this.languageType == 0 || this.languageType == 2) && (string.equals(CSHARP_OBJ_TYPE_DECIMAL) || string.equals(CSHARP_OBJ_TYPE_DECIMAL_SN) || string.equals(CSHARP_OBJ_TYPE_DOUBLE) || string.equals("Double") || string.equals(CSHARP_OBJ_TYPE_FLOAT) || string.equals(CSHARP_OBJ_TYPE_FLOAT_SN) || string.equals(CSHARP_OBJ_TYPE_INT) || string.equals(CSHARP_OBJ_TYPE_INT_SN) || string.equals(CSHARP_OBJ_TYPE_LONG) || string.equals(CSHARP_OBJ_TYPE_LONG_SN) || string.equals(CSHARP_OBJ_TYPE_SHORT) || string.equals(CSHARP_OBJ_TYPE_SHORT_SN) || string.equals(CSHARP_OBJ_TYPE_UINT) || string.equals(CSHARP_OBJ_TYPE_UINT_SN) || string.equals(CSHARP_OBJ_TYPE_ULONG) || string.equals(CSHARP_OBJ_TYPE_ULONG_SN) || string.equals(CSHARP_OBJ_TYPE_USHORT) || string.equals(CSHARP_OBJ_TYPE_USHORT_SN) || string.equals(CSHARP_TYPE_DECIMAL) || string.equals("float") || string.equals("int") || string.equals("long") || string.equals("short") || string.equals(CSHARP_TYPE_UINT) || string.equals(CSHARP_TYPE_ULONG) || string.equals(CSHARP_TYPE_USHORT))) {
            return true;
        }
        return !(this.languageType != 0 && this.languageType != 3 || !string.equals("double") && !string.equals("float") && !string.equals(CPP_TYPE_SINT) && !string.equals("int") && !string.equals(CPP_TYPE_LINT) && !string.equals(CPP_TYPE_LDOUBLE) && !string.equals(CPP_TYPE_S_INT) && !string.equals(CPP_TYPE_S_LINT) && !string.equals(CPP_TYPE_S_SINT) && !string.equals(CPP_TYPE_U_INT) && !string.equals(CPP_TYPE_U_LINT) && !string.equals(CPP_TYPE_U_SINT));
    }

    public boolean isBoolean(String string) {
        if ((this.languageType == 0 || this.languageType == 1) && (string.equals(JAVA_TYPE_BOOLEAN) || string.equals(JAVA_OBJ_TYPE_BOOLEAN) || string.equals("Boolean"))) {
            return true;
        }
        if ((this.languageType == 0 || this.languageType == 2) && (string.equals(CSHARP_TYPE_BOOL) || string.equals(CSHARP_OBJ_TYPE_BOOL) || string.equals("Boolean"))) {
            return true;
        }
        if (this.languageType == 0 || this.languageType == 3) {
            // empty if block
        }
        return false;
    }

    public boolean isString(String string) {
        if ((this.languageType == 0 || this.languageType == 1) && (string.equals(JAVA_OBJ_TYPE_STRING) || string.equals("String"))) {
            return true;
        }
        if ((this.languageType == 0 || this.languageType == 2) && (string.equals(CSHARP_OBJ_TYPE_STRING) || string.equals("String") || string.equals(CSHARP_TYPE_STRING))) {
            return true;
        }
        if (this.languageType == 0 || this.languageType == 3) {
            // empty if block
        }
        return false;
    }

    public boolean isEnumeration(String string) {
        block3: {
            if (this.languageType != 0 && this.languageType != 1) break block3;
            try {
                Class<?> clazz = Class.forName(string);
                if (clazz instanceof Enumeration) {
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean isPrimitive(String string, boolean bl) {
        if (this.languageType == 0 || this.languageType == 1) {
            if (string.equals(JAVA_TYPE_BOOLEAN) || string.equals("byte") || string.equals("char") || string.equals("double") || string.equals("float") || string.equals("int") || string.equals("long") || string.equals("short")) {
                return true;
            }
            if (bl && string.equals("void")) {
                return true;
            }
        }
        if (this.languageType == 0 || this.languageType == 2) {
            return false;
        }
        if (this.languageType == 0 || this.languageType == 3) {
            if (string.equals("double") || string.equals("float") || string.equals(CPP_TYPE_SINT) || string.equals("int") || string.equals(CPP_TYPE_LINT) || string.equals(CPP_TYPE_LDOUBLE) || string.equals("char") || string.equals(CPP_TYPE_U_CHAR) || string.equals(CPP_TYPE_S_CHAR) || string.equals(CPP_TYPE_S_INT) || string.equals(CPP_TYPE_S_LINT) || string.equals(CPP_TYPE_S_SINT) || string.equals(CPP_TYPE_U_INT) || string.equals(CPP_TYPE_U_LINT) || string.equals(CPP_TYPE_U_SINT)) {
                return true;
            }
            if (bl && string.equals("void")) {
                return true;
            }
        }
        return false;
    }
}

