/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.extension;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.IWriteAccessChangeListener;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter;
import org.eclipse.hyades.ui.editor.EditorExtension;
import org.eclipse.hyades.ui.editor.IHyadesEditorExtension;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class BaseEditorExtension
extends EditorExtension
implements ISynchronizedEditorAdapter,
IHyadesEditorExtension {
    private ListenerList writeAccessChangeListeners = new ListenerList();
    private boolean dirty = false;
    private Clipboard clipboard;
    static /* synthetic */ Class class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter;

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.writeAccessChangeListeners.clear();
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if ((class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter == null ? (class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter = BaseEditorExtension.class$("org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter")) : class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter) == clazz) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    protected ResourceSet getResourceSet() {
        return ((EObject)this.getHyadesEditorPart().getEditorObject()).eResource().getResourceSet();
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.getHyadesEditorPart().getEditorPart().getEditorSite().getShell().getDisplay());
        }
        return this.clipboard;
    }

    public void addListener(IWriteAccessChangeListener iWriteAccessChangeListener) {
        this.writeAccessChangeListeners.add((Object)iWriteAccessChangeListener);
    }

    public void removeListener(IWriteAccessChangeListener iWriteAccessChangeListener) {
        this.writeAccessChangeListeners.remove((Object)iWriteAccessChangeListener);
    }

    protected void notifyWriteAccessChangeListeners(IFile iFile, boolean bl) {
        if (iFile == null) {
            return;
        }
        Object[] objectArray = this.writeAccessChangeListeners.getListeners();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            ((IWriteAccessChangeListener)objectArray[n]).writeAccessChanged(iFile, bl);
            ++n;
        }
    }

    public synchronized void markDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.getHyadesEditorPart().firePropertyChange(257);
        }
    }

    protected void clearDirty() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public final void doSave(IProgressMonitor iProgressMonitor) {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    BaseEditorExtension.this.save(iProgressMonitor);
                    BaseEditorExtension.this.clearDirty();
                }
                catch (Exception exception) {
                    BaseEditorExtension.this.handleException(exception);
                }
            }
        };
        IActionBars iActionBars = this.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        if (iActionBars != null && iActionBars.getStatusLineManager() != null) {
            iActionBars.getStatusLineManager().setErrorMessage(null);
            iActionBars.getStatusLineManager().setMessage(null);
            iProgressMonitor = iActionBars.getStatusLineManager().getProgressMonitor();
            iActionBars.getStatusLineManager().setCancelEnabled(false);
        } else if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            ModalContext.run((IRunnableWithProgress)workspaceModifyOperation, (boolean)false, (IProgressMonitor)iProgressMonitor, (Display)Display.getCurrent());
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void save(IProgressMonitor iProgressMonitor) throws Exception {
        Resource[] resourceArray = (Resource[])this.getResourceSet().getResources().toArray((Object[])new Resource[this.getResourceSet().getResources().size()]);
        int n = resourceArray.length;
        int n2 = 0;
        iProgressMonitor.beginTask("", n);
        int n3 = 0;
        int n4 = resourceArray.length;
        while (n3 < n4) {
            if (resourceArray[n3].isModified()) {
                this.logSaveMessage(iProgressMonitor, resourceArray[n3], n, n2++);
                EMFUtil.save(resourceArray[n3]);
            }
            iProgressMonitor.worked(1);
            ++n3;
        }
        iProgressMonitor.done();
    }

    protected void logSaveMessage(IProgressMonitor iProgressMonitor, Resource resource, int n, int n2) {
        String string = "";
        IFile iFile = EMFUtil.getWorkspaceFile(resource);
        if (iFile != null) {
            string = iFile.getFullPath().toString();
        }
        iProgressMonitor.subTask(TestUIPlugin.getString("PRG_SAVE_RSRS", new String[]{Integer.toString(n2), Integer.toString(n), string}));
    }

    protected void handleException(Exception exception) {
        TestUIPlugin.logError(exception);
        String string = "";
        IFile iFile = EMFUtil.getWorkspaceFile((EObject)this.getHyadesEditorPart().getEditorObject());
        if (iFile != null) {
            string = iFile.getFullPath().toString();
        }
        UIUtil.openSaveFileErrorDialog((Shell)this.getHyadesEditorPart().getEditorPart().getSite().getShell(), (String)string, (Throwable)exception);
    }

    protected boolean reloadEditorObject() {
        Resource resource = ((EObject)this.getHyadesEditorPart().getEditorObject()).eResource();
        resource.unload();
        try {
            resource.load(EMFUtil.RESOURCE_OPTIONS);
        }
        catch (Exception exception) {
            TestUIPlugin.logError(exception);
        }
        if (!resource.getContents().isEmpty()) {
            this.getHyadesEditorPart().setEditorObject(resource.getContents().get(0));
        } else {
            this.getHyadesEditorPart().setEditorObject(null);
        }
        return false;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof TestNavigator) {
            if (!(iSelection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            if (iStructuredSelection.size() != 1) {
                return;
            }
            URI uRI = this.getObjectURI(iStructuredSelection.getFirstElement());
            if (uRI == null) {
                return;
            }
            EObject eObject = this.getResourceSet().getEObject(uRI, false);
            if (eObject == null) {
                return;
            }
            this.setSelection((IStructuredSelection)new StructuredSelection((Object)eObject));
        }
    }

    protected URI getObjectURI(Object object) {
        EObject eObject;
        if (object != null && object instanceof EObject && (eObject = (EObject)object).eResource() != null) {
            return eObject.eResource().getURI().appendFragment(eObject.eResource().getURIFragment(eObject));
        }
        return null;
    }

    public boolean editorFileChanged() {
        return false;
    }

    public boolean editorFileDeleted() {
        return false;
    }

    public boolean editorFileWriteAccessChanged(boolean bl) {
        this.notifyWriteAccessChangeListeners(EMFUtil.getWorkspaceFile((EObject)this.getHyadesEditorPart().getEditorObject()), bl);
        return false;
    }

    public void handle(List list, List list2) {
    }

    public boolean reload() {
        Object object;
        String string = null;
        IStructuredSelection iStructuredSelection = this.getSelection();
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof EObject) {
            string = ((EObject)object).eResource().getURIFragment((EObject)object);
        }
        if (!this.reloadEditorObject()) {
            object = this.getHyadesEditorPart().getEditorObject();
            this.refreshContent(object);
            if (object instanceof EObject && string != null) {
                EObject eObject = ((EObject)object).eResource().getEObject(string);
                iStructuredSelection = eObject != null ? new StructuredSelection((Object)eObject) : StructuredSelection.EMPTY;
                this.setSelection(iStructuredSelection);
            }
            this.dirty = false;
            this.getHyadesEditorPart().firePropertyChange(257);
        }
        return true;
    }

    public boolean doSaveEditorFile(boolean bl) {
        this.getHyadesEditorPart().getEditorPart().doSave((IProgressMonitor)new NullProgressMonitor());
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

