/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormLabel;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class SelectableFormLabel
extends FormLabel {
    protected boolean hasFocus;

    public boolean getSelection() {
        return this.hasFocus;
    }

    public SelectableFormLabel(Composite composite, int n) {
        super(composite, n);
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\r') {
                    SelectableFormLabel.this.notifyListeners(14);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        event.doit = false;
                        return;
                    }
                }
                event.doit = true;
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (!SelectableFormLabel.this.hasFocus) {
                    SelectableFormLabel.this.hasFocus = true;
                    SelectableFormLabel.this.notifyListeners(13);
                    SelectableFormLabel.this.redraw();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (SelectableFormLabel.this.hasFocus) {
                    SelectableFormLabel.this.hasFocus = false;
                    SelectableFormLabel.this.notifyListeners(13);
                    SelectableFormLabel.this.redraw();
                }
            }
        });
        this.textMarginWidth = 1;
        this.textMarginHeight = 1;
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = SelectableFormLabel.this.getText();
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = SelectableFormLabel.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = SelectableFormLabel.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                accessibleControlEvent.childID = SelectableFormLabel.this.getBounds().contains(point) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = SelectableFormLabel.this.getBounds();
                Point point = SelectableFormLabel.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 43;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = SelectableFormLabel.this.getSelection() ? 2 : 0;
            }
        });
    }

    protected void notifyListeners(int n) {
        Event event = new Event();
        event.type = n;
        event.widget = this;
        this.notifyListeners(n, event);
    }

    protected void paint(PaintEvent paintEvent) {
        super.paint(paintEvent);
        if (this.hasFocus) {
            GC gC = paintEvent.gc;
            Point point = this.getSize();
            gC.setForeground(this.getForeground());
            gC.drawFocus(0, 0, point.x, point.y);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)selectionListener);
        this.removeListener(14, (SWTEventListener)selectionListener);
    }
}

