/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class EObjectContainerContentProvider
extends AdapterImpl
implements ITreeContentProvider {
    private EStructuralFeature eStructuralFeature;
    private EObject container;
    private Viewer viewer;
    private EditorForm editorForm;
    private Map eStructuralFeatureByClass;

    public EObjectContainerContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
        this.eStructuralFeature = eStructuralFeature;
        this.editorForm = editorForm;
    }

    public void dispose() {
        if (this.container != null) {
            this.container.eAdapters().remove((Object)this);
            Object object = this.container.eGet(this.eStructuralFeature);
            if (object instanceof Collection) {
                EMFUtil.removeAdapter(((Collection)object).iterator(), (Adapter)this);
            } else if (object != null) {
                ((Notifier)object).eAdapters().remove((Object)this);
            }
            this.container = null;
        }
        this.viewer = null;
        this.eStructuralFeature = null;
        this.editorForm = null;
        if (this.eStructuralFeatureByClass != null) {
            this.eStructuralFeatureByClass.clear();
        }
    }

    protected EObject getContainer() {
        return this.container;
    }

    public void registerParent(Class clazz, EStructuralFeature eStructuralFeature) {
        if (this.eStructuralFeatureByClass == null) {
            this.eStructuralFeatureByClass = new HashMap();
        }
        this.eStructuralFeatureByClass.put(clazz, eStructuralFeature);
    }

    public void deregisterParent(Class clazz) {
        if (this.eStructuralFeatureByClass != null) {
            this.eStructuralFeatureByClass.remove(clazz);
        }
    }

    protected Object getRegisteredParentChild(Object object) {
        if (this.eStructuralFeatureByClass != null) {
            Iterator iterator = this.eStructuralFeatureByClass.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((Class)entry.getKey()).isInstance(object)) continue;
                if (object instanceof EObject) {
                    return ((EObject)object).eGet((EStructuralFeature)entry.getValue());
                }
                return null;
            }
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        Object object3;
        this.viewer = viewer;
        if (this.container != null) {
            this.container.eAdapters().remove((Object)this);
            object3 = this.container.eGet(this.eStructuralFeature);
            this.deregisterInputAdapters(this.container, object3);
            this.container = null;
        }
        if (object2 instanceof EObject) {
            object3 = (EObject)object2;
            if (this.eStructuralFeature.eContainer() == object3.eClass()) {
                this.container = object3;
                this.container.eAdapters().add((Object)this);
                this.registerInputAdapters((EObject)object3, this.container.eGet(this.eStructuralFeature));
            }
        }
    }

    protected Viewer getViewer() {
        return this.viewer;
    }

    protected void deregisterInputAdapters(EObject eObject, Object object) {
        if (object instanceof Collection) {
            EMFUtil.removeAdapter(((Collection)object).iterator(), (Adapter)this);
        } else if (object != null) {
            ((Notifier)object).eAdapters().remove((Object)this);
        }
    }

    protected void registerInputAdapters(EObject eObject, Object object) {
        if (object instanceof List) {
            EMFUtil.addAdapter(((List)object).iterator(), (Adapter)this);
        } else if (object != null) {
            ((Notifier)object).eAdapters().add((Object)this);
        }
    }

    public Object getParent(Object object) {
        if (this.container == object) {
            return null;
        }
        if (object instanceof EObject) {
            return ((EObject)object).eContainer();
        }
        return null;
    }

    public Object[] getElements(Object object) {
        if (this.container == null) {
            return new Object[0];
        }
        if (this.eStructuralFeature.isMany()) {
            return ((List)this.container.eGet(this.eStructuralFeature)).toArray();
        }
        return new Object[]{this.container.eGet(this.eStructuralFeature)};
    }

    public boolean hasChildren(Object object) {
        if (this.container == null) {
            return false;
        }
        if (!this.eStructuralFeature.isMany()) {
            return false;
        }
        if (this.container == object) {
            List list = (List)this.container.eGet(this.eStructuralFeature);
            return !list.isEmpty();
        }
        Object object2 = this.getRegisteredParentChild(object);
        return object2 != null;
    }

    public Object[] getChildren(Object object) {
        Object object2 = this.getRegisteredParentChild(object);
        if (object2 != null) {
            if (object2 instanceof Collection) {
                return ((Collection)object2).toArray();
            }
            return new Object[]{object2};
        }
        return new Object[0];
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                return;
            }
        }
        this.editorForm.getBaseEditorExtension().markDirty();
        this.adjustModel(notification);
        this.adjustAdapter(notification);
        this.updateViewer(notification);
    }

    protected void adjustModel(Notification notification) {
    }

    protected boolean shouldAdjustAdapter(Notification notification) {
        return notification.getNotifier() == this.container && notification.getFeature() == this.eStructuralFeature;
    }

    protected void adjustAdapter(Notification notification) {
        if (this.shouldAdjustAdapter(notification)) {
            switch (notification.getEventType()) {
                case 3: {
                    ((Notifier)notification.getNewValue()).eAdapters().add((Object)this);
                    break;
                }
                case 5: {
                    EMFUtil.addAdapter(((Collection)notification.getNewValue()).iterator(), (Adapter)this);
                    break;
                }
                case 4: {
                    ((Notifier)notification.getOldValue()).eAdapters().remove((Object)this);
                    break;
                }
                case 6: {
                    EMFUtil.removeAdapter(((Collection)notification.getOldValue()).iterator(), (Adapter)this);
                }
            }
        }
    }

    protected boolean shouldUpdateViewer(Notification notification) {
        return notification.getFeature() == this.eStructuralFeature;
    }

    protected void updateViewer(Notification notification) {
        if (this.getViewer() == null) {
            return;
        }
        if (!(this.getViewer() instanceof StructuredViewer)) {
            this.getViewer().refresh();
            return;
        }
        if (notification.getNotifier() != this.container) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: {
                    this.attributeChanged(notification);
                    return;
                }
            }
        }
        if (!(this.getViewer() instanceof TreeViewer)) {
            this.getViewer().refresh();
            return;
        }
        if (this.shouldUpdateViewer(notification)) {
            Object object = null;
            switch (notification.getEventType()) {
                case 3: {
                    object = this.getParent(notification.getNewValue());
                    if (object == null) {
                        object = this.getViewer().getInput();
                    }
                    ((TreeViewer)this.getViewer()).add(object, notification.getNewValue());
                    this.getViewer().setSelection((ISelection)new StructuredSelection(notification.getNewValue()), true);
                    break;
                }
                case 5: {
                    Object[] objectArray = ((Collection)notification.getNewValue()).toArray();
                    object = this.getParent(objectArray[0]);
                    if (object == null) {
                        object = this.getViewer().getInput();
                    }
                    ((TreeViewer)this.getViewer()).add(object, objectArray);
                    this.getViewer().setSelection((ISelection)new StructuredSelection(objectArray), true);
                    break;
                }
                case 4: {
                    ((TreeViewer)this.getViewer()).remove(notification.getOldValue());
                    Object object2 = ((EObject)notification.getNotifier()).eGet((EStructuralFeature)notification.getFeature());
                    if (object2 instanceof List) {
                        List list = (List)object2;
                        if (list.isEmpty()) {
                            this.getViewer().getControl().setFocus();
                            break;
                        }
                        int n = notification.getPosition();
                        n = n < list.size() ? n : list.size() - 1;
                        this.getViewer().setSelection((ISelection)new StructuredSelection(list.get(n)), true);
                        break;
                    }
                    this.getViewer().getControl().setFocus();
                    break;
                }
                case 6: {
                    ((TreeViewer)this.getViewer()).remove(((Collection)notification.getOldValue()).toArray());
                    this.getViewer().getControl().setFocus();
                    break;
                }
                case 7: {
                    this.getViewer().refresh();
                }
            }
        }
    }

    protected void attributeChanged(Notification notification) {
        ((StructuredViewer)this.getViewer()).update(notification.getNotifier(), null);
    }
}

