/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.EventForm;
import org.eclipse.hyades.test.ui.internal.editor.form.ExecutionForm;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ExecutionEditorExtension
extends BaseEditorExtension {
    private static final int PAGE_OVERVIEW = 0;
    private static final int PAGE_EVENTS = 1;
    public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Execution";
    private ExecutionForm executionForm;
    private EventForm eventsForm;

    public void dispose() {
        this.executionForm.getWidgetFactory().dispose();
        this.executionForm.dispose();
        this.eventsForm.dispose();
        super.dispose();
    }

    public TPFExecutionResult getExecution() {
        return (TPFExecutionResult)this.getHyadesEditorPart().getEditorObject();
    }

    public void createPages() {
        IHyadesEditorPart iHyadesEditorPart = this.getHyadesEditorPart();
        WidgetFactory widgetFactory = new WidgetFactory();
        this.executionForm = new ExecutionForm(this, widgetFactory);
        iHyadesEditorPart.addPage(this.executionForm.createControl());
        iHyadesEditorPart.setPageText(0, TestUIPlugin.getString("W_OVERVIEW"));
        this.eventsForm = new EventForm(this, widgetFactory);
        iHyadesEditorPart.addPage(this.eventsForm.createControl());
        iHyadesEditorPart.setPageText(1, TestUIPlugin.getString("W_EVENTS"));
        this.executionForm.updateTitle();
    }

    public boolean editorFileChanged() {
        block2: {
            this.reload();
            if (this.getHyadesEditorPart().getActivePage() != 1 || !this.getSelection().isEmpty()) break block2;
            try {
                this.setSelection((IStructuredSelection)new StructuredSelection(this.getExecution().getExecutionHistory().getExecutionEvents().get(0)));
            }
            catch (RuntimeException runtimeException) {}
        }
        return true;
    }

    public void refreshContent(Object object) {
        this.executionForm.load();
        this.executionForm.updateTitle();
        this.eventsForm.load();
    }

    public IStructuredSelection getSelection() {
        switch (this.getHyadesEditorPart().getActivePage()) {
            case 0: {
                return new StructuredSelection((Object)this.getExecution());
            }
            case 1: {
                return (IStructuredSelection)this.eventsForm.getSelection();
            }
        }
        return StructuredSelection.EMPTY;
    }

    public boolean pageActivated(int n) {
        switch (n) {
            case 0: {
                return this.executionForm.activated();
            }
            case 1: {
                return this.eventsForm.activated();
            }
        }
        return false;
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        Object object;
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) != this.getExecution() && object instanceof TPFExecutionEvent) {
            this.getHyadesEditorPart().setActivePage(1);
            this.eventsForm.selectReveal((ISelection)iStructuredSelection);
        }
    }
}

