/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.test.ui.internal.editor.form.base.AbstractForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class AbstractSectionForm
extends AbstractForm {
    public static final int H_SCROLL_INCREMENT = 5;
    public static final int V_SCROLL_INCREMENT = 64;
    protected Vector sections = null;

    public void registerSection(FormSection formSection) {
        if (this.sections == null) {
            this.sections = new Vector();
        }
        if (!this.sections.contains(formSection)) {
            this.sections.add(formSection);
        }
    }

    public void unregisterSection(FormSection formSection) {
        if (this.sections != null && this.sections.contains(formSection)) {
            this.sections.remove(formSection);
        }
    }

    public void initialize(Object object) {
        if (this.sections != null) {
            Iterator iterator = this.sections.iterator();
            while (iterator.hasNext()) {
                FormSection formSection = (FormSection)iterator.next();
                formSection.initialize(object);
            }
        }
    }

    public void setFocus() {
        if (this.sections != null && this.sections.size() > 0) {
            FormSection formSection = (FormSection)this.sections.firstElement();
            formSection.setFocus();
        }
    }

    public void update() {
        if (this.sections != null) {
            Iterator iterator = this.sections.iterator();
            while (iterator.hasNext()) {
                FormSection formSection = (FormSection)iterator.next();
                formSection.update();
            }
        }
    }

    public void commitChanges(boolean bl) {
        if (this.sections != null) {
            Iterator iterator = this.sections.iterator();
            while (iterator.hasNext()) {
                FormSection formSection = (FormSection)iterator.next();
                if (!formSection.isDirty()) continue;
                formSection.commitChanges(bl);
            }
        }
    }

    public boolean doGlobalAction(String string) {
        Control control = this.getFocusControl();
        if (control == null) {
            return false;
        }
        if (this.canPerformDirectly(string, control)) {
            return true;
        }
        Composite composite = control.getParent();
        FormSection formSection = null;
        while (composite != null) {
            Object object = composite.getData();
            if (object != null && object instanceof FormSection) {
                formSection = (FormSection)object;
                break;
            }
            composite = composite.getParent();
        }
        if (formSection != null) {
            return formSection.doGlobalAction(string);
        }
        return false;
    }

    protected Control getFocusControl() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control control2 = display.getFocusControl();
        if (control2 == null || control2.isDisposed()) {
            return null;
        }
        return control2;
    }

    public boolean canPaste(Clipboard clipboard) {
        Control control = this.getFocusControl();
        if (control == null) {
            return false;
        }
        Composite composite = control.getParent();
        FormSection formSection = null;
        while (composite != null) {
            Object object = composite.getData();
            if (object != null && object instanceof FormSection) {
                formSection = (FormSection)object;
                break;
            }
            composite = composite.getParent();
        }
        if (formSection != null) {
            return formSection.canPaste(clipboard);
        }
        return false;
    }

    public void dispose() {
        if (this.sections != null) {
            Iterator iterator = this.sections.iterator();
            while (iterator.hasNext()) {
                FormSection formSection = (FormSection)iterator.next();
                formSection.dispose();
            }
        }
        super.dispose();
    }

    public static void ensureVisible(ScrolledComposite scrolledComposite, Control control) {
        Point point = control.getSize();
        Point point2 = AbstractSectionForm.getControlLocation(scrolledComposite, control);
        AbstractSectionForm.ensureVisible(scrolledComposite, point2, point);
    }

    public static void ensureVisible(ScrolledComposite scrolledComposite, Point point, Point point2) {
        Rectangle rectangle = scrolledComposite.getClientArea();
        Point point3 = scrolledComposite.getOrigin();
        int n = point3.x;
        int n2 = point3.y;
        if (point.x < point3.x) {
            n = point.x;
        } else if (point.x + point2.x > point3.x + rectangle.width) {
            n = point.x + point2.x - rectangle.width;
        }
        if (point.y < point3.y) {
            n2 = point.y;
        } else if (point.y + point2.y > point3.y + rectangle.height) {
            n2 = point.y + point2.y - rectangle.height;
        }
        scrolledComposite.setOrigin(n, n2);
    }

    public static Point getControlLocation(ScrolledComposite scrolledComposite, Control control) {
        int n = 0;
        int n2 = 0;
        for (Control control2 = control; control2 != scrolledComposite; control2 = control2.getParent()) {
            if (control2.getLocation().x > 0) {
                n += control2.getLocation().x;
            }
            if (control2.getLocation().y <= 0) continue;
            n2 += control2.getLocation().y;
        }
        return new Point(n, n2);
    }

    public static void scrollVertical(ScrolledComposite scrolledComposite, boolean bl) {
        AbstractSectionForm.scroll(scrolledComposite, 0, bl ? -64 : 64);
    }

    public static void scrollHorizontal(ScrolledComposite scrolledComposite, boolean bl) {
        AbstractSectionForm.scroll(scrolledComposite, bl ? -5 : 5, 0);
    }

    public static void scrollPage(ScrolledComposite scrolledComposite, boolean bl) {
        Rectangle rectangle = scrolledComposite.getClientArea();
        int n = bl ? -rectangle.height : rectangle.height;
        AbstractSectionForm.scroll(scrolledComposite, 0, n);
    }

    private static void scroll(ScrolledComposite scrolledComposite, int n, int n2) {
        Point point = scrolledComposite.getOrigin();
        Point point2 = scrolledComposite.getContent().getSize();
        int n3 = point.x + n;
        int n4 = point.y + n2;
        n3 = Math.max(n3, 0);
        n3 = Math.min(n3, point2.x - 1);
        n4 = Math.max(n4, 0);
        n4 = Math.min(n4, point2.y - 1);
        scrolledComposite.setOrigin(n3, n4);
    }

    public static void updatePageIncrement(ScrolledComposite scrolledComposite) {
        ScrollBar scrollBar = scrolledComposite.getVerticalBar();
        if (scrollBar != null) {
            Rectangle rectangle = scrolledComposite.getClientArea();
            int n = rectangle.height - 5;
            scrollBar.setPageIncrement(n);
        }
    }
}

