/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.text.BreakIterator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class FormLabel
extends Canvas {
    private String text = "";
    private boolean underlined;
    protected int textMarginWidth = 5;
    protected int textMarginHeight = 5;

    public FormLabel(Composite composite, int n) {
        super(composite, n);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FormLabel.this.paint(paintEvent);
            }
        });
        this.initAccessible();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (string != null) {
            this.text = string;
        } else {
            string = "";
        }
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = FormLabel.this.getText();
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = FormLabel.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = FormLabel.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                accessibleControlEvent.childID = FormLabel.this.getBounds().contains(point) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = FormLabel.this.getBounds();
                Point point = FormLabel.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 41;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 64;
            }
        });
    }

    public void setUnderlined(boolean bl) {
        this.underlined = bl;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = n;
        if (n3 != -1) {
            n3 -= this.textMarginWidth * 2;
        }
        Point point = this.computeTextSize(n3, n2);
        int n4 = point.x + 2 * this.textMarginWidth;
        int n5 = point.y + 2 * this.textMarginHeight;
        return new Point(n4, n5);
    }

    public static int computeWrapHeight(GC gC, String string, int n) {
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = n2;
        int n6 = breakIterator.first();
        while (n6 != -1) {
            String string2 = string.substring(n3, n6);
            Point point = gC.textExtent(string2);
            if (point.x > n) {
                n3 = n4;
                n5 += point.y;
            }
            n4 = n6;
            n6 = breakIterator.next();
        }
        return n5;
    }

    private Point computeTextSize(int n, int n2) {
        Point point;
        GC gC = new GC((Drawable)this);
        gC.setFont(this.getFont());
        if ((this.getStyle() & 0x40) != 0 && n != -1) {
            int n3 = FormLabel.computeWrapHeight(gC, this.text, n);
            point = new Point(n, n3);
        } else {
            point = gC.textExtent(this.getText());
        }
        gC.dispose();
        return point;
    }

    public static void paintWrapText(GC gC, Point point, String string, int n, int n2) {
        FormLabel.paintWrapText(gC, point, string, n, n2, false);
    }

    public static void paintWrapText(GC gC, Point point, String string, int n, int n2, boolean bl) {
        String string2;
        String string3;
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.getDescent();
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        int n8 = point.x - n * 2;
        int n9 = breakIterator.first();
        while (n9 != -1) {
            string3 = string.substring(n5, n9);
            Point point2 = gC.textExtent(string3);
            if (point2.x > n8) {
                string2 = string.substring(n5, n6);
                gC.drawString(string2, n, n7, true);
                if (bl) {
                    Point point3 = gC.textExtent(string2);
                    int n10 = n7 + n3 - n4 + 1;
                    gC.drawLine(n, n10, point3.x, n10);
                }
                n5 = n6;
                n7 += n3;
            }
            n6 = n9;
            n9 = breakIterator.next();
        }
        string3 = string.substring(n5, n6);
        gC.drawString(string3, n, n7, true);
        if (bl) {
            int n11 = n7 + n3 - n4 + 1;
            string2 = gC.textExtent(string3);
            gC.drawLine(n, n11, n + ((Point)string2).x, n11);
        }
    }

    protected void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Point point = this.getSize();
        gC.setFont(this.getFont());
        gC.setForeground(this.getForeground());
        if ((this.getStyle() & 0x40) != 0) {
            FormLabel.paintWrapText(gC, point, this.text, this.textMarginWidth, this.textMarginHeight, this.underlined);
        } else {
            gC.drawText(this.getText(), this.textMarginWidth, this.textMarginHeight, true);
            if (this.underlined) {
                FontMetrics fontMetrics = gC.getFontMetrics();
                int n = fontMetrics.getDescent();
                int n2 = point.y - this.textMarginHeight - n + 1;
                gC.drawLine(this.textMarginWidth, n2, point.x - this.textMarginWidth, n2);
            }
        }
    }
}

