/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ILayoutExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SectionChangeManager;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ToggleControl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class FormSection
implements IPropertyChangeListener {
    public static final int SELECTION = 1;
    private String headerColorKey = "__default__header__";
    private String headerText;
    protected Control client;
    protected Label header;
    protected Control separator;
    private SectionChangeManager sectionManager;
    private String description;
    private boolean dirty;
    protected Label descriptionLabel;
    protected ToggleControl toggle;
    private boolean readOnly;
    protected boolean addSeparator = true;
    protected boolean descriptionPainted = true;
    protected boolean headerPainted = true;
    protected boolean collapsable = false;
    private boolean collapsed = false;
    private int widthHint = -1;
    private int heightHint = -1;
    private Composite control;

    public FormSection() {
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    public void commitChanges(boolean bl) {
    }

    public abstract Composite createClient(Composite var1, FormWidgetFactory var2);

    public final Control createControl(Composite composite, final FormWidgetFactory formWidgetFactory) {
        Composite composite2 = formWidgetFactory.createComposite(composite);
        SectionLayout sectionLayout = new SectionLayout();
        composite2.setLayout((Layout)sectionLayout);
        composite2.setData((Object)this);
        if (this.headerPainted) {
            Color color = formWidgetFactory.getColor(this.getHeaderColorKey());
            this.header = formWidgetFactory.createHeadingLabel(composite2, this.getHeaderText(), color, 64);
            if (this.collapsable) {
                this.toggle = new ToggleControl(composite2, 0);
                this.toggle.setSelection(this.collapsed);
                this.toggle.setBackground(formWidgetFactory.getBackgroundColor());
                this.toggle.setActiveDecorationColor(formWidgetFactory.getHyperlinkColor());
                this.toggle.setDecorationColor(formWidgetFactory.getColor("__compSep"));
                this.toggle.setActiveCursor(formWidgetFactory.getHyperlinkCursor());
                this.toggle.addFocusListener((FocusListener)formWidgetFactory.visibilityHandler);
                this.toggle.addKeyListener((KeyListener)formWidgetFactory.keyboardHandler);
                this.toggle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        FormSection.this.doToggle();
                    }
                });
                this.header.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        FormSection.this.toggle.setSelection(!FormSection.this.toggle.getSelection());
                        FormSection.this.toggle.redraw();
                        FormSection.this.doToggle();
                    }
                });
                this.header.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent mouseEvent) {
                        FormSection.this.header.setCursor(formWidgetFactory.getHyperlinkCursor());
                    }

                    public void mouseExit(MouseEvent mouseEvent) {
                        FormSection.this.header.setCursor(null);
                    }
                });
            }
        }
        if (this.addSeparator) {
            this.separator = formWidgetFactory.createCompositeSeparator(composite2);
        }
        if (this.descriptionPainted && this.description != null) {
            this.descriptionLabel = formWidgetFactory.createLabel(composite2, this.description, 64);
        }
        this.client = this.createClient(composite2, formWidgetFactory);
        composite2.setData((Object)this);
        this.control = composite2;
        return composite2;
    }

    protected void doToggle() {
        boolean bl = this.toggle.getSelection();
        this.reflow();
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setVisible(!bl);
        }
        if (this.client != null) {
            this.client.setVisible(!bl);
        }
    }

    protected void reflow() {
        this.control.setRedraw(false);
        this.control.getParent().setRedraw(false);
        this.control.layout(true);
        this.control.getParent().layout(true);
        this.control.setRedraw(true);
        this.control.getParent().setRedraw(true);
    }

    protected Text createText(Composite composite, String string, FormWidgetFactory formWidgetFactory) {
        return this.createText(composite, string, formWidgetFactory, 1);
    }

    protected Text createText(Composite composite, String string, FormWidgetFactory formWidgetFactory, int n) {
        formWidgetFactory.createLabel(composite, string);
        Text text = formWidgetFactory.createText(composite, "");
        int n2 = n == 1 ? 768 : 256;
        GridData gridData = new GridData(n2 | 4);
        gridData.horizontalSpan = n;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected Text createText(Composite composite, String string, FormWidgetFactory formWidgetFactory, int n, int n2) {
        GridData gridData;
        Label label = formWidgetFactory.createLabel(composite, string);
        if ((n2 & 2) != 0) {
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
        }
        gridData = formWidgetFactory.createText(composite, "", n2);
        int n3 = n == 1 ? 768 : 256;
        GridData gridData2 = new GridData(n3 | 4);
        gridData2.horizontalSpan = n;
        gridData.setLayoutData((Object)gridData2);
        return gridData;
    }

    protected Text createText(Composite composite, FormWidgetFactory formWidgetFactory, int n) {
        Text text = formWidgetFactory.createText(composite, "");
        int n2 = n == 1 ? 768 : 256;
        GridData gridData = new GridData(n2 | 4);
        gridData.horizontalSpan = n;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    public boolean doGlobalAction(String string) {
        return false;
    }

    public void expandTo(Object object) {
    }

    public final void fireChangeNotification(int n, Object object) {
        if (this.sectionManager == null) {
            return;
        }
        this.sectionManager.dispatchNotification(this, n, object);
    }

    public final void fireSelectionNotification(Object object) {
        this.fireChangeNotification(1, object);
    }

    public String getDescription() {
        return this.description;
    }

    public String getHeaderColorKey() {
        return this.headerColorKey;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public int getHeightHint() {
        return this.heightHint;
    }

    public int getWidthHint() {
        return this.widthHint;
    }

    public void initialize(Object object) {
    }

    public boolean isAddSeparator() {
        return this.addSeparator;
    }

    public boolean isDescriptionPainted() {
        return this.descriptionPainted;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isHeaderPainted() {
        return this.headerPainted;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void sectionChanged(FormSection formSection, int n, Object object) {
    }

    public void setAddSeparator(boolean bl) {
        this.addSeparator = bl;
    }

    private String trimNewLines(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\n') {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setDescription(String string) {
        this.description = this.trimNewLines(string);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(string);
        }
    }

    public void setDescriptionPainted(boolean bl) {
        this.descriptionPainted = bl;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void setFocus() {
        if (this.toggle != null) {
            this.toggle.setFocus();
        }
    }

    public void setHeaderColorKey(String string) {
        this.headerColorKey = string;
    }

    public void setHeaderPainted(boolean bl) {
        this.headerPainted = bl;
    }

    public void setHeaderText(String string) {
        this.headerText = string;
        if (this.header != null) {
            this.header.setText(this.headerText);
        }
    }

    public void setHeightHint(int n) {
        this.heightHint = n;
    }

    void setManager(SectionChangeManager sectionChangeManager) {
        this.sectionManager = sectionChangeManager;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setWidthHint(int n) {
        this.widthHint = n;
    }

    public void update() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.control != null && this.header != null) {
            this.header.setFont(JFaceResources.getBannerFont());
            this.control.layout(true);
        }
    }

    public boolean getCollapsable() {
        return this.collapsable;
    }

    public void setCollapsable(boolean bl) {
        this.collapsable = bl;
    }

    public void setCollapsed(boolean bl) {
        this.collapsed = bl;
    }

    public boolean canPaste(Clipboard clipboard) {
        return false;
    }

    class SectionLayout
    extends Layout
    implements ILayoutExtension {
        int vspacing = 3;
        int sepHeight = 2;

        SectionLayout() {
        }

        public int getMinimumWidth(Composite composite, boolean bl) {
            return 30;
        }

        public int getMaximumWidth(Composite composite, boolean bl) {
            Point point;
            int n = 0;
            if (FormSection.this.client != null) {
                point = FormSection.this.client.computeSize(-1, -1, bl);
                n = point.x;
            }
            if (FormSection.this.headerPainted && FormSection.this.header != null) {
                point = FormSection.this.header.computeSize(-1, -1, bl);
                n = Math.max(n, point.x);
            }
            if (FormSection.this.descriptionPainted && FormSection.this.descriptionLabel != null) {
                point = FormSection.this.descriptionLabel.computeSize(-1, -1, bl);
                n = Math.max(n, point.x);
            }
            return n;
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Point point;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            n5 = n3;
            if (FormSection.this.client != null) {
                point = FormSection.this.client.computeSize(n, -1);
                if (n3 == 0) {
                    n5 = n3 = point.x;
                }
                if (n4 == 0) {
                    n4 = point.y;
                }
            }
            point = null;
            if (FormSection.this.collapsable && FormSection.this.toggle != null) {
                point = FormSection.this.toggle.computeSize(-1, -1, bl);
            }
            if (n2 == -1 && FormSection.this.headerPainted && FormSection.this.header != null) {
                int n7 = n5;
                if (point != null) {
                    n7 = n5 - point.x - 5;
                }
                Point point2 = FormSection.this.header.computeSize(n7, -1, bl);
                n4 += point2.y;
                n6 = point2.y;
                n4 += this.vspacing;
            }
            if (n2 == -1 && FormSection.this.addSeparator) {
                n4 += this.sepHeight;
                n4 += this.vspacing;
                n6 += this.vspacing + this.sepHeight;
            }
            if (n2 == -1 && FormSection.this.descriptionPainted && FormSection.this.descriptionLabel != null) {
                Point point3 = FormSection.this.descriptionLabel.computeSize(n5, -1, bl);
                n4 += point3.y;
                n4 += this.vspacing;
            }
            if (FormSection.this.toggle != null && FormSection.this.toggle.getSelection()) {
                n4 = n6;
            }
            return new Point(n3, n4);
        }

        protected void layout(Composite composite, boolean bl) {
            Point point;
            int n = composite.getClientArea().width;
            int n2 = composite.getClientArea().height;
            int n3 = 0;
            Point point2 = null;
            if (FormSection.this.collapsable) {
                point2 = FormSection.this.toggle.computeSize(-1, -1, bl);
            }
            if (FormSection.this.headerPainted && FormSection.this.header != null) {
                int n4 = n;
                if (point2 != null) {
                    n4 = n - point2.x - 5;
                }
                point = FormSection.this.header.computeSize(n4, -1, bl);
                int n5 = 0;
                if (FormSection.this.toggle != null) {
                    int n6 = n3 + point.y - point2.y;
                    FormSection.this.toggle.setBounds(0, n6, point2.x, point2.y);
                    n5 = point2.x;
                }
                FormSection.this.header.setBounds(n5, n3, n4, point.y);
                n3 += point.y + this.vspacing;
            }
            if (FormSection.this.addSeparator && FormSection.this.separator != null) {
                FormSection.this.separator.setBounds(0, n3, n, 2);
                n3 += this.sepHeight + this.vspacing;
            }
            if (FormSection.this.toggle != null && FormSection.this.toggle.getSelection()) {
                return;
            }
            if (FormSection.this.descriptionPainted && FormSection.this.descriptionLabel != null) {
                point = FormSection.this.descriptionLabel.computeSize(n, -1, bl);
                FormSection.this.descriptionLabel.setBounds(0, n3, n, point.y);
                n3 += point.y + this.vspacing;
            }
            if (FormSection.this.client != null) {
                FormSection.this.client.setBounds(0, n3, n, n2 - n3);
            }
        }
    }
}

