/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;

public class EMFUtil {
    public static final Map RESOURCE_OPTIONS = new HashMap();
    private static ResourceSet resourceSet = new ResourceSetImpl();

    public EMFUtil() {
        RESOURCE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        RESOURCE_OPTIONS.put("SKIP_ESCAPE", Boolean.FALSE);
    }

    public static void save(Resource resource) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException(TestUIPlugin.getString("_ERROR_ARG_NULL", "resource"));
        }
        boolean bl = resource.isModified();
        try {
            resource.save(RESOURCE_OPTIONS);
        }
        catch (Exception exception) {
            resource.setModified(bl);
            throw exception;
        }
    }

    public static EObject getEObject(ResourceSet resourceSet, EObject eObject, boolean bl) {
        ResourceSet resourceSet2 = resourceSet;
        if (resourceSet2 == null) {
            resourceSet2 = EMFUtil.resourceSet;
        }
        if (eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        if (resourceSet2.equals(resource.getResourceSet())) {
            return eObject;
        }
        String string = resource.getURIFragment(eObject);
        if ((resource = resourceSet2.getResource(resource.getURI(), bl)) == null) {
            return null;
        }
        eObject = resource.getEObject(string);
        if (eObject == null) {
            return null;
        }
        return eObject;
    }

    public static EObject[] getEObjects(ResourceSet resourceSet, IFile iFile) {
        if (iFile == null) {
            return new EObject[0];
        }
        return EMFUtil.getEObjects(resourceSet, iFile.getFullPath().toString());
    }

    public static EObject[] getEObjects(ResourceSet resourceSet, String string) {
        Resource resource;
        if (string == null) {
            return new EObject[0];
        }
        ResourceSet resourceSet2 = resourceSet;
        if (resourceSet2 == null) {
            resourceSet2 = EMFUtil.resourceSet;
        }
        if ((resource = resourceSet2.getResource(URI.createPlatformResourceURI((String)string), false)) == null) {
            return new EObject[0];
        }
        return (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
    }

    public static EObject[] getEObjects(URI uRI, boolean bl) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.getResource(uRI, bl);
        EList eList = resource.getContents();
        EObject[] eObjectArray = new EObject[eList.size()];
        int n = 0;
        while (n < eList.size()) {
            eObjectArray[n] = (EObject)eList.get(n);
            ++n;
        }
        return eObjectArray;
    }

    public static EObject[] load(ResourceSet resourceSet, IFile iFile) {
        if (iFile == null) {
            return new EObject[0];
        }
        return EMFUtil.load(resourceSet, iFile.getFullPath().toString());
    }

    public static EObject[] load(ResourceSet resourceSet, String string) {
        if (string == null) {
            return new EObject[0];
        }
        URI uRI = URI.createPlatformResourceURI((String)string);
        Resource resource = null;
        try {
            resource = resourceSet != null ? resourceSet.getResource(uRI, true) : EMFUtil.resourceSet.getResource(uRI, true);
        }
        catch (Exception exception) {
            TestUIPlugin.logError(exception);
        }
        if (resource == null) {
            return new EObject[0];
        }
        return (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
    }

    public static Resource.Factory getResourceFactory(String string) {
        Resource.Factory factory;
        if (string != null && (factory = (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(string)) != null) {
            return factory;
        }
        return (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get("*");
    }

    public static IFile getWorkspaceFile(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return EMFUtil.getWorkspaceFile(eObject.eResource());
    }

    public static IFile getWorkspaceFile(Resource resource) {
        String string = EMFUtil.getWorkspaceFilePath(resource);
        if (string == null) {
            return null;
        }
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        if (iResource == null || iResource.getType() != 1) {
            return null;
        }
        return (IFile)iResource;
    }

    public static String getWorkspaceFilePath(Resource resource) {
        if (resource == null) {
            return null;
        }
        String string = resource.getURI().toString();
        if (!string.startsWith("platform:/resource")) {
            return null;
        }
        return string.substring("platform:/resource".length());
    }

    public static Resource getResource(ResourceSet resourceSet, IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        return EMFUtil.getResource(resourceSet, uRI, false);
    }

    public static Resource getResource(ResourceSet resourceSet, URI uRI, boolean bl) {
        ResourceSet resourceSet2 = resourceSet;
        if (resourceSet2 == null) {
            resourceSet2 = EMFUtil.resourceSet;
        }
        return resourceSet2.getResource(uRI, bl);
    }

    public static EObject reload(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return eObject;
        }
        String string = resource.getURIFragment(eObject);
        if (resource.isLoaded()) {
            resource.unload();
        }
        try {
            resource.load(RESOURCE_OPTIONS);
        }
        catch (IOException iOException) {
            TestUIPlugin.logError(iOException);
            return null;
        }
        return resource.getEObject(string);
    }

    public static Resource[] remove(EObject eObject) {
        if (eObject == null) {
            return new Resource[0];
        }
        if (eObject.eResource() == null) {
            EcoreUtil.remove((EObject)eObject);
            return new Resource[0];
        }
        Resource resource = eObject.eResource();
        Set set = org.eclipse.hyades.models.hierarchy.util.EMFUtil.delete((EObject)eObject, (ResourceSet)resource.getResourceSet());
        set.add(resource);
        if (eObject.eContainer() != null) {
            EcoreUtil.remove((EObject)eObject);
        }
        return set.toArray(new Resource[set.size()]);
    }

    public static Resource[] remove(Resource resource) {
        if (resource == null) {
            return new Resource[0];
        }
        Set set = org.eclipse.hyades.models.hierarchy.util.EMFUtil.delete((Resource)resource);
        return set.toArray(new Resource[set.size()]);
    }

    public static void addAdapter(Iterator iterator, Adapter adapter) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Notifier)) continue;
            ((Notifier)e).eAdapters().add((Object)adapter);
        }
    }

    public static void removeAdapter(Iterator iterator, Adapter adapter) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Notifier)) continue;
            ((Notifier)e).eAdapters().remove((Object)adapter);
        }
    }

    public static void removeAdapters(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Notifier)) continue;
            ((Notifier)e).eAdapters().clear();
        }
    }

    public static ResourceSet getResourceSet() {
        return resourceSet;
    }

    public static Resource getResource(ResourceSet resourceSet, EObject eObject) {
        ResourceSet resourceSet2 = resourceSet;
        if (resourceSet2 == null) {
            resourceSet2 = EMFUtil.resourceSet;
        }
        EList eList = resourceSet2.getResources();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            EList eList2 = resource.getContents();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                if (!eObject.equals(iterator2.next())) continue;
                return resource;
            }
        }
        return null;
    }
}

