/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorFilter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ResourceUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.TestNavigatorProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorFrameSource;
import org.eclipse.hyades.test.ui.internal.navigator.TestResourceChangeUpdater;
import org.eclipse.hyades.test.ui.internal.navigator.action.TestNavigatorActionGroup;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigatorFrameSource;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TestNavigator
extends TreeNavigator {
    public static final String ID = "org.eclipse.hyades.test.ui.TestNavigator";
    private static Map testNavigatorByWorkbenchWindow;
    protected static final String SET_SHOW_FOLDERS = "SHOW_FOLDERS";
    protected static final String SET_SHOW_EOBJECT_CHILDREN = "SHOW_EOBJECT_CHILDREN";
    protected static final String SET_SORTER_CRITERIA = "SORTER_CRITERIA";
    protected static final int CP_FOLDER = 0;
    protected static final int CP_LOGICAL = 1;
    private List rootLogicalFolders;
    private boolean showingFolders = true;
    private boolean showingEObjectChildren = true;
    private ResourceChangeUpdaterProvider resourceChangeUpdaterProvider;
    private TestNavigatorProvider provider;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;

    private static void addTestNavigator(TestNavigator testNavigator) {
        if (testNavigatorByWorkbenchWindow == null) {
            testNavigatorByWorkbenchWindow = new HashMap();
        }
        testNavigatorByWorkbenchWindow.put(testNavigator.getSite().getWorkbenchWindow(), testNavigator);
    }

    private static void removeTestNavigator(TestNavigator testNavigator) {
        if (testNavigatorByWorkbenchWindow != null) {
            testNavigatorByWorkbenchWindow.remove(testNavigator.getSite().getWorkbenchWindow());
            if (testNavigatorByWorkbenchWindow.isEmpty()) {
                testNavigatorByWorkbenchWindow = null;
            }
        }
    }

    public static TestNavigator getTestNavigator(IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow != null && testNavigatorByWorkbenchWindow != null) {
            return (TestNavigator)((Object)testNavigatorByWorkbenchWindow.get(iWorkbenchWindow));
        }
        return null;
    }

    public TestNavigator() {
        super(ID);
        this.initExtension();
    }

    private void initExtension() {
        Object object;
        int n;
        IConfigurationElement[] iConfigurationElementArray;
        this.provider = new TestNavigatorProvider();
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorFile");
        if (iExtensionPoint != null) {
            iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            n = 0;
            while (n < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n].getName() != null) {
                    String string = iConfigurationElementArray[n].getAttribute("targetExtension");
                    try {
                        IConfigurationElement[] iConfigurationElementArray2;
                        IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = null;
                        object = null;
                        IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElementArray[n].getChildren("provider");
                        if (iConfigurationElementArray3.length != 0) {
                            iHyadesTestNavigatorProvider = (IHyadesTestNavigatorProvider)iConfigurationElementArray3[0].createExecutableExtension("class");
                        }
                        if ((iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren("converter")).length != 0) {
                            object = (IHyadesTestNavigatorConverter)iConfigurationElementArray2[0].createExecutableExtension("class");
                        }
                        this.provider.addVisibleFile(string, iHyadesTestNavigatorProvider, (IHyadesTestNavigatorConverter)object);
                    }
                    catch (CoreException coreException) {
                        TestUIPlugin.logError(coreException);
                    }
                }
                ++n;
            }
        }
        if ((iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorObject")) != null) {
            iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName() != null) {
                    String string = iConfigurationElementArray[n2].getAttribute("targetObject");
                    try {
                        object = (IHyadesTestNavigatorProvider)iConfigurationElementArray[n2].createExecutableExtension("provider");
                        this.provider.addVisibleObject(string, (IHyadesTestNavigatorProvider)object);
                    }
                    catch (CoreException coreException) {
                        TestUIPlugin.logError(coreException);
                    }
                }
                ++n2;
            }
        }
        if ((iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorFilter")) != null) {
            iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            n = 0;
            while (n < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n].getName() != null) {
                    try {
                        IHyadesTestNavigatorFilter iHyadesTestNavigatorFilter = (IHyadesTestNavigatorFilter)iConfigurationElementArray[n].createExecutableExtension("class");
                        this.provider.addFilter(iHyadesTestNavigatorFilter);
                    }
                    catch (CoreException coreException) {
                        TestUIPlugin.logError(coreException);
                    }
                }
                ++n;
            }
        }
    }

    public void dispose() {
        if (this.rootLogicalFolders != null) {
            this.rootLogicalFolders.clear();
        }
        TestNavigator.removeTestNavigator(this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider);
        this.resourceChangeUpdaterProvider.getResourceChangeUpdater().dispose();
        this.resourceChangeUpdaterProvider.dispose();
        this.resourceChangeUpdaterProvider = null;
        this.provider.dispose();
        this.provider = null;
        super.dispose();
    }

    public String getStoreSection() {
        return "TestNavigator";
    }

    protected void initSettings() {
        this.setShowingFolders(true);
        this.setShowingEObjectChildren(false);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        TestNavigator.addTestNavigator(this);
    }

    public IFile getFile(Object object) {
        IFile iFile;
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof Resource) {
            return EMFUtil.getWorkspaceFile((Resource)object);
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eContainer() != null) {
                return null;
            }
            Resource resource = eObject.eResource();
            if (resource == null) {
                return null;
            }
            return EMFUtil.getWorkspaceFile(resource);
        }
        if (object instanceof IAdaptable && (iFile = (IFile)((IAdaptable)object).getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = TestNavigator.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile)) != null) {
            return iFile;
        }
        return null;
    }

    public void setMonitoringResourceChange(boolean bl) {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().setActive(bl);
        }
    }

    public boolean isMonitoringResourceChange() {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().isActive();
        }
        return false;
    }

    protected void loadSettings() {
        super.loadSettings();
        this.setShowingEObjectChildren(this.getSettings().getBoolean(SET_SHOW_EOBJECT_CHILDREN));
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
        int n = 1;
        try {
            n = this.getSettings().getInt(SET_SORTER_CRITERIA);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        NavigatorViewerSorter navigatorViewerSorter = new NavigatorViewerSorter((INavigator)this, n){

            protected String getValue(Viewer viewer, Object object) {
                String string = super.getValue(viewer, object);
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    if (eObject.eContainer() != null) {
                        return "";
                    }
                    if (this.getCriteria() == 2) {
                        if (eObject instanceof TPFTest) {
                            String string2 = ((TPFTest)eObject).getType();
                            string = string2 != null ? string2 + string : "zZz" + string2;
                        }
                        string = eObject.eClass().getName() + string;
                    }
                }
                return string;
            }
        };
        treeViewer.setSorter((ViewerSorter)navigatorViewerSorter);
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (!TestNavigator.this.isShowingEObjectChildren()) {
                    return !(object instanceof EObject);
                }
                return true;
            }
        };
        treeViewer.addFilter(viewerFilter);
        this.resourceChangeUpdaterProvider = new ResourceChangeUpdaterProvider.UIUpdaterProvider();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider, 1);
        TestResourceChangeUpdater testResourceChangeUpdater = new TestResourceChangeUpdater(this);
        this.resourceChangeUpdaterProvider.setResourceChangeUpdater((IResourceChangeUpdater)testResourceChangeUpdater);
        treeViewer.setContentProvider((IContentProvider)this.provider);
        ILabelDecorator iLabelDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.provider, iLabelDecorator));
    }

    protected boolean editorActivated(IEditorPart iEditorPart) {
        IFileEditorInput iFileEditorInput;
        IFile iFile;
        Resource resource;
        if (this.getViewer() == null) {
            return false;
        }
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput && (resource = EMFUtil.getResource(null, iFile = (iFileEditorInput = (IFileEditorInput)iEditorInput).getFile())) != null && !resource.getContents().isEmpty()) {
            Object object;
            IStructuredSelection iStructuredSelection = this.getStructuredSelection();
            if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof EObject && ((EObject)object).eResource() == resource) {
                return true;
            }
            this.selectReveal((ISelection)new StructuredSelection(resource.getContents().get(0)));
            return true;
        }
        return false;
    }

    protected void linkToEditor(IStructuredSelection iStructuredSelection) {
        IWorkbenchPage iWorkbenchPage;
        IEditorPart iEditorPart;
        IFile iFile = this.getFile(iStructuredSelection.getFirstElement());
        if (iFile != null && (iEditorPart = (iWorkbenchPage = this.getSite().getPage()).findEditor((IEditorInput)new FileEditorInput(iFile))) != null) {
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            return;
        }
    }

    public AbstractUIPlugin getPlugin() {
        return TestUIPlugin.getInstance();
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void createActions() {
        this.setActionGroup(new TestNavigatorActionGroup(this));
    }

    public boolean isShowingFolders() {
        return this.showingFolders;
    }

    public void setShowingFolders(boolean bl) {
        this.showingFolders = bl;
        this.getSettings().put(SET_SHOW_FOLDERS, this.showingFolders);
        if (this.getViewer() == null) {
            return;
        }
        this.getViewer().refresh();
    }

    public boolean isShowingEObjectChildren() {
        return this.showingEObjectChildren;
    }

    public void setShowingEObjectChildren(boolean bl) {
    }

    protected String getStatusLineMessage(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IResource) {
                return ((IResource)object).getFullPath().toString();
            }
            if (object instanceof LogicalFolder) {
                LogicalFolder logicalFolder = (LogicalFolder)object;
                if (logicalFolder.getChildren().size() == 0) {
                    return logicalFolder.getName();
                }
                return TestUIPlugin.getString("STS_LNE_LOG_FLD", new String[]{logicalFolder.getName(), Integer.toString(logicalFolder.getChildren().size())});
            }
            if (object instanceof CMNNamedElement) {
                CMNNamedElement cMNNamedElement = (CMNNamedElement)object;
                String string = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)cMNNamedElement);
                IFile iFile = EMFUtil.getWorkspaceFile((EObject)cMNNamedElement);
                String string2 = "";
                if (iFile != null) {
                    string2 = iFile.getFullPath().toString();
                }
                return TestUIPlugin.getString("STS_LNE_FILE_ELEM", new String[]{string, string2});
            }
            if (object instanceof Resource) {
                Resource resource = (Resource)object;
                String string = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)resource);
                IFile iFile = EMFUtil.getWorkspaceFile(resource);
                String string3 = "";
                if (iFile != null) {
                    string3 = iFile.getFullPath().toString();
                }
                return TestUIPlugin.getString("STS_LNE_FILE_ELEM", new String[]{string, string3});
            }
        }
        return super.getStatusLineMessage(iStructuredSelection);
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        if (doubleClickEvent.getViewer() == this.getTreeViewer()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof EObject || object instanceof Resource) {
                return;
            }
            TreeViewer treeViewer = this.getTreeViewer();
            if (treeViewer.isExpandable(object)) {
                treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
            }
        }
    }

    protected IStructuredSelection convertToViewer(ISelection iSelection) {
        IStructuredSelection iStructuredSelection = super.convertToViewer(iSelection);
        if (iStructuredSelection.isEmpty()) {
            return iStructuredSelection;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            EObject eObject;
            Object e = iterator.next();
            if (e instanceof IFile) {
                eObject = EMFUtil.getEObjects(null, (IFile)e);
                int n = 0;
                int n2 = ((EObject[])eObject).length;
                while (n < n2) {
                    if (eObject[n] instanceof CMNNamedElement) {
                        arrayList.add(eObject[n]);
                    }
                    ++n;
                }
                continue;
            }
            if (e instanceof EObject) {
                eObject = EMFUtil.getEObject(null, (EObject)e, false);
                if (eObject == null) continue;
                if (eObject.eContainer() == null) {
                    arrayList.add(eObject);
                    continue;
                }
                if (this.isShowingEObjectChildren()) {
                    arrayList.add(eObject);
                    continue;
                }
                arrayList.add(EcoreUtil.getRootContainer((EObject)eObject));
                continue;
            }
            arrayList.add(e);
        }
        return new StructuredSelection(arrayList);
    }

    public void handleChange(int n) {
        if (NavigatorViewerSorter.SORTER_TYPE == n) {
            this.getSettings().put(SET_SORTER_CRITERIA, ((NavigatorViewerSorter)this.getViewer().getSorter()).getCriteria());
            NavigatorActionGroup navigatorActionGroup = this.getActionGroup();
            if (navigatorActionGroup != null) {
                navigatorActionGroup.updateActionBars();
            }
        }
        super.handleChange(n);
    }

    public Object getInitialViewerInput() {
        return super.getInitialViewerInput();
    }

    protected TreeNavigatorFrameSource createFrameSource() {
        return new TestNavigatorFrameSource(this);
    }

    public void registerRootLogcalFolder(LogicalFolder logicalFolder) {
        if (logicalFolder != null && logicalFolder.getParent() == null) {
            if (this.rootLogicalFolders == null) {
                this.rootLogicalFolders = new ArrayList();
            }
            this.rootLogicalFolders.add(logicalFolder);
        }
    }

    public LogicalFolder getRootLogicalFolder(String string) {
        if (this.rootLogicalFolders != null && string != null) {
            Iterator iterator = this.rootLogicalFolders.iterator();
            while (iterator.hasNext()) {
                LogicalFolder logicalFolder = (LogicalFolder)iterator.next();
                if (!string.equals(logicalFolder.getName())) continue;
                return logicalFolder;
            }
        }
        return null;
    }

    protected List loadElements(IMemento iMemento) {
        Object[] objectArray = super.loadElements(iMemento).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            LogicalFolder logicalFolder;
            if (objectArray[n] instanceof LogicalFolder) {
                logicalFolder = (LogicalFolder)objectArray[n];
                Object object = logicalFolder.getParent();
                if (object == null) {
                    if ((logicalFolder = this.getRootLogicalFolder(logicalFolder.getName())) != null) {
                        arrayList.add(logicalFolder);
                    }
                } else if (object instanceof EObject) {
                    EObject eObject = EMFUtil.getEObject(null, (EObject)object, true);
                    if (eObject != null) {
                        LogicalFolder logicalFolder2 = new LogicalFolder((Object)eObject, logicalFolder.getName());
                        logicalFolder2.setData(logicalFolder.getData());
                        logicalFolder2.setDescription(logicalFolder.getDescription());
                        arrayList.add(logicalFolder2);
                    }
                } else {
                    arrayList.add(logicalFolder);
                }
            } else if (objectArray[n] instanceof EObject) {
                logicalFolder = EMFUtil.getEObject(null, (EObject)objectArray[n], true);
                if (logicalFolder != null) {
                    arrayList.add(logicalFolder);
                }
            } else if (objectArray[n] instanceof ResourceUtil.ResourceAdaptable) {
                logicalFolder = ((ResourceUtil.ResourceAdaptable)objectArray[n]).getResource();
                if (logicalFolder != null && (logicalFolder = EMFUtil.getResource(null, logicalFolder.getURI(), true)) != null) {
                    arrayList.add(logicalFolder);
                }
            } else {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    protected String getHelpContextId() {
        return TestUIPlugin.getID() + ".tnav0001";
    }

    public String[] getVisibleFiles() {
        return this.provider.getVisibleFiles();
    }

    public String getID() {
        return ID;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

