/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.preference;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ReportGeneratorPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private ReportManager reportManager;
    private TableViewer tableViewer;
    private ArrayList tableElements = new ArrayList();
    private Button btnAdd;
    private Button btnRemove;
    private Button btnRename;
    private Button btnTest;

    public ReportGeneratorPage() {
        this.setPreferenceStore(TestUIPlugin.getInstance().getPreferenceStore());
        this.reportManager = TestUI.getReportManager();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        composite2.setLayout((Layout)new GridLayout());
        this.createTable(composite2);
        WorkbenchHelp.setHelp((Control)composite, (String)(TestUIPlugin.getID() + ".rgpp0001"));
        return composite2;
    }

    private Control createTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.verticalSpacing = 10;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.createTableViewer(composite2);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData(1040);
        gridData.widthHint = 90;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.createButtons(composite3);
        this.initializeValues();
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnTest.addSelectionListener((SelectionListener)this);
        return composite2;
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 50;
        gridData.widthHint = 100;
        table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditorArray = new CellEditor[COLUMNS.length];
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(TestUIPlugin.getString("REP_COL_NAME"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        cellEditorArray[0] = new TextCellEditor((Composite)table);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setText(TestUIPlugin.getString("REP_COL_FILE"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return object2 instanceof ReportDescription && !((ReportDescription)object2).isDefinedByPlugin();
            }
        });
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this.tableViewer.getTable(), (String)(TestUIPlugin.getID() + ".rgpp0013"));
    }

    private void createButtons(Composite composite) {
        this.btnAdd = new Button(composite, 8);
        this.btnAdd.setText(TestUIPlugin.getString("label.Add"));
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.widthHint = 20;
        this.btnAdd.setLayoutData((Object)gridData);
        this.btnRemove = new Button(composite, 8);
        this.btnRemove.setText(TestUIPlugin.getString("label.Remove"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.widthHint = 20;
        this.btnRemove.setLayoutData((Object)gridData);
        this.btnRemove.setEnabled(false);
        Composite composite2 = new Composite(composite, 0);
        gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.btnRename = new Button(composite, 8);
        this.btnRename.setText(TestUIPlugin.getString("label.Update"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.widthHint = 20;
        this.btnRename.setLayoutData((Object)gridData);
        this.btnRename.setEnabled(false);
        this.btnTest = new Button(composite, 8);
        this.btnTest.setText(TestUIPlugin.getString("label.Test"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.widthHint = 20;
        this.btnTest.setLayoutData((Object)gridData);
        this.btnTest.setEnabled(false);
        WorkbenchHelp.setHelp((Control)this.btnAdd, (String)(TestUIPlugin.getID() + ".rgpp0002"));
        WorkbenchHelp.setHelp((Control)this.btnRemove, (String)(TestUIPlugin.getID() + ".rgpp0003"));
        WorkbenchHelp.setHelp((Control)this.btnRename, (String)(TestUIPlugin.getID() + ".rgpp0004"));
        WorkbenchHelp.setHelp((Control)this.btnTest, (String)(TestUIPlugin.getID() + ".rgpp0005"));
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object;
        Object object2;
        ReportDialog reportDialog;
        block15: {
            block17: {
                block16: {
                    block14: {
                        if (selectionEvent.widget != this.btnAdd) break block14;
                        reportDialog = new ReportDialog(this.getShell(), null);
                        reportDialog.open();
                        if (reportDialog.getReturnCode() == 0) {
                            object2 = reportDialog.getReportDefinition();
                            this.reportManager.addReportDefinition((IReportDescription)object2);
                            this.tableElements.add(object2);
                            this.tableViewer.refresh();
                            this.tableViewer.setSelection((ISelection)new StructuredSelection(object2));
                        }
                        break block15;
                    }
                    if (selectionEvent.widget != this.btnRemove) break block16;
                    reportDialog = (IStructuredSelection)this.tableViewer.getSelection();
                    if (reportDialog.size() > 0) {
                        object2 = reportDialog.iterator();
                        while (object2.hasNext()) {
                            object = (IReportDescription)object2.next();
                            this.reportManager.removeReportDefinition(object);
                            this.tableElements.remove(object);
                        }
                        this.tableViewer.refresh();
                    }
                    break block15;
                }
                if (selectionEvent.widget != this.btnRename) break block17;
                reportDialog = (IStructuredSelection)this.tableViewer.getSelection();
                if (reportDialog.size() <= 0 || !((object2 = reportDialog.getFirstElement()) instanceof ReportDescription)) break block15;
                object = new ReportDialog(this.getShell(), (ReportDescription)object2);
                object.open();
                if (object.getReturnCode() != 0) break block15;
                this.tableViewer.refresh();
                break block15;
            }
            if (selectionEvent.widget == this.btnTest && (reportDialog = (IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
                object2 = reportDialog.iterator();
                while (object2.hasNext()) {
                    String string;
                    String string2;
                    object = object2.next();
                    if (!(object instanceof ReportDescription)) continue;
                    ReportDescription reportDescription = (ReportDescription)object;
                    try {
                        String string3;
                        if (reportDescription.getReportGenerator() != null) {
                            string3 = "";
                            if (reportDescription.getClassName() != null) {
                                string3 = reportDescription.getClassName();
                            }
                            string2 = TestUIPlugin.getString("preferences.report.TestButton.Succeed", string3);
                            MessageDialog.openInformation((Shell)this.getShell(), (String)TestUIPlugin.getString("W_SUCCESS"), (String)string2);
                            continue;
                        }
                        string3 = "";
                        if (reportDescription.getClassName() != null) {
                            string3 = reportDescription.getClassName();
                        }
                        string2 = TestUIPlugin.getString("preferences.report.TestButton.Fail.CantFind", string3);
                        MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)string2);
                    }
                    catch (ClassCastException classCastException) {
                        string2 = "";
                        if (reportDescription.getClassName() != null) {
                            string2 = reportDescription.getClassName();
                        }
                        string = TestUIPlugin.getString("preferences.report.TestButton.Fail.Instance", string2);
                        MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)string);
                    }
                    catch (Exception exception) {
                        string = "";
                        if (reportDescription.getClassName() != null) {
                            string = reportDescription.getClassName();
                        }
                        String string4 = TestUIPlugin.getString("preferences.report.TestButton.Fail.CantFind", string);
                        MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)string4);
                    }
                }
            }
        }
        reportDialog = this.tableViewer.getSelection();
        this.btnRename.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnTest.setEnabled(false);
        if (reportDialog != null && reportDialog instanceof StructuredSelection && (object = (ReportDescription)(object2 = (StructuredSelection)reportDialog).getFirstElement()) != null) {
            boolean bl = object.isDefinedByPlugin();
            this.btnRename.setEnabled(!bl);
            this.btnRemove.setEnabled(!bl);
            this.btnTest.setEnabled(true);
        }
    }

    protected void openErrorMessageBox(String string) {
    }

    public Point computeSize() {
        Point point = super.computeSize();
        return point;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        this.reportManager.saveIntoPreferenceStore();
        return true;
    }

    private void initializeValues() {
        IReportDescription[] iReportDescriptionArray = this.reportManager.getReportDescriptions();
        int n = 0;
        while (n < iReportDescriptionArray.length) {
            this.tableElements.add(iReportDescriptionArray[n]);
            ++n;
        }
        this.tableViewer.setInput((Object)this.tableElements);
    }

    public class ReportDialog
    extends Dialog
    implements Listener {
        private ReportDescription report;
        private ReportGeneratorUI reportGeneratorUI;

        public ReportDialog(Shell shell, ReportDescription reportDescription) {
            super(shell);
            this.report = reportDescription;
        }

        protected Control createDialogArea(Composite composite) {
            if (this.report == null) {
                this.getShell().setText(TestUIPlugin.getString("ADD_REPORT_DESC_DLG"));
            } else {
                this.getShell().setText(TestUIPlugin.getString("EDIT_REPORT_DESC_DLG"));
            }
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)GridDataUtil.createFill());
            composite2.setLayout((Layout)new GridLayout());
            this.reportGeneratorUI = new ReportGeneratorUI(this.getShell());
            Composite composite3 = this.reportGeneratorUI.createControl(composite2);
            if (this.report != null) {
                this.reportGeneratorUI.setName(this.report.getName());
                this.reportGeneratorUI.setClassname(this.report.getClassName());
                this.reportGeneratorUI.setClasspath(this.report.getClassPath());
            }
            WorkbenchHelp.setHelp((Control)composite3, (String)(TestUIPlugin.getID() + ".rgpp0007"));
            return composite3;
        }

        protected Control createButtonBar(Composite composite) {
            Control control = super.createButtonBar(composite);
            this.reportGeneratorUI.registerListener(this);
            if (this.report == null) {
                this.getButton(0).setEnabled(false);
            }
            return control;
        }

        protected void okPressed() {
            if (this.report == null) {
                this.report = new ReportDescription(((Object)((Object)this)).getClass().getClassLoader(), this.reportGeneratorUI.getName(), this.reportGeneratorUI.getClassName(), this.reportGeneratorUI.getClassPath());
            } else {
                this.report.setName(this.reportGeneratorUI.getName());
                this.report.setClassName(this.reportGeneratorUI.getClassName());
                this.report.setClassPath(this.reportGeneratorUI.getClassPath());
            }
            super.okPressed();
        }

        public ReportDescription getReportDefinition() {
            return this.report;
        }

        public void handleEvent(Event event) {
            this.getButton(0).setEnabled(!this.reportGeneratorUI.getName().equals("") && !this.reportGeneratorUI.getClassName().equals(""));
        }
    }

    private class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return TestUIImages.INSTANCE.getImage("report_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ReportDescription) {
                ReportDescription reportDescription = (ReportDescription)object;
                if (n == 0) {
                    return reportDescription.getName();
                }
                if (n == 1) {
                    return reportDescription.getClassName();
                }
            }
            return "";
        }
    }

    private class PreferenceContentProvider
    implements IStructuredContentProvider {
        private PreferenceContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof ArrayList) {
                return ((ArrayList)object).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class ReportGeneratorUI
    implements SelectionListener,
    ModifyListener {
        private Text _classname;
        private Text _name;
        private Text _classpath;
        private Button _browseClass;
        private Button _browseDirPath;
        private Button _browseJarPath;
        private Shell shell;
        private Listener _listener;

        public ReportGeneratorUI(Shell shell) {
            this.shell = shell;
        }

        public Composite createArgumentsControl(Composite composite) {
            Label label = new Label(composite, 0);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 1;
            label.setText(TestUIPlugin.getString("CLASSPATH"));
            label.setLayoutData((Object)gridData);
            this._classpath = new Text(composite, 2882);
            gridData = GridDataUtil.createFill();
            gridData.heightHint = 100;
            gridData.widthHint = 250;
            this._classpath.setLayoutData((Object)gridData);
            Composite composite2 = new Composite(composite, 0);
            gridData = GridDataUtil.createVerticalFill();
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite2.setLayoutData((Object)gridData);
            composite2.setLayout((Layout)gridLayout);
            this._browseDirPath = new Button(composite2, 0x1000008);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            this._browseDirPath.setLayoutData((Object)gridData);
            this._browseDirPath.setText(TestUIPlugin.getString("ADD_DIRECTORY"));
            this._browseJarPath = new Button(composite2, 0x1000008);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 2;
            this._browseJarPath.setLayoutData((Object)gridData);
            this._browseJarPath.setText(TestUIPlugin.getString("ADD_JAR"));
            this._browseDirPath.addSelectionListener((SelectionListener)this);
            this._browseJarPath.addSelectionListener((SelectionListener)this);
            this._classname.addModifyListener((ModifyListener)this);
            WorkbenchHelp.setHelp((Control)this._classpath, (String)(TestUIPlugin.getID() + ".lpui0001"));
            return composite;
        }

        public Composite createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.verticalSpacing = 5;
            gridLayout.horizontalSpacing = 5;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridDataUtil.createFill();
            gridData.horizontalIndent = 5;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(TestUIPlugin.getString("label.Name"));
            this._name = new Text(composite2, 2052);
            gridData = GridDataUtil.createHorizontalFill();
            gridData.horizontalSpan = 2;
            this._name.setLayoutData((Object)gridData);
            label = new Label(composite2, 0);
            label.setText(TestUIPlugin.getString("preference.report.Classfile"));
            this._classname = new Text(composite2, 2052);
            this._classname.setLayoutData((Object)GridDataUtil.createHorizontalFill());
            Composite composite3 = new Composite(composite2, 0);
            gridData = GridDataUtil.createVerticalFill();
            gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite3.setLayoutData((Object)gridData);
            composite3.setLayout((Layout)gridLayout);
            this._browseClass = new Button(composite3, 0x1000008);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this._browseClass.setLayoutData((Object)gridData);
            this._browseClass.setText(TestUIPlugin.getString("BROWSE"));
            this._browseClass.addSelectionListener((SelectionListener)this);
            this._name.setFocus();
            this._name.addModifyListener((ModifyListener)this);
            this.createArgumentsControl(composite2);
            WorkbenchHelp.setHelp((Control)this._classname, (String)(TestUIPlugin.getID() + ".rgpp0011"));
            WorkbenchHelp.setHelp((Control)this._classpath, (String)(TestUIPlugin.getID() + ".rgpp0010"));
            WorkbenchHelp.setHelp((Control)this._name, (String)(TestUIPlugin.getID() + ".rgpp0012"));
            WorkbenchHelp.setHelp((Control)this._browseClass, (String)(TestUIPlugin.getID() + ".rgpp0006"));
            WorkbenchHelp.setHelp((Control)this._browseDirPath, (String)(TestUIPlugin.getID() + ".rgpp0008"));
            WorkbenchHelp.setHelp((Control)this._browseJarPath, (String)(TestUIPlugin.getID() + ".rgpp0009"));
            return composite2;
        }

        public void enable(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this._classname.setEnabled(bl);
            this._browseClass.setEnabled(bl3);
            this._classpath.setEnabled(bl2);
            this._name.setEnabled(bl2);
            this._browseDirPath.setEnabled(bl4);
            this._browseJarPath.setEnabled(bl4);
            if (bl) {
                this._classname.setFocus();
                this._classname.selectAll();
            }
        }

        public String getClassName() {
            return this._classname.getText().trim();
        }

        public String getClassPath() {
            return this._classpath.getText().trim();
        }

        public Text getClassUI() {
            return this._classname;
        }

        public Control getBrowseJarButton() {
            return this._browseJarPath;
        }

        public Control getBrowseDirButton() {
            return this._browseDirPath;
        }

        public String getName() {
            return this._name.getText().trim();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            String string = System.getProperty("os.name");
            if (selectionEvent.widget == this._browseClass) {
                FileDialog fileDialog = new FileDialog(this.shell);
                fileDialog.setFilterExtensions(new String[]{"*.class"});
                fileDialog.open();
                String string2 = fileDialog.getFileName();
                if (string2 != null && !string2.equals("")) {
                    String string3;
                    if (string2.endsWith(".class")) {
                        string2 = string2.substring(0, string2.length() - 6);
                    }
                    this._classname.setText(string2);
                    String string4 = fileDialog.getFilterPath();
                    if (string != null && string.startsWith("Windows") && string4.endsWith(":")) {
                        string4 = string4 + "\\";
                    }
                    string3 = (string3 = this._classpath.getText().trim()).equals("") || string3.endsWith(File.pathSeparator) ? string3 : string3 + File.pathSeparator;
                    this._classpath.setText(string3 + string4);
                }
            } else if (selectionEvent.widget == this._browseDirPath) {
                DirectoryDialog directoryDialog = new DirectoryDialog(this.shell);
                String string5 = directoryDialog.open();
                if (string5 != null && !string5.equals("")) {
                    String string6;
                    if (string != null && string.startsWith("Windows") && string5.endsWith(":")) {
                        string5 = string5 + "\\";
                    }
                    string6 = (string6 = this._classpath.getText().trim()).equals("") || string6.endsWith(File.pathSeparator) ? string6 : string6 + File.pathSeparator;
                    string5 = string6 + string5;
                    this._classpath.setText(string5);
                    this._classpath.setFocus();
                }
            } else if (selectionEvent.widget == this._browseJarPath) {
                FileDialog fileDialog = new FileDialog(this.shell);
                fileDialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
                fileDialog.open();
                String string7 = fileDialog.getFileName();
                if (string7 != null && !string7.equals("")) {
                    string7 = fileDialog.getFilterPath() + File.separator + string7;
                    String string8 = this._classpath.getText().trim();
                    string8 = string8.equals("") || string8.endsWith(File.pathSeparator) ? string8 : string8 + File.pathSeparator;
                    string7 = string8 + string7;
                    this._classpath.setText(string7);
                }
            }
        }

        public void modifyText(ModifyEvent modifyEvent) {
            this.notifyListener();
        }

        public void setClassname(String string) {
            this._classname.setText(string);
        }

        public void setClasspath(String string) {
            if (string != null) {
                this._classpath.setText(string);
            }
        }

        public void setName(String string) {
            this._name.setText(string);
        }

        public void registerListener(Listener listener) {
            this._listener = listener;
        }

        public void notifyListener() {
            if (this._listener != null) {
                this._listener.handleEvent(null);
            }
        }
    }
}

