/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.preference;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TestPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private Button openEditorAfterCreationCheckBox;
    private Text saveManagerIntervalText;
    private Text localPort;
    private Text defaultHostName;

    public TestPreferencePage() {
        this.setPreferenceStore(TestUIPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 10;
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 20;
        composite2.setLayout((Layout)gridLayout);
        this.openEditorAfterCreationCheckBox = new Button(composite2, 32);
        this.openEditorAfterCreationCheckBox.setText(TestUIPlugin.getString("OPEN_EDITOR_PREF"));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Label label = new Label(composite3, 0);
        label.setText(TestUIPlugin.getString("SAVE_INT_PREF"));
        this.saveManagerIntervalText = new Text(composite3, 2048);
        this.saveManagerIntervalText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        label = new Label(composite3, 0);
        label.setText(TestUIPlugin.getString("STR_MSEC"));
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.makeColumnsEqualWidth = false;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        label = new Label(composite4, 0);
        label.setText(TestUIPlugin.getString("RAC_LOCALHOST_PORT_TEXT"));
        this.localPort = new Text(composite4, 2048);
        this.localPort.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.localPort.addModifyListener((ModifyListener)this);
        label = new Label(composite4, 0);
        label.setText(TestUIPlugin.getString("DEF_HOST_NME"));
        this.defaultHostName = new Text(composite4, 2048);
        this.defaultHostName.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.defaultHostName.addModifyListener((ModifyListener)this);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)composite, (String)(TestUIPlugin.getID() + ".tgpp0001"));
        WorkbenchHelp.setHelp((Control)this.defaultHostName, (String)(TestUIPlugin.getID() + ".tgpp0003"));
        WorkbenchHelp.setHelp((Control)this.localPort, (String)(TestUIPlugin.getID() + ".tgpp0004"));
        WorkbenchHelp.setHelp((Control)this.openEditorAfterCreationCheckBox, (String)(TestUIPlugin.getID() + ".tgpp0002"));
        WorkbenchHelp.setHelp((Control)this.saveManagerIntervalText, (String)(TestUIPlugin.getID() + ".tgpp0005"));
        return composite2;
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.openEditorAfterCreationCheckBox.setSelection(iPreferenceStore.getBoolean("openEditor"));
        this.saveManagerIntervalText.setText(String.valueOf(iPreferenceStore.getLong("saveInterval")));
        this.localPort.setText(iPreferenceStore.getString("localhost_port"));
        this.defaultHostName.setText(iPreferenceStore.getString("default_host_name"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return TestUIPlugin.getInstance().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.openEditorAfterCreationCheckBox.setSelection(iPreferenceStore.getDefaultBoolean("openEditor"));
        this.saveManagerIntervalText.setText(String.valueOf(iPreferenceStore.getDefaultLong("saveInterval")));
        this.localPort.setText(iPreferenceStore.getDefaultString("localhost_port"));
        this.defaultHostName.setText(iPreferenceStore.getDefaultString("default_host_name"));
    }

    public boolean performOk() {
        this.storeValues();
        TestUIPlugin.getInstance().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("openEditor", this.openEditorAfterCreationCheckBox.getSelection());
        try {
            iPreferenceStore.setValue("saveInterval", Long.parseLong(this.saveManagerIntervalText.getText().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        iPreferenceStore.setValue("localhost_port", this.localPort.getText().trim());
        iPreferenceStore.setValue("default_host_name", this.defaultHostName.getText().trim());
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void modifyText(ModifyEvent modifyEvent) {
        block4: {
            if (modifyEvent.widget != this.localPort) break block4;
            try {
                if (this.localPort.getText().trim() == "") {
                    this.setErrorMessage(TestUIPlugin.getString("RAC_EMPTY_PORT"));
                    return;
                }
                int n = Integer.parseInt(this.localPort.getText().trim());
                if (n < 0) {
                    this.setErrorMessage(TestUIPlugin.getString("RAC_INVALID_PORT"));
                    this.localPort.setFocus();
                    return;
                }
                this.setErrorMessage(null);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(TestUIPlugin.getString("RAC_INVALID_PORT"));
                this.localPort.setFocus();
            }
        }
    }
}

