/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestSuiteHTNConverter;
import org.eclipse.hyades.test.ui.internal.wizard.TestCaseSelectionPage;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class TestCaseDefinitionPage
extends WizardPage {
    private Text TSNameText;
    private ITestSuite TSElem;

    public TestCaseDefinitionPage(String string, IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super(string);
        this.setTitle(TestUIPlugin.getString("WIZ_TST_CASE_DESC_PG_TTL"));
        this.setDescription(TestUIPlugin.getString("WIZ_TST_CASE_DESC_PG_DSC"));
        this.init(iStructuredSelection);
    }

    private void init(IStructuredSelection iStructuredSelection) {
        Object object;
        Object object2 = iStructuredSelection.getFirstElement();
        if (object2 instanceof ITestSuite) {
            this.setTestSuite((ITestSuite)object2);
        } else if (object2 instanceof IResource && (object = new TestSuiteHTNConverter().getObjectFromResource((IResource)object2)) instanceof ITestSuite) {
            this.setTestSuite((ITestSuite)object);
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.createTestSuiteControl(composite2);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite2);
    }

    private void createTestSuiteControl(Composite composite) {
        Label label = new Label(composite, 16448);
        label.setFont(composite.getFont());
        label.setText(TestUIPlugin.getString("WIZ_SEL_TST_SUITE"));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.TSNameText = new Text(composite, 2052);
        this.TSNameText.setText(this.getTestSuite() == null ? "" : this.getTestSuite().getName());
        this.TSNameText.setEnabled(false);
        this.TSNameText.setFont(composite.getFont());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.TSNameText.setLayoutData((Object)gridData);
        this.TSNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TestCaseDefinitionPage.this.setPageComplete(TestCaseDefinitionPage.this.validatePage());
            }
        });
        Button button = new Button(composite, 8);
        button.setText(TestUIPlugin.getString("BROWSE"));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TestCaseDefinitionPage.this.browseTS();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    protected void browseTS() {
        TestSuiteHTNConverter testSuiteHTNConverter;
        Object object;
        Object[] objectArray;
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        StandardJavaElementContentProvider standardJavaElementContentProvider = new StandardJavaElementContentProvider();
        String string = TestUIPlugin.getString("WIZ_SEL_TST_SUITE_DLG_TTL");
        String string2 = TestUIPlugin.getString("WIZ_SEL_TST_SUITE_DLG_MSG");
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider, (ITreeContentProvider)standardJavaElementContentProvider);
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)new TestSuiteValidator());
        elementTreeSelectionDialog.addFilter((ViewerFilter)new TestSuiteFilter());
        elementTreeSelectionDialog.setTitle(string);
        elementTreeSelectionDialog.setMessage(string2);
        elementTreeSelectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        elementTreeSelectionDialog.setSorter((ViewerSorter)new ResourceSorter(1));
        ITestSuite iTestSuite = null;
        if (elementTreeSelectionDialog.open() == 0 && (objectArray = elementTreeSelectionDialog.getResult())[0] instanceof IResource && (object = (testSuiteHTNConverter = new TestSuiteHTNConverter()).getObjectFromResource((IResource)objectArray[0])) != null && object instanceof ITestSuite) {
            iTestSuite = (ITestSuite)object;
            this.setTestSuite(iTestSuite);
        }
        if (iTestSuite != null) {
            this.setText(iTestSuite.getName());
        }
    }

    private void setText(String string) {
        if (this.TSNameText != null) {
            this.TSNameText.setText(string);
        }
    }

    protected boolean validatePage() {
        return this.getTestSuite() != null;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        IWizardPage iWizardPage = super.getNextPage();
        if (iWizardPage instanceof TestCaseSelectionPage) {
            TestCaseSelectionPage testCaseSelectionPage = (TestCaseSelectionPage)iWizardPage;
            if (this.isCurrentPage()) {
                Object object;
                HashMap hashMap = new HashMap();
                ITestSuite iTestSuite = this.getTestSuite();
                if (iTestSuite == null) {
                    return iWizardPage;
                }
                String string = iTestSuite.getType();
                if (string == null) {
                    return iWizardPage;
                }
                HashSet<String> hashSet = new HashSet<String>();
                hashMap.put(string, hashSet);
                IAssociationMapping iAssociationMapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeValidators");
                IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors(string);
                if (iAssociationDescriptorArray.length == 0) {
                    super.getNextPage();
                }
                IAssociationMapping iAssociationMapping2 = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards");
                String[] stringArray = iAssociationMapping2.getTypes();
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    int n3 = 0;
                    int n4 = iAssociationDescriptorArray.length;
                    while (n3 < n4) {
                        object = (ITypeValidator)iAssociationDescriptorArray[n3].createImplementationClassInstance();
                        if (object.isValidType(stringArray[n])) {
                            hashSet.add(stringArray[n]);
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
                ArrayList<WizardElement> arrayList = new ArrayList<WizardElement>(hashSet.size());
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    IAssociationDescriptor[] iAssociationDescriptorArray2 = iAssociationMapping2.getAssociationDescriptors((String)object);
                    int n5 = 0;
                    int n6 = iAssociationDescriptorArray2.length;
                    while (n5 < n6) {
                        Object object2 = iAssociationDescriptorArray2[n5].createImplementationClassInstance();
                        if (object2 instanceof ITestCaseWizard) {
                            WizardElement wizardElement = new WizardElement((IWizard)((ITestCaseWizard)object2));
                            wizardElement.setId(iAssociationDescriptorArray2[n5].getId());
                            wizardElement.setLabel(iAssociationDescriptorArray2[n5].getName());
                            wizardElement.setDescription(iAssociationDescriptorArray2[n5].getDescription());
                            wizardElement.setImageDescriptor(iAssociationDescriptorArray2[n5].getImageDescriptor());
                            arrayList.add(wizardElement);
                        }
                        ++n5;
                    }
                }
                testCaseSelectionPage.setTestSuite(this.getTestSuite());
                testCaseSelectionPage.setWizardElements(arrayList.toArray(new IWizardElement[arrayList.size()]));
            }
        }
        return iWizardPage;
    }

    public ITestSuite getTestSuite() {
        return this.TSElem;
    }

    public void setTestSuite(ITestSuite iTestSuite) {
        this.TSElem = iTestSuite;
    }

    private class TestSuiteFilter
    extends ViewerFilter {
        private TestSuiteFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof IPackageFragmentRoot) {
                return !((IPackageFragmentRoot)object2).isArchive();
            }
            if (object2 instanceof IFile) {
                Object object3 = new TestSuiteHTNConverter().getObjectFromResource((IResource)((IFile)object2));
                return object3 != null && object3 instanceof TPFTestSuite;
            }
            return true;
        }
    }

    private class TestSuiteValidator
    implements ISelectionStatusValidator {
        private final IStatus errorStatus = new Status(4, TestUIPlugin.getID(), 4, TestUIPlugin.getString("WIZ_SEL_INVALID"), null);
        private final IStatus okStatus = new Status(0, TestUIPlugin.getID(), 0, "", null);
        private TestSuiteHTNConverter converter = new TestSuiteHTNConverter();

        public IStatus validate(Object[] objectArray) {
            int n = objectArray.length;
            if (n > 1) {
                return this.errorStatus;
            }
            int n2 = 0;
            while (n2 < n) {
                Object object;
                if (objectArray[n2] instanceof IResource && (object = this.converter.getObjectFromResource((IResource)objectArray[n2])) != null && object instanceof TPFTestSuite) {
                    return this.okStatus;
                }
                ++n2;
            }
            return this.errorStatus;
        }
    }
}

