/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class StatisticalModelGraphEditor
extends EditorPart
implements Dirtiable,
IResourceChangeListener {
    long last_modified = 0L;
    IEditorSite site;
    IFileEditorInput input;
    IFile file;
    String filename;
    ArrayList configs = new ArrayList();
    StatisticalModelGraphViewer agg_editor;
    ArrayList disposables = new ArrayList();
    boolean dirty = false;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.site = iEditorSite;
        this.input = (IFileEditorInput)iEditorInput;
        EditorPlugin.DBG.info("StatCon Editor got editor input");
        this.file = this.input.getFile();
        this.filename = this.file.getName();
        this.setTitle("StatCon - " + this.file.getName());
        EditorPlugin.DBG.info("set title - " + this.getTitle());
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace.addResourceChangeListener((IResourceChangeListener)this);
        try {
            EditorPlugin.DBG.info("loading file");
            this.load(this.file);
            this.last_modified = this.file.getModificationStamp();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            throw new PartInitException(EditorPlugin.getString("ERROR_OCCURRED") + ":" + coreException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new PartInitException(EditorPlugin.getString("IO_ERROR_OCCURRED") + ":" + iOException.getMessage());
        }
        if (this.configs.size() == 0) {
            throw new PartInitException(EditorPlugin.getString("NO_STAT_MODEL_FOUND"));
        }
    }

    public void load(IFile iFile) throws CoreException, IOException {
        if (iFile == null) {
            throw new IOException(EditorPlugin.getString("NULL_FILE"));
        }
        this.configs.add(iFile);
        EditorPlugin.DBG.info("asked to load file URI " + URI.createPlatformResourceURI((String)iFile.getFullPath().toString()));
    }

    public void createPartControl(Composite composite) {
        System.gc();
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        double d = l2 - l;
        d /= (double)l2;
        EditorPlugin.DBG.info("MEMORY USED = " + (l2 - l) / 1024L + "k (" + (d *= 100.0) + "%)");
        URI uRI = null;
        try {
            uRI = URI.createPlatformResourceURI((String)this.file.getParent().getFullPath().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.agg_editor = new StatisticalModelGraphViewer(composite, 0, false, this, uRI);
        int n = 0;
        while (n < this.configs.size()) {
            try {
                IFile iFile = (IFile)this.configs.get(n);
                InputStream inputStream = iFile.getContents();
                this.agg_editor.applyConfig(inputStream);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
        this.setDirty(false);
        this.disposables.add(this.agg_editor);
    }

    public void dispose() {
        this.agg_editor.unloadModules();
        super.dispose();
        int n = 0;
        while (n < this.disposables.size()) {
            try {
                Object e = this.disposables.get(n);
                if (e != null) {
                    if (e instanceof Widget) {
                        ((Widget)e).dispose();
                    } else if (e instanceof Color) {
                        ((Color)e).dispose();
                    } else if (e instanceof Image) {
                        ((Image)e).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(e);
                        }
                        catch (Throwable throwable) {
                            EditorPlugin.DBG.warning("failed to dispose object " + e);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.error("failed to dispose properly", throwable);
            }
            ++n;
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent == null) {
            return;
        }
        if (iResourceChangeEvent.getDelta() == null) {
            return;
        }
        try {
            if (this.agg_editor.getGraphWindow().isDisposed()) {
                return;
            }
            if (!((iResourceChangeEvent.getDelta().getKind() & 2) == 0 && (iResourceChangeEvent.getDelta().getKind() & 4) == 0 || this.file.exists())) {
                this.agg_editor.getGraphWindow().getDisplay().asyncExec((Runnable)new EditorClose());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean requestOverwrite() {
        try {
            this.file.refreshLocal(0, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.last_modified != this.file.getModificationStamp()) {
            MessageBox messageBox = new MessageBox(this.agg_editor.getGraphWindow().getShell(), 456);
            messageBox.setMessage(EditorPlugin.getString("EDITOR_FILE_CHANGED"));
            messageBox.setText(EditorPlugin.getString("EDITOR_FILE_CHANGED_TITLE"));
            int n = messageBox.open();
            if (n != 64) {
                return false;
            }
        }
        return true;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        EditorPlugin.DBG.info("saving file");
        if (!this.requestOverwrite()) {
            return;
        }
        try {
            String string = this.agg_editor.generateConfig();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            if (this.file.exists()) {
                this.file.setContents((InputStream)byteArrayInputStream, true, false, null);
            } else {
                this.file.create((InputStream)byteArrayInputStream, true, null);
            }
            this.last_modified = this.file.getModificationStamp();
            this.setDirty(false);
        }
        catch (Throwable throwable) {
            EditorPlugin.DBG.error("problem saving file", throwable);
        }
    }

    public void doSaveAs() {
        block6: {
            EditorPlugin.DBG.info("saving file As");
            if (!this.requestOverwrite()) {
                return;
            }
            try {
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                FileDialog fileDialog = new FileDialog(this.agg_editor.getGraphWindow().getShell(), 8192);
                fileDialog.setFileName("new.statcon");
                fileDialog.setFilterExtensions(new String[]{".statcon"});
                fileDialog.setFilterPath(iWorkspaceRoot.getLocation().toString());
                String string = fileDialog.open();
                EditorPlugin.DBG.info("user selected file " + string);
                if (string != null) {
                    Path path = new Path(string);
                    EditorPlugin.DBG.info("user selected path " + path);
                    IFile iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
                    String string2 = this.agg_editor.generateConfig();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                    EditorPlugin.DBG.info("trying to set contents of " + iFile);
                    if (iFile.exists()) {
                        iFile.setContents((InputStream)byteArrayInputStream, true, false, null);
                    } else {
                        iFile.create((InputStream)byteArrayInputStream, true, null);
                    }
                    EditorPlugin.DBG.info("new file saved ok");
                    this.last_modified = iFile.getModificationStamp();
                    break block6;
                }
                EditorPlugin.DBG.info("user cancelled Save As");
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.error("problem saving file As", throwable);
            }
        }
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setFocus() {
    }

    public class EditorClose
    implements Runnable {
        public void run() {
            EditorPlugin.DBG.info("closing Editor");
            if (!StatisticalModelGraphEditor.this.isDirty()) {
                EditorPlugin.DBG.info("editor is not dirty - will close now");
                StatisticalModelGraphEditor.this.site.getPage().closeEditor((IEditorPart)StatisticalModelGraphEditor.this, false);
            } else {
                EditorPlugin.DBG.info("file has been deleted, editor is dirty - asking user for input");
                MessageBox messageBox = new MessageBox(StatisticalModelGraphEditor.this.agg_editor.getGraphWindow().getShell(), 200);
                messageBox.setMessage(EditorPlugin.getString("EDITOR_FILE_DELETED") + " (" + StatisticalModelGraphEditor.this.filename + "), " + EditorPlugin.getString("EDITOR_FILE_DELETED_2"));
                messageBox.setText(EditorPlugin.getString("EDITOR_FILE_DELETED_TITLE") + " - " + StatisticalModelGraphEditor.this.getTitle());
                int n = messageBox.open();
                if (n == 64) {
                    StatisticalModelGraphEditor.this.last_modified = -1L;
                    StatisticalModelGraphEditor.this.doSaveAs();
                }
                StatisticalModelGraphEditor.this.site.getPage().closeEditor((IEditorPart)StatisticalModelGraphEditor.this, false);
            }
        }
    }
}

