/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ZoomImageBar
extends ZoomControlBar {
    Image barImage;
    Image enabledImage;
    Image disabledImage;
    int imageWidth;
    int imageHeight;

    public ZoomImageBar(ZoomSlider zoomSlider, double d, Image image, Image image2, int n) {
        super(zoomSlider, d);
        this.size = n;
        this.enabledImage = image;
        this.disabledImage = image2;
        this.barImage = image;
        this.imageWidth = this.barImage.getBounds().width;
        this.imageHeight = this.barImage.getBounds().height;
    }

    public void paint(GC gC) {
        this.area = this.getDrawingArea(this.value);
        if (this.image == null) {
            Image image = new Image((Device)this.slider.getDisplay(), this.area.width, this.area.height);
            this.draw3DBox(new GC((Drawable)image), 0, 0, this.area.width, this.area.height, this.color);
            ImageData imageData = image.getImageData();
            image.dispose();
            int n = 0;
            while (n < this.area.width) {
                int n2 = 0;
                while (n2 < this.area.height) {
                    imageData.setAlpha(n, n2, 180);
                    ++n2;
                }
                ++n;
            }
            this.image = new Image((Device)this.slider.getDisplay(), imageData);
        }
        gC.drawImage(this.image, this.area.x, this.area.y);
        try {
            gC.drawImage(this.barImage, this.area.x + this.area.width / 2 - this.imageWidth / 2, this.area.y + this.area.height / 2 - this.imageHeight / 2);
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.barImage = bl ? this.enabledImage : this.disabledImage;
        this.imageWidth = this.barImage.getBounds().width;
        this.imageHeight = this.barImage.getBounds().height;
        this.slider.updateScale();
    }
}

