/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Vector;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomIndicator;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ZoomIndicatorsCollection {
    static final int IDEAL_WIDTH = 7;
    static final int INDENT = 6;
    ZoomSlider slider;
    Vector indicators = new Vector();
    int width = 7;
    int startPoint;

    public ZoomIndicatorsCollection(ZoomSlider zoomSlider) {
        this.slider = zoomSlider;
    }

    public void add(ZoomIndicator zoomIndicator) {
        if (zoomIndicator != null && !this.indicators.contains(zoomIndicator)) {
            this.indicators.addElement(zoomIndicator);
            this.calculatePositions();
        }
    }

    public void remove(ZoomIndicator zoomIndicator) {
        if (zoomIndicator != null && this.indicators.contains(zoomIndicator)) {
            this.indicators.removeElement(zoomIndicator);
            this.calculatePositions();
        }
    }

    public void calculatePositions() {
        if (this.indicators.size() > 0) {
            int n = this.slider.getBounds().width;
            if (this.slider.getOrientation() == 1) {
                n = this.slider.getBounds().height;
            }
            this.width = (n - 12) / this.indicators.size();
            if (this.width > 7) {
                this.width = 7;
            }
            this.startPoint = n / 2 - this.width / 2 * this.indicators.size();
        }
    }

    public void paint(GC gC, Image image) {
        int n = 0;
        while (n < this.indicators.size()) {
            ((ZoomIndicator)this.indicators.elementAt(n)).paint(gC, image, this.startPoint + n * this.width, this.width);
            ++n;
        }
    }

    public Vector getZoomIndicators() {
        return this.indicators;
    }

    public void setXORColors() {
        int n = 0;
        while (n < this.indicators.size()) {
            ((ZoomIndicator)this.indicators.elementAt(n)).setXORColor();
            ++n;
        }
    }

    public void dispose() {
        int n = 0;
        while (n < this.indicators.size()) {
            ((ZoomIndicator)this.indicators.elementAt(n)).dispose();
            ++n;
        }
    }
}

