/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderUtilities;
import org.eclipse.swt.graphics.GC;

public class ZoomSliderTick {
    ZoomSlider slider;
    public double value;
    int pixel;
    public String representation;
    public boolean textVisible;

    public ZoomSliderTick() {
    }

    public ZoomSliderTick(ZoomSlider zoomSlider, double d) {
        this.slider = zoomSlider;
        this.value = d;
        this.pixel = (int)zoomSlider.value2Pixel(this.value);
        this.representation = ZoomSliderUtilities.double2String(this.value);
        this.textVisible = this.isTextVisible();
    }

    public int getPixel() {
        return this.pixel;
    }

    private String throughput(double d) {
        if (d == 0.0) {
            return "";
        }
        return String.valueOf(ZoomSliderUtilities.round(60000.0 / d, 1.0E-4));
    }

    public void paintLine(GC gC) {
        gC.setForeground(this.slider.foregroundColor);
        if (this.slider.getOrientation() == 0) {
            if (this.textVisible) {
                gC.drawLine(0, this.pixel, this.slider.getBounds().width, this.pixel);
            } else {
                gC.drawLine(0, this.pixel, 5, this.pixel);
                gC.drawLine(this.slider.getBounds().width - 5, this.pixel, this.slider.getBounds().width - 1, this.pixel);
            }
        } else if (this.textVisible) {
            gC.drawLine(this.pixel, 0, this.pixel, this.slider.getBounds().height);
        } else {
            gC.drawLine(this.pixel, 0, this.pixel, 5);
            gC.drawLine(this.pixel, this.slider.getBounds().height - 5, this.pixel, this.slider.getBounds().height - 1);
        }
    }

    public void paintText(GC gC) {
        if (this.textVisible) {
            int n;
            int n2 = gC.getFontMetrics().getAscent();
            int n3 = n = gC.stringExtent((String)this.representation).x;
            int n4 = this.representation.indexOf(".");
            if (n4 != -1) {
                n3 = gC.stringExtent((String)this.representation.substring((int)0, (int)n4)).x;
            }
            int n5 = 0;
            int n6 = 0;
            gC.setBackground(this.slider.backgroundColor);
            if (this.slider.getOrientation() == 0) {
                n5 = this.slider.getDecimalPointPosition() - n3;
                n6 = this.pixel - gC.stringExtent((String)this.representation).y / 2;
                gC.fillRectangle(n5 - 2, n6, n + 4, gC.stringExtent((String)this.representation).y);
            } else {
                n5 = this.pixel - n / 2;
                if (this.overlaps(this.slider.getLastVisible(), gC)) {
                    return;
                }
                this.slider.setLastVisible(this);
                n6 = this.slider.getBounds().height / 2 - this.slider.getFontHeight() / 2 - 1;
                gC.fillRectangle(n5, n6, n, n2 + 2);
            }
            gC.setForeground(this.slider.foregroundColor);
            gC.drawString(this.representation, n5, n6 - 1, true);
        }
    }

    protected boolean isTextVisible() {
        int n;
        int n2 = this.representation.indexOf(46);
        if (n2 == -1) {
            n2 = this.representation.length();
        }
        if ((n = this.slider.getIncrementOOM()) >= 0) {
            ++n;
        }
        try {
            char c = this.representation.charAt(n2 - n);
            if (c == '0') {
                return true;
            }
            if (c == '5') {
                return this.slider.getIncrement() != 5.0 * Math.pow(10.0, this.slider.getIncrementOOM());
            }
            if (c == '2') {
                return false;
            }
            return false;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return true;
        }
    }

    public boolean overlaps(ZoomSliderTick zoomSliderTick, GC gC) {
        if (zoomSliderTick == null) {
            return false;
        }
        return zoomSliderTick.pixel > this.pixel ? zoomSliderTick.pixel < this.pixel + gC.stringExtent((String)this.representation).x + 5 : zoomSliderTick.pixel > this.pixel - gC.stringExtent((String)this.representation).x - 5;
    }
}

