/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ExecutionStatistic
extends StatisticView
implements ITimeChangedListener {
    protected String tmpString;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");

    protected Composite createTable(Composite composite, int n) {
        return new TableTree(composite, n);
    }

    public ExecutionStatistic(Composite composite, TraceViewerPage traceViewerPage) {
        super(composite, traceViewerPage);
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
        this._viewerFilter = new ExecutionStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "Exec51";
    }

    public String getDefaultColumnsTemplate() {
        String string = TraceUIPlugin.getString("STR_THREAD_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_INSTANCE_INDEX") + ":1:" + String.valueOf(1) + ":left:200," + TraceUIPlugin.getString("TITLE_START_TIME") + ":2:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("TITLE_TIME_ON_STACK") + ":3:" + String.valueOf(1) + ":right:100";
        return string;
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        ExecutionTreeViewer executionTreeViewer = new ExecutionTreeViewer((TableTree)composite);
        return executionTreeViewer;
    }

    protected void handleSelectionEvent() {
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getUpdateAction());
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    public void updateButtons() {
    }

    protected void updateDetailsPane() {
        int n = this.getTable().getSelectionIndex();
        if (n < 0) {
            return;
        }
        TableItem tableItem = this.getTable().getItem(n);
        Object object = tableItem.getData();
        if (object == null) {
            return;
        }
        if (object != null && object instanceof TableTreeItem) {
            object = ((TableTreeItem)object).getData();
        }
    }

    public void updateModelSelection() {
        ISelection iSelection = this.getTableViewer().getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add(object);
            ViewSelectionChangedEvent viewSelectionChangedEvent = UIPlugin.getDefault().getViewSelectionChangedEvent();
            viewSelectionChangedEvent.setSource((Object)this._page.getMOFObject());
            UIPlugin.getDefault().notifyViewSelectionChangedListener(viewSelectionChangedEvent);
        }
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn tableColumn = table.getColumn(2);
            this._viewerSorter = new ExecutionStatisticSorter();
            this.getViewerSorter().setSortedColumn(tableColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
            this.handleTimeChangedEvent();
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.handleSelectionEvent();
    }

    public void handleTimeChangedEvent() {
        Action action = ((ExecutionStatisticPage)this.getTraceViewerPage()).baseTime();
        Action action2 = ((ExecutionStatisticPage)this.getTraceViewerPage()).rawTime();
        this._drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (action != null) {
            action.setChecked(this._drawMode == 0);
        }
        if (action2 != null) {
            action2.setChecked(this._drawMode == 1);
        }
        String string = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
        String string2 = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
        if (this._drawMode == 1) {
            string2 = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
            string = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
        }
        Table table = this.getTable();
        int n = table.getColumnCount();
        while (n > 0) {
            TableColumn tableColumn = table.getColumn(table.getColumnCount() - 1);
            StatisticTableColumnInfo statisticTableColumnInfo = (StatisticTableColumnInfo)tableColumn.getData();
            String string3 = statisticTableColumnInfo.getColumnData().name();
            if (string3.equals(string)) {
                statisticTableColumnInfo.getColumnData().name(string2);
                if (statisticTableColumnInfo.isSortColumn()) {
                    string2 = tableColumn.getText().substring(0, 1) + string2;
                }
                tableColumn.setText(string2);
            }
            --n;
        }
        this.getTableViewer().refresh();
    }

    public void dispose() {
        super.dispose();
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
    }

    public IContentProvider getContentProvider() {
        return new ExecutionStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ExecutionStatisticLableProvider(this);
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        if (!this.getTraceViewerPage().getTraceViewer().isProcessRefreshEvents() || this.getTable().isFocusControl()) {
            return;
        }
        this.handleSelectionEvent();
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllThreads(this._page.getMOFObject()).length <= 0;
    }

    class ExecutionTreeViewer
    extends TableTreeViewer {
        public ExecutionTreeViewer(Composite composite) {
            super(composite);
        }

        public ExecutionTreeViewer(TableTree tableTree) {
            super(tableTree);
        }

        public void expandItem(TableTreeItem tableTreeItem) {
            tableTreeItem.setExpanded(true);
            this.createChildren((Widget)tableTreeItem);
        }
    }

    public class ExecutionStatisticLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ExecutionStatisticLableProvider(StatisticView statisticView) {
            this._viewer = statisticView;
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            int n2 = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n)).getColumnData().getInitalPos();
            if (object instanceof TRCThread && n2 == 0) {
                return PerftraceUtil.getThreadName((TRCThread)object);
            }
            if (object instanceof TRCMethodInvocation) {
                switch (n2) {
                    case 0: {
                        return ((TRCMethodInvocation)object).getMethod().getName();
                    }
                    case 1: {
                        TRCTraceObject tRCTraceObject = ((TRCMethodInvocation)object).getOwningObject();
                        TRCClass tRCClass = tRCTraceObject.getIsA();
                        return tRCClass.getName() + "." + tRCTraceObject.getId();
                    }
                    case 2: {
                        if (object instanceof TRCFullMethodInvocation) {
                            return PerftraceUtil.formatTimeValue(((TRCFullMethodInvocation)object).getEntryTime());
                        }
                    }
                    case 3: {
                        if (!(object instanceof TRCFullMethodInvocation)) break;
                        TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)object;
                        double d = tRCFullMethodInvocation.getEntryTime();
                        double d2 = tRCFullMethodInvocation.getExitTime();
                        double d3 = tRCFullMethodInvocation.getOverhead();
                        if (d2 == 0.0) {
                            d2 = tRCFullMethodInvocation.getOwningObject().getProcess().getLastEventTime();
                        }
                        if (ExecutionStatistic.this._drawMode == 0) {
                            return PerftraceUtil.formatTimeValue(d2 - d - d3);
                        }
                        return PerftraceUtil.formatTimeValue(d2 - d);
                    }
                }
            }
            return "";
        }
    }

    public class ExecutionStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object object) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            return PerftraceUtil.getAllThreads(ExecutionStatistic.this._page.getMOFObject());
        }

        public Object[] getChildren(Object object) {
            ExecutionStatistic.this.tmpList.clear();
            if (object instanceof TRCThread) {
                return ((TRCThread)object).getInitialInvocations().toArray();
            }
            TRCMethodInvocation tRCMethodInvocation = (TRCMethodInvocation)object;
            Object[] objectArray = tRCMethodInvocation.getInvokes().toArray();
            int n = 0;
            while (n < objectArray.length) {
                ExecutionStatistic.this.tmpList.add((TRCMethodInvocation)objectArray[n]);
                ++n;
            }
            return ExecutionStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object object) {
            if (object instanceof TRCThread) {
                return true;
            }
            return ((TRCMethodInvocation)object).getInvokes().size() > 0;
        }
    }

    public class ExecutionStatisticSorter
    extends StatisticView.StatisticSorter {
        public ExecutionStatisticSorter() {
            super(ExecutionStatistic.this);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            double d = 0.0;
            if (object instanceof TRCThread && object2 instanceof TRCThread && this._pos == 0) {
                return this._sortSequence * PerftraceUtil.getThreadName((TRCThread)object).compareToIgnoreCase(PerftraceUtil.getThreadName((TRCThread)object2));
            }
            if (object instanceof TRCFullMethodInvocation && object2 instanceof TRCFullMethodInvocation) {
                TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)object;
                TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)object2;
                if (this._pos == 0) {
                    return this._sortSequence * ((TRCMethodInvocation)object).getMethod().getName().compareToIgnoreCase(((TRCMethodInvocation)object2).getMethod().getName());
                }
                if (this._pos == 1) {
                    return this._sortSequence * PerftraceUtil.getClass((TRCMethodInvocation)tRCFullMethodInvocation).getName().compareToIgnoreCase(PerftraceUtil.getClass((TRCMethodInvocation)tRCFullMethodInvocation2).getName());
                }
                if (this._pos == 2) {
                    d = tRCFullMethodInvocation.getEntryTime() - tRCFullMethodInvocation2.getEntryTime();
                    if (d < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
                if (this._pos == 3) {
                    double d2 = tRCFullMethodInvocation.getEntryTime();
                    double d3 = tRCFullMethodInvocation.getExitTime();
                    if (d3 == 0.0) {
                        d3 = tRCFullMethodInvocation.getOwningObject().getProcess().getLastEventTime();
                    }
                    d = d3 - d2;
                    d2 = tRCFullMethodInvocation2.getEntryTime();
                    d3 = tRCFullMethodInvocation2.getExitTime();
                    if (d3 == 0.0) {
                        d3 = tRCFullMethodInvocation2.getOwningObject().getProcess().getLastEventTime();
                    }
                    if ((d -= d3 - d2) < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
            }
            return 0;
        }
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(ExecutionStatistic.this);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (!(object2 instanceof TRCThread)) {
                return true;
            }
            String string = "";
            string = ((TRCThread)object2).getName();
            if (string.equals("")) {
                string = TraceUIPlugin.getString("DEFAULT_PACKAGE");
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                string = string.toLowerCase();
            }
            if (this._exactMatch) {
                return string.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string2 = (String)this._textList.get(n);
                    int n2 = string.lastIndexOf(string2);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string = string.substring(n2 + string2.length());
                    ++n;
                }
            }
            return bl;
        }
    }
}

