/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageFolder;
import org.eclipse.hyades.trace.views.util.internal.CoverageLeaf;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;

public class CoverageAnalysis {
    private CoverageFolder root = null;
    private HashMap coveragesMap = null;

    public CoverageAnalysis(EObject eObject) {
        Object[] objectArray = PerftraceUtil.getAllPackages(eObject);
        BasicEList basicEList = new BasicEList();
        int n = 0;
        while (n < objectArray.length) {
            basicEList.add(n, objectArray[n]);
            ++n;
        }
        EList eList = this.filterPackages((EList)basicEList);
        if (eList != null) {
            this.root = this.compute(eList, eObject);
        }
    }

    public CoverageLeaf FindCoverageLeaf(CoverageFolder coverageFolder, EObject eObject) {
        TRCMethod tRCMethod;
        String string;
        CoverageLeaf coverageLeaf;
        if (this.coveragesMap == null) {
            this.coveragesMap = new HashMap();
        }
        if ((coverageLeaf = (CoverageLeaf)this.coveragesMap.get(string = CoverageAnalysis.getFullSig(tRCMethod = (TRCMethod)eObject))) == null) {
            coverageLeaf = new CoverageLeaf(this, coverageFolder);
            this.coveragesMap.put(string, coverageLeaf);
            coverageFolder.getChilds().add(coverageLeaf);
        }
        coverageLeaf.addTraceObjects(eObject);
        return coverageLeaf;
    }

    public CoverageFolder FindCoverageFolder(CoverageFolder coverageFolder, EObject eObject) {
        Object object;
        if (this.coveragesMap == null) {
            this.coveragesMap = new HashMap();
        }
        String string = null;
        if (eObject instanceof TRCClass) {
            object = (TRCClass)eObject;
            string = CoverageAnalysis.getFullSig((TRCClass)object);
        } else if (eObject instanceof TRCPackage) {
            object = (TRCPackage)eObject;
            string = CoverageAnalysis.getFullSig((TRCPackage)object);
        } else {
            string = eObject.toString();
        }
        object = (CoverageFolder)this.coveragesMap.get(string);
        if (object == null) {
            object = new CoverageFolder(this, coverageFolder);
            this.coveragesMap.put(string, object);
            coverageFolder.getChilds().add(object);
        }
        ((Coverage)object).addTraceObjects(eObject);
        return object;
    }

    private static String getSourceSig(TRCSourceInfo tRCSourceInfo) {
        return tRCSourceInfo != null ? tRCSourceInfo.getLocation() + ":" : "";
    }

    private static String getSig(TRCClass tRCClass) {
        return (tRCClass.getPackage().getName() == null ? "" : tRCClass.getPackage().getName() + ".") + tRCClass.getName();
    }

    public static String getFullSig(TRCMethod tRCMethod) {
        return CoverageAnalysis.getSourceSig(tRCMethod.getSourceInfo()) + tRCMethod.getLineNo() + ":" + CoverageAnalysis.getSig(tRCMethod.getDefiningClass()) + "." + tRCMethod.getName() + tRCMethod.getSignature();
    }

    public static String getFullSig(TRCClass tRCClass) {
        return CoverageAnalysis.getSourceSig(tRCClass.getSourceInfo()) + tRCClass.getLineNo() + ":" + CoverageAnalysis.getSig(tRCClass);
    }

    public static String getFullSig(TRCPackage tRCPackage) {
        return tRCPackage.getName();
    }

    protected EList filterPackages(EList eList) {
        if (eList == null) {
            return null;
        }
        ArrayList arrayList = this.filters();
        BasicEList basicEList = new BasicEList();
        int n = 0;
        while (n < eList.size()) {
            TRCPackage tRCPackage = (TRCPackage)eList.get(n);
            if (!this.isFiltered(tRCPackage, arrayList)) {
                basicEList.add((Object)tRCPackage);
            }
            ++n;
        }
        return basicEList;
    }

    protected CoverageFolder compute(EList eList, EObject eObject) {
        CoverageFolder coverageFolder = new CoverageFolder(this, null);
        coverageFolder.addTraceObjects(eObject);
        coverageFolder.parse(eList);
        coverageFolder.compute();
        return coverageFolder;
    }

    public Coverage getClassLevel() {
        CoverageFolder coverageFolder = this.duplicate(this.root);
        ArrayList arrayList = new ArrayList();
        arrayList.clear();
        ArrayList arrayList2 = this.root.getChilds();
        int n = 0;
        while (n < arrayList2.size()) {
            Coverage coverage = (Coverage)arrayList2.get(n);
            ArrayList arrayList3 = coverage.getChilds();
            int n2 = 0;
            while (n2 < arrayList3.size()) {
                arrayList.add(arrayList3.get(n2));
                ++n2;
            }
            ++n;
        }
        coverageFolder.setChilds(arrayList);
        return coverageFolder;
    }

    public Coverage getMethodLevel() {
        int n;
        Coverage coverage;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        CoverageFolder coverageFolder = this.duplicate(this.root);
        ArrayList arrayList5 = this.root.getChilds();
        int n2 = 0;
        while (n2 < arrayList5.size()) {
            coverage = (Coverage)arrayList5.get(n2);
            arrayList = coverage.getChilds();
            n = 0;
            while (n < arrayList.size()) {
                arrayList2.add(arrayList.get(n));
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList2.size()) {
            coverage = (Coverage)arrayList2.get(n2);
            arrayList = coverage.getChilds();
            n = 0;
            while (n < arrayList.size()) {
                arrayList3.add(arrayList.get(n));
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList3.size()) {
            coverage = (Coverage)arrayList3.get(n2);
            if (coverage.getTraceObj() instanceof TRCClass) {
                arrayList = coverage.getChilds();
                n = 0;
                while (n < arrayList.size()) {
                    arrayList4.add(arrayList.get(n));
                    ++n;
                }
            } else {
                arrayList4.add(coverage);
            }
            ++n2;
        }
        coverageFolder.setChilds(arrayList4);
        return coverageFolder;
    }

    protected CoverageFolder duplicate(CoverageFolder coverageFolder) {
        CoverageFolder coverageFolder2 = new CoverageFolder(this, null, coverageFolder);
        return coverageFolder2;
    }

    protected ArrayList filters() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = UIPlugin.getDefault().getPreferenceStore().getString("set_filters");
        if (string != null) {
            ArrayList arrayList2;
            ArrayList arrayList3 = TraceProfileFiltersUI.getFiltersSet((String)string);
            FilterSetElement filterSetElement = null;
            boolean bl = false;
            int n = 0;
            while (n < arrayList3.size()) {
                filterSetElement = (FilterSetElement)arrayList3.get(n);
                if (filterSetElement.getEnabled()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (filterSetElement != null && bl && (arrayList2 = filterSetElement.getChildren()).size() != 0) {
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    FilterTableElement filterTableElement = (FilterTableElement)arrayList2.get(n2);
                    if (filterTableElement.getVisibility().equals(UIPlugin.getResourceString((String)"STR_EXCLUDE"))) {
                        String string2 = filterTableElement.getText();
                        if (string2.indexOf("*") != -1) {
                            string2 = string2.substring(0, string2.indexOf("*"));
                        }
                        arrayList.add(string2);
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    protected boolean isFiltered(TRCPackage tRCPackage, ArrayList arrayList) {
        if (tRCPackage.getClasses() == null || tRCPackage.getClasses().size() == 0) {
            return true;
        }
        if (arrayList.size() != 0) {
            String string = tRCPackage.getName();
            int n = 0;
            while (n < arrayList.size()) {
                if (string.startsWith((String)arrayList.get(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    protected boolean isFiltered(TRCClass tRCClass) {
        return tRCClass.getMethods() == null || tRCClass.getMethods().size() == 0;
    }

    public CoverageFolder getRoot() {
        return this.root;
    }
}

