/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.runner;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.StringTokenizer;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;
import org.eclipse.hyades.test.common.agent.ComptestAgent;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.MessageEvent;
import org.eclipse.hyades.test.common.junit.DefaultTestArbiter;
import org.eclipse.hyades.test.common.junit.HyadesTestRunner;
import org.eclipse.hyades.test.common.junit.HyadesTestSuite;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.common.junit.IHyadesTestArbiter;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.java.runner.JUnitResourceBundle;

public class HyadesJUnitRunner
extends HyadesTestRunner {
    private boolean isOKToStart = false;
    protected ComptestAgent comptestAgent;
    public static final String LOADTESTSUITEPREFIX = "_@USERGROUP_";
    private AgentConsoleStream stdout = null;
    private AgentConsoleStream stderr = null;
    protected RemoteComponentSkeleton agent;
    public HashMap agentCollection = new HashMap();
    static /* synthetic */ Class class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner;

    public static void main(String[] stringArray) {
        HyadesJUnitRunner hyadesJUnitRunner = new HyadesJUnitRunner(stringArray);
        try {
            Class<?> clazz = Class.forName(stringArray[0], true, (class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner == null ? (class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner = HyadesJUnitRunner.class$("org.eclipse.hyades.test.java.runner.HyadesJUnitRunner")) : class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner).getClassLoader());
            Method method = clazz.getMethod("suite", null);
            Test test = (Test)method.invoke(null, null);
            HyadesTestSuite hyadesTestSuite = (HyadesTestSuite)test;
            String string = HyadesTestUtil.appendToHierarchyId((String)HyadesTestUtil.getHierarchyIds((Test)hyadesTestSuite), null, (int)1);
            hyadesJUnitRunner.stdout = new AgentConsoleStream(hyadesJUnitRunner.agent, 0, string);
            hyadesJUnitRunner.stderr = new AgentConsoleStream(hyadesJUnitRunner.agent, 1, string);
            System.setOut(new PrintStream(hyadesJUnitRunner.stdout));
            System.setErr(new PrintStream(hyadesJUnitRunner.stderr));
            int n = 1;
            String string2 = System.getProperty("hyades.loadtest.nusers");
            if (string2 != null) {
                try {
                    n = Integer.valueOf(string2);
                }
                catch (Exception exception) {
                    n = 1;
                }
            }
            if (n <= 1) {
                hyadesJUnitRunner.run(test);
            } else {
                hyadesJUnitRunner.agent.sendMessageToAttachedClient("Running a " + n + " instance test", 0L);
                HyadesTestSuite hyadesTestSuite2 = HyadesJUnitRunner.createLoadTestSuite(hyadesTestSuite, n);
                hyadesJUnitRunner.run((Test)hyadesTestSuite2);
            }
            hyadesJUnitRunner.agent.sendMessageToAttachedClient("Testcase completed successfuly", 0L);
        }
        catch (Throwable throwable) {
            MessageEvent messageEvent = new MessageEvent();
            messageEvent.setText(BaseString.getStackTrace((Throwable)throwable));
            messageEvent.setSeverity(1);
            messageEvent.setOwnerId(stringArray[1]);
            messageEvent.setId("ROOT");
            hyadesJUnitRunner.agent.logMessageUTF8(messageEvent.toString());
        }
    }

    protected void handleCustomCommand(CustomCommand customCommand) {
    }

    protected void flushConsoles() {
        if (this.stdout != null) {
            this.stdout.flush();
        }
        if (this.stderr != null) {
            this.stderr.flush();
        }
    }

    public HyadesJUnitRunner(RemoteComponentSkeleton remoteComponentSkeleton) {
        this.comptestAgent = new ComptestAgent(remoteComponentSkeleton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyadesJUnitRunner(String[] stringArray) {
        this.agent = new RemoteComponentSkeleton("Executor$" + stringArray[stringArray.length - 1], "tester");
        this.comptestAgent = new ComptestAgent(this.agent);
        this.agent.addCommandListener((CustomCommandHandler)new Commandhandler());
        try {
            this.agent.initialize();
        }
        catch (Throwable throwable) {}
        while (!this.isOKToStart()) {
            HyadesJUnitRunner hyadesJUnitRunner = this;
            synchronized (hyadesJUnitRunner) {
                try {
                    ((Object)((Object)this)).wait(180000L);
                    if (!this.isOKToStart()) {
                        this.agent.sendMessageToAttachedClient("Test was not started after 3 minutes.  Exiting testcase.", 0L);
                        System.exit(-1);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized boolean isOKToStart() {
        return this.isOKToStart;
    }

    protected synchronized void setOKToStart(boolean bl) {
        this.isOKToStart = bl;
        ((Object)((Object)this)).notifyAll();
    }

    protected void runnerStarted() {
        this.comptestAgent.write("<EXECUTION>");
        super.runnerStarted();
    }

    protected void runnerExit(boolean bl, long l) {
        super.runnerExit(bl, l);
        this.comptestAgent.write("</EXECUTION>");
    }

    public void writeEvent(ExecutionEvent executionEvent) {
        this.flushConsoles();
        if (this.comptestAgent != null && executionEvent != null) {
            this.comptestAgent.write(executionEvent.toString());
        }
    }

    protected String getLastEventText(boolean bl, long l) {
        String[] stringArray = new String[]{new Integer(this.getSucceedTests().size() + this.getFailureTests().size() + this.getErrorTests().size()).toString(), new Integer(this.getFailureTests().size()).toString(), new Integer(this.getErrorTests().size()).toString(), new Long(l).toString()};
        if (bl) {
            return JUnitResourceBundle.getInstance().getString("execution.TestStoped", stringArray);
        }
        return JUnitResourceBundle.getInstance().getString("execution.TestsFinished", stringArray);
    }

    protected static HyadesTestSuite createLoadTestSuite(HyadesTestSuite hyadesTestSuite, int n) {
        String string = hyadesTestSuite.getId();
        HyadesTestSuite hyadesTestSuite2 = new HyadesTestSuite("root");
        hyadesTestSuite2.setArbiter((IHyadesTestArbiter)DefaultTestArbiter.INSTANCE).setId(string + "HTTP_ROOTID");
        HyadesTestSuite hyadesTestSuite3 = new HyadesTestSuite(LOADTESTSUITEPREFIX + n);
        hyadesTestSuite2.addTest((Test)new RepeatedTest((Test)hyadesTestSuite3, n));
        hyadesTestSuite3.setId(string + "_HTTP_USERGROUP").setSynchronous(false);
        hyadesTestSuite3.addTest((Test)hyadesTestSuite);
        return hyadesTestSuite2;
    }

    public RemoteComponentSkeleton getAgent(Object object) {
        if (object == null) {
            return this.agent;
        }
        return (RemoteComponentSkeleton)this.agentCollection.get(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AgentConsoleStream
    extends OutputStream {
        public static final int OUT = 0;
        public static final int ERR = 1;
        private int mode;
        private RemoteComponentSkeleton agent;
        private String hierarchyId;
        private StringBuffer buffer = new StringBuffer();

        public AgentConsoleStream(RemoteComponentSkeleton remoteComponentSkeleton, int n, String string) {
            this.mode = n;
            this.agent = remoteComponentSkeleton;
            this.hierarchyId = string;
        }

        public void write(int n) {
            this.buffer.append((char)n);
            if (n == 10) {
                this.flush();
            }
        }

        public void flush() {
            if (this.buffer.length() > 0) {
                MessageEvent messageEvent = new MessageEvent();
                messageEvent.setText(this.buffer.toString());
                messageEvent.setSeverity(0);
                String string = HyadesTestRunner.peekParentEventID();
                messageEvent.setParentId(string);
                if (this.mode == 0) {
                    messageEvent.setText("System.out:\n" + this.buffer.toString());
                } else if (this.mode == 1) {
                    messageEvent.setText("System.err:\n" + this.buffer.toString());
                }
                this.agent.logMessageUTF8(messageEvent.toString());
                this.buffer = new StringBuffer();
            }
        }
    }

    public class Commandhandler
    implements CustomCommandHandler {
        public void handleCommand(CustomCommand customCommand) {
            String string = customCommand.getData();
            if (string.equals("START")) {
                HyadesJUnitRunner.this.setOKToStart(true);
            } else if (string.startsWith("AgentIDs:")) {
                String string2 = new String(customCommand.getDataBinary());
                string2 = string2.substring(string2.indexOf(58) + 1, string2.length());
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    RemoteComponentSkeleton remoteComponentSkeleton = new RemoteComponentSkeleton("Executor$" + string3, "tester");
                    remoteComponentSkeleton.addCommandListener(new CustomCommandHandler(this){
                        private final /* synthetic */ Commandhandler this$1;
                        {
                            this.this$1 = commandhandler;
                        }

                        public void handleCommand(CustomCommand customCommand) {
                            String string = customCommand.getData();
                        }
                    });
                    try {
                        remoteComponentSkeleton.initialize();
                        HyadesJUnitRunner.this.agentCollection.put(string3, remoteComponentSkeleton);
                    }
                    catch (AgentControllerUnavailableException agentControllerUnavailableException) {
                        agentControllerUnavailableException.printStackTrace();
                    }
                }
            } else {
                HyadesJUnitRunner.this.handleCustomCommand(customCommand);
            }
        }
    }
}

