/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LargeResourceSupportUI
implements SelectionListener {
    protected Text username;
    protected Text password;
    protected Text cacheSize;
    protected Composite container;
    protected Combo storeType;

    public Control createControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayoutData((Object)GridDataUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        this.container.setLayout((Layout)gridLayout);
        Label label = new Label(this.container, 0);
        label.setText(LogUIPlugin.getResourceString("LRSP_STORE_TYPE"));
        this.storeType = new Combo(this.container, 2056);
        this.storeType.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.initPossibleDBType();
        Label label2 = new Label(this.container, 0);
        label2.setText(LogUIPlugin.getResourceString("LRSP_DB_USERNAME"));
        this.username = new Text(this.container, 2048);
        this.username.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Label label3 = new Label(this.container, 0);
        label3.setText(LogUIPlugin.getResourceString("LRSP_DB_PASSWORD"));
        this.password = new Text(this.container, 2048);
        this.password.setEchoChar('*');
        this.password.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Label label4 = new Label(this.container, 0);
        label4.setText(LogUIPlugin.getResourceString("LRSP_CACHE_SIZE"));
        this.cacheSize = new Text(this.container, 2048);
        this.cacheSize.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Button button = new Button(this.container, 0);
        button.setText(LogUIPlugin.getResourceString("LRSP_CREATE_TABLES"));
        button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                IHyadesResourceFactory iHyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get((Object)("__" + LargeResourceSupportUI.this.storeType.getText() + ".trcadb"));
                if (iHyadesResourceFactory != null) {
                    iHyadesResourceFactory.createTables(LargeResourceSupportUI.this.storeType.getText(), HyadesResourceExtensions.getInstance().getProperties());
                }
            }
        });
        Button button2 = new Button(this.container, 0);
        button2.setText(LogUIPlugin.getResourceString("LRSP_DROP_TABLES"));
        button2.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                IHyadesResourceFactory iHyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get((Object)("__" + LargeResourceSupportUI.this.storeType.getText() + ".trcadb"));
                if (iHyadesResourceFactory != null) {
                    iHyadesResourceFactory.dropTables(LargeResourceSupportUI.this.storeType.getText(), HyadesResourceExtensions.getInstance().getProperties());
                }
            }
        });
        this.initializeValues(false);
        return this.container;
    }

    private void initPossibleDBType() {
        String string = LogUIPlugin.getDefault().getPreferenceStore().getString("largeResourceSupportDBType");
        int n = -1;
        int n2 = 0;
        Iterator iterator = HyadesResourceExtensions.getInstance().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = (String)entry.getKey();
            IHyadesResourceFactory iHyadesResourceFactory = (IHyadesResourceFactory)entry.getValue();
            if (iHyadesResourceFactory == null || !iHyadesResourceFactory.isEnabledFor(string2)) continue;
            this.storeType.add(iHyadesResourceFactory.getStoreType(string2));
            if (iHyadesResourceFactory.getStoreType(string2).equals(string)) {
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            this.storeType.select(n);
        }
    }

    public void initializeValues(boolean bl) {
        String string;
        Preferences preferences = HierarchyPlugin.getPlugin().getPluginPreferences();
        String string2 = string = bl ? preferences.getDefaultString("largeResourceSupportUsername") : preferences.getString("largeResourceSupportUsername");
        if (string != null) {
            this.username.setText(string);
        }
        String string3 = string = bl ? preferences.getDefaultString("largeResourceSupportPassword") : preferences.getString("largeResourceSupportPassword");
        if (string != null) {
            this.password.setText(string);
        }
        String string4 = string = bl ? preferences.getDefaultString("largeResourceSupportDBType") : preferences.getString("largeResourceSupportDBType");
        if (string != null) {
            this.storeType.setText(string);
        }
    }

    public boolean storeValues() {
        Preferences preferences = HierarchyPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("largeResourceSupportDBType", this.storeType.getText());
        preferences.setValue("largeResourceSupportUsername", this.username.getText());
        preferences.setValue("largeResourceSupportPassword", this.password.getText());
        preferences.setValue("largeResourceSupportCacheSize", this.cacheSize.getText());
        return true;
    }

    public Composite getControl() {
        return this.container;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }
}

