/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class LogAnalyzerUI
implements SelectionListener {
    private Button _moveUp;
    protected Button _moveDown;
    private Button _selAll;
    private Button _unselAll;
    private Label _description;
    private Label _label;
    private HashMap _map;
    protected ArrayList _pdData = new ArrayList();
    protected Table _pdList;
    private ArrayList listeners = new ArrayList(2);

    public Control createControl(Composite composite) {
        Composite composite2 = this.createContainer(composite);
        this._description = new Label(composite2, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._description.setLayoutData((Object)gridData);
        this._map = new HashMap();
        this._pdList = this.createTable(composite2);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalIndent = 20;
        gridData.verticalAlignment = 4;
        composite3.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 25;
        composite3.setLayout((Layout)gridLayout);
        this._moveUp = this.createButton(composite3, LogUIPlugin.getResourceString("STR_COL_DLG_UP"));
        this._moveDown = this.createButton(composite3, LogUIPlugin.getResourceString("STR_COL_DLG_DOWN"));
        this._selAll = this.createButton(composite3, LogUIPlugin.getResourceString("STR_COL_DLG_SEL_ALL"));
        this._unselAll = this.createButton(composite3, LogUIPlugin.getResourceString("STR_COL_DLG_USEL_ALL"));
        this._pdList.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._selAll.addSelectionListener((SelectionListener)this);
        this._unselAll.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        return composite2;
    }

    private Composite createContainer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 15;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 350;
        gridData.widthHint = 350;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    private Table createTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridUtil.createFill());
        composite2.setLayout((Layout)new GridLayout());
        Table table = new Table(composite2, 2336);
        GridData gridData = GridUtil.createFill();
        table.setLayoutData((Object)gridData);
        return table;
    }

    private Button createButton(Composite composite, String string) {
        Button button = new Button(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        button.setText(string);
        return button;
    }

    protected void setDescription(String string) {
        this._description.setText(string);
    }

    protected void setLabel(String string) {
        this._label.setText(string);
    }

    protected void moveDown(int n, Table table) {
        TableItem tableItem = table.getItem(n);
        ColumnData columnData = (ColumnData)tableItem.getData();
        TableItem tableItem2 = new TableItem(table, 32, n + 2);
        tableItem2.setChecked(tableItem.getChecked());
        tableItem2.setText(tableItem.getText());
        tableItem2.setData((Object)columnData);
        tableItem2.setGrayed(tableItem.getGrayed());
        table.remove(n);
        table.select(n + 1);
    }

    protected void moveUp(int n, Table table) {
        TableItem tableItem;
        TableItem tableItem2 = table.getItem(n);
        ColumnData columnData = (ColumnData)tableItem2.getData();
        if (n > 0) {
            tableItem = table.getItem(n - 1);
            ColumnData columnData2 = (ColumnData)tableItem.getData();
        }
        tableItem = new TableItem(table, 32, n - 1);
        tableItem.setChecked(tableItem2.getChecked());
        tableItem.setText(tableItem2.getText());
        tableItem.setData((Object)columnData);
        tableItem.setGrayed(tableItem2.getGrayed());
        table.remove(n + 1);
        table.select(n - 1);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        this.notifyListeners(selectionEvent);
        if (selectionEvent.widget == this._moveUp) {
            n = this._pdList.getSelectionIndex();
            if (n > 0) {
                this.moveUp(n, this._pdList);
            }
        } else if (selectionEvent.widget == this._moveDown) {
            n = this._pdList.getSelectionIndex();
            if (n != -1 && n < this._pdList.getItemCount() - 1) {
                this.moveDown(n, this._pdList);
            }
        } else {
            if (selectionEvent.widget == this._selAll) {
                int n2 = 0;
                while (n2 < this._pdList.getItemCount()) {
                    TableItem tableItem = this._pdList.getItem(n2);
                    tableItem.setChecked(true);
                    ++n2;
                }
                return;
            }
            if (selectionEvent.widget == this._unselAll) {
                int n3 = 0;
                while (n3 < this._pdList.getItemCount()) {
                    TableItem tableItem = this._pdList.getItem(n3);
                    tableItem.setChecked(false);
                    ++n3;
                }
                return;
            }
        }
        n = this._pdList.getSelectionIndex();
        ColumnData columnData = null;
        ColumnData columnData2 = null;
        if (n > 0) {
            columnData2 = (ColumnData)this._pdList.getItem(n - 1).getData();
        }
        if (n != -1) {
            columnData = (ColumnData)this._pdList.getItem(n).getData();
        }
        this._moveUp.setEnabled(columnData != null && columnData2 != null);
        this._moveDown.setEnabled(columnData != null && n < this._pdList.getItemCount() - 1);
    }

    public void addListener(SelectionListener selectionListener) {
        if (!this.listeners.contains(selectionListener)) {
            this.listeners.add(selectionListener);
        }
    }

    public void removeListener(SelectionListener selectionListener) {
        this.listeners.remove(selectionListener);
    }

    public void notifyListeners(SelectionEvent selectionEvent) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((SelectionListener)this.listeners.get(n)).widgetSelected(selectionEvent);
            ++n;
        }
    }

    protected void createColumnDataFromString(String string, ArrayList arrayList) {
        arrayList.clear();
        ArrayList arrayList2 = ColumnData.createColumnDataFromString(string);
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
    }

    protected void loadColumnData(String string, ArrayList arrayList, Table table, IPreferenceStore iPreferenceStore) {
        arrayList.clear();
        int n = 0;
        while (n < table.getItemCount()) {
            TableItem tableItem = table.getItem(n);
            arrayList.add(new ColumnData(tableItem.getText(), tableItem.getChecked()));
            ++n;
        }
        ColumnData.setColumns(arrayList, string, iPreferenceStore);
    }

    protected abstract void populateList();

    public abstract boolean storeValues(IPreferenceStore var1);

    public abstract void initializeValues(boolean var1);
}

