/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileDetailsUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogParserUI
implements SelectionListener {
    private Table _list;
    private Label _description;
    private ArrayList _images;
    private ArrayList _parserTable = new ArrayList();
    private LogParserItem _parser;
    private int _max = 1;
    private LogFileDetailsUI _detailsUI;

    public LogParserUI(LogFileDetailsUI logFileDetailsUI) {
        this._detailsUI = logFileDetailsUI;
        this._images = new ArrayList();
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridUtil.createFill());
        composite2.setLayout((Layout)new GridLayout());
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)GridUtil.createHorizontalFill());
        label.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));
        this._list = new Table(composite2, 68356);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 400;
        gridData.heightHint = 70;
        this._list.setLayoutData((Object)gridData);
        this._description = new Label(composite2, 64);
        gridData = GridUtil.createHorizontalFill();
        gridData.heightHint = 30;
        gridData.widthHint = 400;
        this._description.setLayoutData((Object)gridData);
        this._list.addSelectionListener((SelectionListener)this);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)this._list, (String)(LogUIPlugin.getPluginId() + ".parserlist"));
        return composite2;
    }

    private void initializeValues() {
        Collection collection = this._detailsUI.getParserRegistry().values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this._parserTable.add(iterator.next());
        }
        this.initializeUI();
    }

    private void initializeUI() {
        LogParserItem logParserItem;
        Collections.sort(this._parserTable, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((LogParserItem)object).getDescription().compareToIgnoreCase(((LogParserItem)object2).getDescription());
            }
        });
        int n = 0;
        while (n < this._parserTable.size()) {
            logParserItem = (LogParserItem)this._parserTable.get(n);
            TableItem tableItem = new TableItem(this._list, 0);
            tableItem.setText(logParserItem.getUIName());
            tableItem.setData((Object)logParserItem);
            if (logParserItem.getImageDescriptor() != null) {
                Image image = logParserItem.getImageDescriptor().createImage();
                tableItem.setImage(image);
                this._images.add(image);
            }
            ++n;
        }
        if (this._parserTable.size() > 0) {
            logParserItem = this._detailsUI.getLogFileElement().getParser();
            if (logParserItem == null) {
                this._parser = (LogParserItem)this._parserTable.get(0);
                this._list.setSelection(0);
            } else {
                this._parser = logParserItem;
                this._list.setSelection(this._detailsUI.indexOf(this._parser));
            }
            this._detailsUI.setSelectedParser(this._parser);
            this._description.setText(this._parser.getDescription());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        TableItem[] tableItemArray;
        if (selectionEvent.widget == this._list && (tableItemArray = this._list.getSelection()).length > 0) {
            this._parser = (LogParserItem)tableItemArray[0].getData();
            this._detailsUI.setSelectedParser(this._parser);
            this._description.setText(this._parser.getDescription());
        }
    }

    public LogParserItem getParser() {
        return this._parser;
    }

    public int getMaximumFields() {
        return this._max;
    }

    public int getParserCount() {
        return this._list.getItemCount();
    }

    public int indexOf(LogParserItem logParserItem) {
        TableItem[] tableItemArray = this._list.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            if (((LogParserItem)tableItemArray[n].getData()).getDescription().equals(logParserItem.getDescription())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void dispose() {
        int n = 0;
        while (n < this._images.size()) {
            Image image = (Image)this._images.get(n);
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            ++n;
        }
        this._images.clear();
    }

    public boolean finish() {
        TableItem[] tableItemArray = this._list.getSelection();
        return tableItemArray.length != 0;
    }
}

