/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.wizard.RunWizard;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RunJavaWizard
extends RunWizard
implements IRunnableWithProgress {
    private String error;
    private String executionResultLocation;
    private String executionResultName;
    private static HashMap controlInterfacesMap = new HashMap();
    boolean runWizard;

    public boolean doPerformFinish() {
        block7: {
            this.error = null;
            this.runWizard = true;
            this.executionResultLocation = this.getContainerPath().toString();
            this.executionResultName = this.getExecutionResultName();
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)this);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.runWizard = false;
                MessageDialog.openError((Shell)this.getShell(), (String)TestJavaPlugin.getString("W_ERROR"), (String)invocationTargetException.getTargetException().getMessage());
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.runWizard = false;
                return false;
            }
            this.runWizard = false;
            if (this.error != null && !this.error.equals("")) {
                String string = TestJavaPlugin.getString("CONNECTION_FAIL_TEXT");
                CFGArtifactLocationPair cFGArtifactLocationPair = (CFGArtifactLocationPair)this.getDeployment().getArtifactLocations().get(0);
                if (cFGArtifactLocationPair != null) {
                    string = StringUtil.replace((String)string, (String)"%1", (String)cFGArtifactLocationPair.getLocation().getName());
                }
                Status status = new Status(2, "org.eclipse.core.resources", 566, this.error, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)TestJavaPlugin.getString("TEST_ERR_MSG"), (String)string, (IStatus)status);
                return false;
            }
            IWorkbenchPage iWorkbenchPage = TestJavaPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iWorkbenchPage == null) break block7;
            try {
                iWorkbenchPage.showView("org.eclipse.hyades.test.ui.ExecutionNavigator");
            }
            catch (Exception exception) {
                TestUIPlugin.logError((Throwable)exception);
            }
        }
        return true;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        this.runWizard = true;
        new RefreshUI(iProgressMonitor).start();
        ITestSuite iTestSuite = null;
        if (this.getTest() instanceof ITestSuite) {
            iTestSuite = (ITestSuite)this.getTest();
        } else if (this.getTest() instanceof ITestCase) {
            iTestSuite = ((ITestCase)this.getTest()).getOwner();
        }
        Object var3_3 = null;
        String string = TestUIPlugin.getInstance().getPreferenceStore().getString("localhost_port");
        StringBuffer stringBuffer = new StringBuffer();
        IExecutor iExecutor = new TestExecutionHarness().launchTest(iTestSuite, (ITest)this.getTest(), this.getDeployment(), string, this.executionResultLocation, this.executionResultName, true, false, stringBuffer);
        this.error = stringBuffer.toString();
        if (iExecutor != null) {
            this.setControlInterface(this.executionResultLocation, this.executionResultName, iExecutor);
        }
        iProgressMonitor.done();
    }

    protected void setControlInterface(String string, String string2, IExecutor iExecutor) {
        String string3 = string + "/" + string2;
        controlInterfacesMap.put(string3, iExecutor);
    }

    protected IExecutor getControlInterface(String string, String string2) {
        String string3 = string + "/" + string2;
        return (IExecutor)controlInterfacesMap.get(string3);
    }

    class RefreshUI
    extends Thread {
        IProgressMonitor monitor;

        public RefreshUI(IProgressMonitor iProgressMonitor) {
            super("run_test");
            this.monitor = iProgressMonitor;
        }

        public void run() {
            while (RunJavaWizard.this.runWizard) {
                try {
                    Display display = Display.getDefault();
                    display.asyncExec(new Runnable(this){
                        private final /* synthetic */ RefreshUI this$1;
                        {
                            this.this$1 = refreshUI;
                        }

                        public void run() {
                            if (this.this$1.monitor.isCanceled() && this.this$1.monitor.isCanceled()) {
                                RefreshUI.access$000((RefreshUI)this.this$1).runWizard = false;
                                throw new OperationCanceledException();
                            }
                        }
                    });
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ RunJavaWizard access$000(RefreshUI refreshUI) {
            return refreshUI.RunJavaWizard.this;
        }
    }
}

