/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonGenericLoader;
import org.eclipse.hyades.perfmon.PerfmonLoader;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.PerfmonStatConModule;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.statistical.ui.editor.internal.AgentChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableLoader;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PerfmonModuleTrace
implements AgentChangeListener,
SDVariableModifierProxy {
    private static final boolean USE_CUSTOM_LOADER = false;
    ImageManager img = PerfmonPlugin.img;
    StatConInterface statcon;
    String PERFMON_NODE = "Perfmon Trace";
    String ACTION_STOP_TRACE = "Stop Trace";
    String ACTION_UPDATE_TREE = "Update Counter Tree";
    String ACTION_START_TRACING = "Start Tracing this Counter";
    String ACTION_STOP_TRACING = "Stop Tracing this Counter";
    String ACTION_SETSMODELPATH = "Set Statistical Model save path...";
    String tracename;
    SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
    TRCMonitor monitor;
    TRCAgent agent;
    PerfmonLoader loader;
    VariablePadder var_padder;
    SDModifiableVariableRepresentation freq_var;
    double frequency = 1.0;
    URI smodelpath;

    public void unloadTrace() {
        this.var_padder.die = true;
        try {
            this.loader.shutdown();
        }
        catch (Exception exception) {
            PerfmonPlugin.DBG.warning("failed to shut down Perfmon loader");
        }
        try {
            this.statcon.setConstantUpdate("PERFMON UPDATE " + this.loader.hashCode(), false, 1000L);
            this.statcon.setAgentImage(this.agent, this.img.getImage("trace_stop.gif"));
            this.statcon.removeAgentAction(this.agent, this.ACTION_SETSMODELPATH);
            this.statcon.removeAgentAction(this.agent, this.ACTION_STOP_TRACE);
            this.statcon.removeAgentAction(this.agent, this.ACTION_UPDATE_TREE);
        }
        catch (Exception exception) {
            PerfmonPlugin.DBG.warning("failed to remove stuff from statcon");
        }
        this.statcon.removeAgentChangeListener((AgentChangeListener)this);
    }

    public void agentAdded(TRCAgent tRCAgent) {
    }

    public void agentRemoved(TRCAgent tRCAgent) {
        if (this.agent == tRCAgent) {
            this.unloadTrace();
        }
    }

    public void requestValue(String string, int n) throws ClassCastException {
        this.requestValue(string, (double)n);
    }

    public void requestValue(String string, long l) throws ClassCastException {
        this.requestValue(string, (double)l);
    }

    public void requestValue(String string, float f) throws ClassCastException {
        this.requestValue(string, (double)f);
    }

    public void requestValue(String string, double d) throws ClassCastException {
        block3: {
            if (!string.equals("PERFMON#FREQUENCY")) break block3;
            if (d < 0.5) {
                d = 0.5;
            }
            int n = (int)(d * 1000.0);
            try {
                this.loader.setFrequency(n);
                this.frequency = d;
                this.freq_var.setMeasuredValue(System.currentTimeMillis(), d);
            }
            catch (IOException iOException) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)iOException, "Error setting perfmon agent frequency to " + n, false);
            }
        }
    }

    public void requestValue(String string, Object object) throws ClassCastException {
        this.requestValue(string, ((Number)object).doubleValue());
    }

    public PerfmonModuleTrace(StatConInterface statConInterface, String string, String string2, URI uRI) {
        this.statcon = statConInterface;
        this.smodelpath = uRI;
        this.init(string, string2);
    }

    private String getStatModelFileName() {
        return this.tracename;
    }

    private void removeRepresentations(SDDescriptor sDDescriptor) {
        SDMemberDescriptor sDMemberDescriptor;
        if (sDDescriptor == null) {
            return;
        }
        if (sDDescriptor instanceof SDMemberDescriptor) {
            sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor;
            sDMemberDescriptor.setRepresentation(null);
            EList eList = sDMemberDescriptor.getSnapshotObservation();
            int n = 0;
            while (n < eList.size()) {
                SDSnapshotObservation sDSnapshotObservation = (SDSnapshotObservation)eList.get(n);
                if (sDSnapshotObservation.getWindow() == null) {
                    System.out.println("NULL OBSERVATION WINDOW UNDER " + sDDescriptor.getName() + " (" + sDDescriptor.getDescription() + ")");
                }
                ++n;
            }
        }
        sDMemberDescriptor = sDDescriptor.getChildren();
        int n = 0;
        while (n < sDMemberDescriptor.size()) {
            this.removeRepresentations((SDDescriptor)sDMemberDescriptor.get(n));
            ++n;
        }
    }

    private void saveStatisticalModel() throws IOException {
        EList eList = this.agent.getDescriptor();
        int n = 0;
        while (n < eList.size()) {
            this.removeRepresentations((SDDescriptor)eList.get(n));
            ++n;
        }
        URI uRI = this.smodelpath;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcmxmi");
        URI uRI2 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcnxmi");
        URI uRI3 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcpxmi");
        URI uRI4 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcaxmi");
        URI uRI5 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        HierarchyResourceSetImpl hierarchyResourceSetImpl = HierarchyResourceSetImpl.getInstance();
        Resource resource = hierarchyResourceSetImpl.createResource(uRI2);
        Resource resource2 = hierarchyResourceSetImpl.createResource(uRI3);
        Resource resource3 = hierarchyResourceSetImpl.createResource(uRI4);
        Resource resource4 = hierarchyResourceSetImpl.createResource(uRI5);
        resource.getContents().add((Object)this.monitor);
        resource2.getContents().add((Object)this.agent.getAgentProxy().getProcessProxy().getNode());
        resource3.getContents().add((Object)this.agent.getAgentProxy().getProcessProxy());
        resource4.getContents().add((Object)this.agent);
        resource.save(Collections.EMPTY_MAP);
        resource2.save(Collections.EMPTY_MAP);
        resource3.save(Collections.EMPTY_MAP);
        resource4.save(Collections.EMPTY_MAP);
        this.statcon.setAgentFile(this.agent, uRI5);
    }

    private void configureSliders() throws Exception {
        double d;
        TimeZoomSlider timeZoomSlider = this.statcon.getGraphWindow().getXSlider(0);
        double d2 = timeZoomSlider.getMinVisible();
        double d3 = timeZoomSlider.getMaxVisible();
        double d4 = timeZoomSlider.getMinLimit();
        double d5 = timeZoomSlider.getMaxLimit();
        d2 = d = (double)System.currentTimeMillis();
        d3 = d + 60000.0;
        d4 = Math.min(d4, d - 3600000.0);
        d5 = Math.max(d5, d + 8.64E7);
        timeZoomSlider.configure(d4, d5, d2, d3, timeZoomSlider.getResolution());
        ZoomSlider zoomSlider = this.statcon.getGraphWindow().getYSlider(0);
        d2 = zoomSlider.getMinVisible();
        d3 = Math.max(zoomSlider.getMaxVisible(), 100.0);
        d4 = zoomSlider.getMinLimit();
        d5 = Math.max(zoomSlider.getMaxLimit(), d3 * 10.0);
        zoomSlider.configure(d4, d5, d2, d3, zoomSlider.getResolution());
    }

    private void createTRCAgent(String string) {
        HierarchyFactory hierarchyFactory = HierarchyFactory.eINSTANCE;
        TRCMonitor tRCMonitor = hierarchyFactory.createTRCMonitor();
        tRCMonitor.setName(string);
        TRCNode tRCNode = hierarchyFactory.createTRCNode();
        tRCNode.setMonitor(tRCMonitor);
        tRCNode.setName(string);
        tRCNode.setRuntimeId("unknown");
        tRCNode.setTimezone(0.0);
        TRCProcessProxy tRCProcessProxy = hierarchyFactory.createTRCProcessProxy();
        tRCProcessProxy.setNode(tRCNode);
        tRCNode.getProcessProxies().add((Object)tRCProcessProxy);
        tRCProcessProxy.setActive(true);
        tRCProcessProxy.setPid(-1);
        tRCProcessProxy.setName("Scapa Engine");
        TRCAgentProxy tRCAgentProxy = hierarchyFactory.createTRCAgentProxy();
        tRCAgentProxy.setProcessProxy(tRCProcessProxy);
        tRCProcessProxy.getAgentProxies().add((Object)tRCAgentProxy);
        tRCAgentProxy.setActive(true);
        TRCAgent tRCAgent = hierarchyFactory.createTRCAgent();
        tRCAgent.setAgentProxy(tRCAgentProxy);
        tRCAgent.setName(string);
        HierarchyResourceSetImpl hierarchyResourceSetImpl = HierarchyResourceSetImpl.getInstance();
        URI uRI = this.statcon.getCurrentProjectURI();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(uRI + "/" + "agent-" + Math.random() + "-" + System.currentTimeMillis() + ".trcaxmi");
        URI uRI2 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        Resource resource = hierarchyResourceSetImpl.createResource(uRI2);
        resource.getContents().add((Object)tRCAgent);
        this.agent = tRCAgent;
        this.monitor = tRCMonitor;
    }

    private void redoActions() {
        this.statcon.addAgentAction(this.agent, this.ACTION_SETSMODELPATH, PerfmonPlugin.getString("ACTION_SETSMODELPATH") + " (" + PerfmonStatConModule.uriToHumanReadable(this.smodelpath) + ")", this.img.getImage("save.gif"), (Runnable)new PerfmonSetPath());
    }

    private void init(String string, String string2) {
        try {
            if (string2.equalsIgnoreCase(string)) {
                string2 = "null";
            }
            HierarchyFactory hierarchyFactory = HierarchyFactory.eINSTANCE;
            long l = System.currentTimeMillis();
            String string3 = string;
            int n = 10002;
            String string4 = string2;
            if (string4.equalsIgnoreCase("null")) {
                string4 = string3;
            } else if (!string2.startsWith("\\\\")) {
                string2 = "\\\\" + string2;
            }
            this.tracename = "Perfmon Trace - " + string4 + " (" + string3 + ") " + this.smodel_sdf.format(new Date(l));
            String string5 = "Perfmon Host Trace - " + this.smodel_sdf.format(new Date(l));
            this.createTRCAgent(this.tracename);
            PerfmonPlugin.DBG.info("Creating variable loader");
            SDVariableLoader sDVariableLoader = new SDVariableLoader(this.agent, "Perfmon Controls");
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource((Object)this.agent.getAgentProxy());
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource((Object)this.agent.getAgentProxy());
            profileEvent.setType(64);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource((Object)this.agent.getAgentProxy());
            profileEvent.setType(512);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            AgentUpdateThread agentUpdateThread = new AgentUpdateThread(this.agent);
            agentUpdateThread.start();
            this.loader = new PerfmonGenericLoader(l, this.agent, string5, string3, n, string2, (int)(1000.0 * this.frequency));
            this.loader.addLoaderListener(agentUpdateThread);
            this.statcon.setConstantUpdate("PERFMON UPDATE " + this.loader.hashCode(), true, 1000L);
            this.statcon.addAgent(this.agent);
            this.statcon.addAgentAction(this.agent, this.ACTION_STOP_TRACE, PerfmonPlugin.getString("STOP_TRACE"), this.img.getImage("trace_stop.gif"), (Runnable)new StopTraceAction(this.loader, this.agent));
            this.statcon.addAgentAction(this.agent, this.ACTION_UPDATE_TREE, PerfmonPlugin.getString("UPDATE_TREE"), this.img.getImage("update_tree.gif"), (Runnable)new UpdateTreeAction(this.loader, this.agent));
            this.statcon.addAgentAction(this.agent, this.ACTION_SETSMODELPATH, PerfmonPlugin.getString("ACTION_SETSMODELPATH") + " (" + PerfmonStatConModule.uriToHumanReadable(this.smodelpath) + ")", this.img.getImage("save.gif"), (Runnable)new PerfmonSetPath());
            this.statcon.addModelAction(this.agent, this.ACTION_START_TRACING, PerfmonPlugin.getString("START_TRACING"), this.img.getImage("trace_start.gif"), (Runnable)new CounterON(this.loader));
            this.statcon.addModelAction(this.agent, this.ACTION_STOP_TRACING, PerfmonPlugin.getString("STOP_TRACING"), this.img.getImage("trace_stop.gif"), (Runnable)new CounterOFF(this.loader));
            this.configureSliders();
            PerfmonPlugin.DBG.info("Creating frequency variable");
            this.freq_var = sDVariableLoader.createSDModifiableVariable("PERFMON#FREQUENCY", "Frequency (sec)", "The period between data updates in seconds", null, false, 3, 3, "Frequency", "Perfmon Controls", (SDVariableModifierProxy)this, 0.5, Double.MAX_VALUE);
            PerfmonPlugin.DBG.info("Setting requested frequency to " + this.frequency);
            this.freq_var.setRequestedValue(System.currentTimeMillis(), this.frequency);
            PerfmonPlugin.DBG.info("setting up trcagent + variable padder");
            this.statcon.addAgentChangeListener((AgentChangeListener)this);
            this.statcon.setAgentImage(this.agent, this.img.getImage("trace_start.gif"));
            this.var_padder = new VariablePadder();
            this.var_padder.start();
        }
        catch (Throwable throwable) {
            PerfmonPlugin.DBG.logVisibleError(throwable, PerfmonPlugin.getString("ERROR_STARTING_TRACE"), true);
        }
    }

    class AgentUpdateThread
    extends Thread
    implements StatisticalLoaderListener {
        public boolean die;
        TRCAgent agent;
        Object list_lock = new Object();
        ArrayList descriptor_updates = new ArrayList();
        HashMap descriptor_map = new HashMap();
        ArrayList agent_updates = new ArrayList();

        public AgentUpdateThread(TRCAgent tRCAgent) {
            this.agent = tRCAgent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(SDDescriptor sDDescriptor) {
            SDDescriptor sDDescriptor2 = sDDescriptor;
            Object object = this.list_lock;
            synchronized (object) {
                if (sDDescriptor2 == null) {
                    if (this.agent_updates.size() == 0) {
                        this.agent_updates.add(this.agent);
                    }
                } else {
                    if (this.descriptor_map.get(sDDescriptor2) != null) {
                        return;
                    }
                    SDDescriptor sDDescriptor3 = sDDescriptor2.getParent();
                    while (sDDescriptor3 != null) {
                        if (this.descriptor_map.get(sDDescriptor3) != null) {
                            return;
                        }
                        sDDescriptor3 = sDDescriptor3.getParent();
                    }
                    this.descriptor_updates.add(sDDescriptor2);
                    this.descriptor_map.put(sDDescriptor2, sDDescriptor2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collapse() {
            Object object = this.list_lock;
            synchronized (object) {
                if (this.agent_updates.size() > 0) {
                    return;
                }
                if (this.descriptor_updates.size() > 350) {
                    this.agent_updates.add(this.agent);
                    return;
                }
                int n = 0;
                while (n < this.descriptor_updates.size()) {
                    SDDescriptor sDDescriptor = (SDDescriptor)this.descriptor_updates.get(n);
                    SDDescriptor sDDescriptor2 = sDDescriptor.getParent();
                    while (sDDescriptor2 != null) {
                        if (this.descriptor_map.get(sDDescriptor2) != null) {
                            this.descriptor_updates.remove(n--);
                            this.descriptor_map.remove(sDDescriptor2);
                            break;
                        }
                        sDDescriptor2 = sDDescriptor2.getParent();
                    }
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = this.list_lock;
                synchronized (object) {
                    this.collapse();
                    if (this.agent_updates.size() > 0) {
                        PerfmonModuleTrace.this.statcon.getGraphWindow().getDisplay().syncExec((Runnable)new ListUpdate(this.agent_updates));
                    } else if (this.descriptor_updates.size() > 0) {
                        PerfmonModuleTrace.this.statcon.getGraphWindow().getDisplay().syncExec((Runnable)new ListUpdate(this.descriptor_updates));
                    }
                    this.descriptor_updates = new ArrayList();
                    this.descriptor_map = new HashMap();
                    this.agent_updates = new ArrayList();
                }
            }
        }
    }

    class ListUpdate
    extends Thread {
        ArrayList items;

        public ListUpdate(ArrayList arrayList) {
            this.items = arrayList;
        }

        public void run() {
            try {
                int n = 0;
                while (n < this.items.size()) {
                    Object e = this.items.get(n);
                    if (e instanceof SDDescriptor) {
                        PerfmonModuleTrace.this.statcon.updateModel((SDDescriptor)e);
                    } else if (e instanceof TRCAgent) {
                        PerfmonModuleTrace.this.statcon.updateAgent((TRCAgent)e);
                        return;
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.warning("couldnt update perfmon agent " + throwable);
            }
        }
    }

    class PerfmonSetPath
    implements Runnable {
        PerfmonSetPath() {
        }

        public void run() {
            PerfmonPlugin.DBG.info("set test model save path");
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path path = null;
            IFolder iFolder = null;
            try {
                path = new Path("" + PerfmonModuleTrace.this.smodelpath);
                iFolder = iWorkspaceRoot.getFolder((IPath)path);
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path");
            }
            PerfmonPlugin.DBG.info("showing container selection dialog");
            ContainerSelectionDialog containerSelectionDialog = null;
            containerSelectionDialog = new ContainerSelectionDialog(PerfmonModuleTrace.this.statcon.getGraphWindow().getShell(), (IContainer)iFolder, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
            containerSelectionDialog.open();
            Object[] objectArray = containerSelectionDialog.getResult();
            if (objectArray != null && objectArray.length > 0) {
                URI uRI;
                Path path2 = (Path)objectArray[0];
                PerfmonModuleTrace.this.smodelpath = uRI = URI.createPlatformResourceURI((String)path2.toString());
                PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
                PerfmonModuleTrace.this.redoActions();
                PerfmonModuleTrace.this.statcon.setDirty(true);
            }
        }
    }

    class CounterOFF
    implements Runnable {
        PerfmonLoader loader;

        public CounterOFF(PerfmonLoader perfmonLoader) {
            this.loader = perfmonLoader;
        }

        public void run() {
            try {
                this.apply(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.error("unable to set counter to ON", (Throwable)exception);
            }
        }

        void apply(SDDescriptor sDDescriptor) throws IOException {
            this.loader.counterOFF(sDDescriptor);
            PerfmonModuleTrace.this.statcon.setDescriptorImage(sDDescriptor, PerfmonModuleTrace.this.img.getImage("trace_stop.gif"));
            EList eList = sDDescriptor.getChildren();
            int n = 0;
            while (n < eList.size()) {
                this.apply((SDDescriptor)eList.get(n));
                ++n;
            }
        }
    }

    class CounterON
    implements Runnable {
        PerfmonLoader loader;

        public CounterON(PerfmonLoader perfmonLoader) {
            this.loader = perfmonLoader;
        }

        public void run() {
            try {
                this.applyDown(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
                this.applyUp(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.error("unable to set counter to ON", (Throwable)exception);
            }
        }

        void apply(SDDescriptor sDDescriptor) throws IOException {
            try {
                this.loader.counterON(sDDescriptor);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            PerfmonModuleTrace.this.statcon.setDescriptorImage(sDDescriptor, PerfmonModuleTrace.this.img.getImage("trace_start.gif"));
        }

        void applyUp(SDDescriptor sDDescriptor) throws IOException {
            SDDescriptor sDDescriptor2 = sDDescriptor.getParent();
            if (sDDescriptor2 != null) {
                this.apply(sDDescriptor2);
                this.applyUp(sDDescriptor2);
            }
        }

        void applyDown(SDDescriptor sDDescriptor) throws IOException {
            this.apply(sDDescriptor);
            EList eList = sDDescriptor.getChildren();
            int n = 0;
            while (n < eList.size()) {
                this.applyDown((SDDescriptor)eList.get(n));
                ++n;
            }
        }
    }

    class StopTraceAction
    implements Runnable {
        PerfmonLoader loader;
        TRCAgent agent;

        public StopTraceAction(PerfmonLoader perfmonLoader, TRCAgent tRCAgent) {
            this.loader = perfmonLoader;
            this.agent = tRCAgent;
        }

        public void run() {
            PerfmonModuleTrace.this.unloadTrace();
            try {
                PerfmonModuleTrace.this.saveStatisticalModel();
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.error("problem saving statistical model", (Throwable)exception);
            }
        }
    }

    class UpdateTreeAction
    implements Runnable {
        PerfmonLoader loader;
        TRCAgent agent;

        public UpdateTreeAction(PerfmonLoader perfmonLoader, TRCAgent tRCAgent) {
            this.loader = perfmonLoader;
            this.agent = tRCAgent;
        }

        public void run() {
            try {
                this.loader.getUpdatedTree();
            }
            catch (IOException iOException) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)iOException, PerfmonPlugin.getString("UPDATE_TREE_ERROR"), false);
            }
        }
    }

    class VariablePadder
    extends Thread {
        boolean die = false;

        VariablePadder() {
        }

        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(750L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    PerfmonModuleTrace.this.freq_var.padRequestedValue(System.currentTimeMillis());
                    PerfmonModuleTrace.this.freq_var.setMeasuredValue(System.currentTimeMillis(), PerfmonModuleTrace.this.freq_var.getLastMeasuredValue());
                }
                catch (Exception exception) {
                    PerfmonPlugin.DBG.warning("unable to pad variable requested and measured - " + exception);
                }
            }
        }
    }
}

