/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonHostDialog;
import org.eclipse.hyades.perfmon.PerfmonModuleTrace;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModule;
import org.eclipse.hyades.statistical.ui.editor.internal.XMLConfigUtil;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PerfmonStatConModule
implements StatConModule {
    ArrayList traces = new ArrayList();
    ImageManager img = PerfmonPlugin.img;
    StatConInterface statcon;
    String PERFMON_NODE = "Perfmon Trace";
    String NEW_TRACE = "New Perfmon Trace";
    String STOP_TRACE = "Stop Trace";
    String START_TRACING = "Start Tracing this Counter";
    String STOP_TRACING = "Stop Tracing this Counter";
    static String ACTION_SETSMODELPATH = "Set Statistical Model save path...";
    URI smodelpath = null;
    SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

    static String uriToHumanReadable(URI uRI) {
        String string = uRI.path();
        if (string.toLowerCase().startsWith("/resource/")) {
            string = string.substring(10);
        }
        return string;
    }

    private void redoActions() {
        this.statcon.addModuleNodeAction(this.PERFMON_NODE, ACTION_SETSMODELPATH, PerfmonPlugin.getString("ACTION_SETSMODELPATH") + " (" + PerfmonStatConModule.uriToHumanReadable(this.smodelpath) + ")", this.img.getImage("save.gif"), (Runnable)new PerfmonSetPath());
    }

    public void load(StatConInterface statConInterface) throws Exception {
        this.statcon = statConInterface;
        this.smodelpath = statConInterface.getCurrentProjectURI();
        statConInterface.addModuleNode(this.PERFMON_NODE, this.PERFMON_NODE, this.img.getImage("logo.gif"));
        statConInterface.addModuleNodeAction(this.PERFMON_NODE, this.NEW_TRACE, this.NEW_TRACE, this.img.getImage("trace_start.gif"), (Runnable)new NewTraceAction());
        statConInterface.addModuleNodeAction(this.PERFMON_NODE, ACTION_SETSMODELPATH, PerfmonPlugin.getString("ACTION_SETSMODELPATH") + " (" + PerfmonStatConModule.uriToHumanReadable(this.smodelpath) + ")", this.img.getImage("save.gif"), (Runnable)new PerfmonSetPath());
    }

    public void applyConfig(String string) throws Exception {
    }

    public void loadModuleData(byte[] byArray) throws Exception {
        PerfmonPlugin.DBG.info("loading perfmon module data: " + new String(byArray));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        Element element = document.getDocumentElement();
        ArrayList arrayList = XMLConfigUtil.getAllElements((NodeList)element.getChildNodes(), (String)"config");
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < arrayList.size()) {
            Element element2 = (Element)arrayList.get(n);
            String string = element2.getAttribute("smodelpath");
            if (string != null && string.length() > 0) {
                try {
                    IFile iFile = iWorkspaceRoot.getFile((IPath)new Path(string));
                    this.smodelpath = URI.createPlatformResourceURI((String)iFile.getProjectRelativePath().toString());
                }
                catch (Throwable throwable) {
                    PerfmonPlugin.DBG.info("invalid valid statistical model save path specified");
                }
            }
            ++n;
        }
        this.redoActions();
    }

    public byte[] saveModuleData() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<perfmon_config>\n");
        stringBuffer.append("  <config smodelpath=\"" + this.smodelpath + "\" />\n");
        stringBuffer.append("</perfmon_config>\n");
        PerfmonPlugin.DBG.info("saving perfmon module data:" + stringBuffer);
        return stringBuffer.toString().getBytes();
    }

    public String getModuleRef() {
        return "org.eclipse.hyades.perfmon";
    }

    public void unload() throws Exception {
        this.statcon.removeModuleNode(this.PERFMON_NODE);
        int n = 0;
        while (n < this.traces.size()) {
            PerfmonModuleTrace perfmonModuleTrace = (PerfmonModuleTrace)this.traces.get(n);
            try {
                perfmonModuleTrace.unloadTrace();
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.warning("failed to unload trace " + n);
            }
            ++n;
        }
    }

    class NewTraceAction
    implements Runnable {
        NewTraceAction() {
        }

        public void run() {
            try {
                PerfmonHostDialog perfmonHostDialog = new PerfmonHostDialog(PerfmonStatConModule.this.statcon.getGraphWindow().getShell());
                perfmonHostDialog.open();
                String string = perfmonHostDialog.getRACHost();
                String string2 = perfmonHostDialog.getPerfmonHost();
                if (string == null) {
                    return;
                }
                PerfmonModuleTrace perfmonModuleTrace = new PerfmonModuleTrace(PerfmonStatConModule.this.statcon, string, string2, PerfmonStatConModule.this.smodelpath);
                PerfmonStatConModule.this.traces.add(perfmonModuleTrace);
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.error("error starting perfmon trace", throwable);
            }
        }
    }

    class PerfmonSetPath
    implements Runnable {
        PerfmonSetPath() {
        }

        public void run() {
            PerfmonPlugin.DBG.info("set test model save path");
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path path = null;
            IFolder iFolder = null;
            try {
                path = new Path("" + PerfmonStatConModule.this.smodelpath);
                iFolder = iWorkspaceRoot.getFolder((IPath)path);
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path");
            }
            PerfmonPlugin.DBG.info("showing container selection dialog");
            ContainerSelectionDialog containerSelectionDialog = null;
            containerSelectionDialog = new ContainerSelectionDialog(PerfmonStatConModule.this.statcon.getGraphWindow().getShell(), (IContainer)iFolder, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
            containerSelectionDialog.open();
            Object[] objectArray = containerSelectionDialog.getResult();
            if (objectArray != null && objectArray.length > 0) {
                URI uRI;
                Path path2 = (Path)objectArray[0];
                PerfmonStatConModule.this.smodelpath = uRI = URI.createPlatformResourceURI((String)path2.toString());
                PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
                PerfmonStatConModule.this.redoActions();
                PerfmonStatConModule.this.statcon.setDirty(true);
            }
        }
    }
}

