/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.perfmon.xml.XMLParserListener;

public class StatisticalXMLTranslator
implements XMLParserListener {
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    SDDescriptor root;
    HashMap idmap = new HashMap();
    HashMap descriptormap = new HashMap();
    SDDescriptor sdparent = null;
    SDDescriptor sd = null;
    SDSampleWindow window;
    boolean inside_description = false;
    ArrayList listeners = new ArrayList();

    public String getID(SDDescriptor sDDescriptor) {
        return (String)this.descriptormap.get(sDDescriptor);
    }

    public SDDescriptor getDescriptor(String string) {
        return (SDDescriptor)this.idmap.get(string);
    }

    public void addLoaderListener(StatisticalLoaderListener statisticalLoaderListener) {
        this.listeners.add(statisticalLoaderListener);
    }

    public void removeLoaderListener(StatisticalLoaderListener statisticalLoaderListener) {
        this.listeners.remove(statisticalLoaderListener);
    }

    public StatisticalXMLTranslator(TRCAgent tRCAgent, String string) {
        this.root = this.factory.createSDDescriptor();
        this.root.setName(string);
        this.root.setAgent(tRCAgent);
        this.window = this.getOrCreateView(tRCAgent);
    }

    public StatisticalXMLTranslator(SDDescriptor sDDescriptor) {
        this.root = sDDescriptor;
        this.window = this.getOrCreateView(sDDescriptor.getAgent());
    }

    private SDSampleWindow getOrCreateView(TRCAgent tRCAgent) {
        SDView sDView = (SDView)tRCAgent.getView();
        if (sDView == null) {
            sDView = this.factory.createSDView();
            sDView.setAgent(tRCAgent);
            sDView.setName("view");
        }
        if (sDView.eContents().size() == 0) {
            SDSampleWindow sDSampleWindow = this.factory.createSDSampleWindow();
            sDSampleWindow.setView(sDView);
            return sDSampleWindow;
        }
        return (SDSampleWindow)sDView.eContents().get(0);
    }

    public SDDescriptor getModel() {
        return this.root;
    }

    private void modelChanged(SDDescriptor sDDescriptor) {
        int n = 0;
        while (n < this.listeners.size()) {
            StatisticalLoaderListener statisticalLoaderListener = (StatisticalLoaderListener)this.listeners.get(n);
            statisticalLoaderListener.modelChanged(sDDescriptor);
            ++n;
        }
    }

    public void startElement(String string, HashMap hashMap) throws Exception {
        if (string.equals("description")) {
            this.inside_description = true;
            return;
        }
        if (string.equals("RangeRepresentation")) {
            return;
        }
        if (string.equals("GaugeRepresentation")) {
            return;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        double d = 0.0;
        String string5 = null;
        String string6 = null;
        if (string.endsWith("Observation")) {
            d = Double.parseDouble((String)hashMap.get("time"));
            string5 = (String)hashMap.get("value");
            string6 = (String)hashMap.get("memberDescriptor");
            this.sd = (SDDescriptor)this.idmap.get(string6);
        }
        if (string.endsWith("Descriptor")) {
            string2 = (String)hashMap.get("id");
            string3 = (String)hashMap.get("name");
            string4 = (String)hashMap.get("parent");
            if (string2 != null) {
                this.sd = (SDDescriptor)this.idmap.get(string2);
                if (this.sd != null) {
                    return;
                }
            }
            if (string4 != null) {
                this.sdparent = (SDDescriptor)this.idmap.get(string4);
            }
            if (string4 == null || this.sdparent == null) {
                this.sdparent = this.root;
            }
        }
        if (string.equals("Descriptor")) {
            if (this.sd == null) {
                this.sd = this.factory.createSDDescriptor();
                this.sd.setParent(this.sdparent);
                this.sd.setName(string3);
                this.idmap.put(string2, this.sd);
                this.descriptormap.put(this.sd, string2);
                this.modelChanged(this.sdparent);
            }
        } else if (string.equals("CounterDescriptor")) {
            if (this.sd == null) {
                this.sd = this.factory.createSDCounterDescriptor();
                this.sd.setParent(this.sdparent);
                this.sd.setName(string3 + " - " + string2);
                this.idmap.put(string2, this.sd);
                this.descriptormap.put(this.sd, string2);
                this.modelChanged(this.sdparent);
            }
        } else if (string.equals("SampleDescriptor")) {
            if (this.sd == null) {
                this.sd = this.factory.createSDSampleDescriptor();
                this.sd.setParent(this.sdparent);
                this.sd.setName(string3);
                this.idmap.put(string2, this.sd);
                this.descriptormap.put(this.sd, string2);
                this.modelChanged(this.sdparent);
            }
        } else if (string.equals("ContiguousObservation")) {
            SDSnapshotObservation sDSnapshotObservation;
            SDMemberDescriptor sDMemberDescriptor = (SDMemberDescriptor)this.sd;
            EList eList = sDMemberDescriptor.getSnapshotObservation();
            SDContiguousObservation sDContiguousObservation = null;
            int n = 0;
            while (n < eList.size()) {
                sDSnapshotObservation = (SDSnapshotObservation)eList.get(n);
                if (sDSnapshotObservation instanceof SDContiguousObservation) {
                    sDContiguousObservation = (SDContiguousObservation)sDSnapshotObservation;
                    break;
                }
                ++n;
            }
            if (sDContiguousObservation == null) {
                sDContiguousObservation = this.factory.createSDContiguousObservation();
                sDContiguousObservation.setMemberDescriptor(sDMemberDescriptor);
                sDContiguousObservation.setWindow(this.window);
                eList.add(sDContiguousObservation);
                this.modelChanged((SDDescriptor)sDMemberDescriptor);
            }
            sDSnapshotObservation = (BasicEList)sDContiguousObservation.getCreationTime();
            BasicEList basicEList = (BasicEList)sDContiguousObservation.getValue();
            sDSnapshotObservation.addUnique((Object)new Double(d));
            basicEList.addUnique((Object)new Double(string5));
        } else if (string.equals("DescreteObservation") || string.equals("DiscreteObservation")) {
            SDSnapshotObservation sDSnapshotObservation;
            SDMemberDescriptor sDMemberDescriptor = (SDMemberDescriptor)this.sd;
            EList eList = sDMemberDescriptor.getSnapshotObservation();
            SDDiscreteObservation sDDiscreteObservation = null;
            int n = 0;
            while (n < eList.size()) {
                sDSnapshotObservation = (SDSnapshotObservation)eList.get(n);
                if (sDSnapshotObservation instanceof SDDiscreteObservation) {
                    sDDiscreteObservation = (SDDiscreteObservation)sDSnapshotObservation;
                    break;
                }
                ++n;
            }
            if (sDDiscreteObservation == null) {
                sDDiscreteObservation = this.factory.createSDDiscreteObservation();
                sDDiscreteObservation.setMemberDescriptor(sDMemberDescriptor);
                sDDiscreteObservation.setWindow(this.window);
                eList.add(sDDiscreteObservation);
                this.modelChanged((SDDescriptor)sDMemberDescriptor);
            }
            sDSnapshotObservation = (BasicEList)sDDiscreteObservation.getCreationTime();
            BasicEList basicEList = (BasicEList)sDDiscreteObservation.getValue();
            sDSnapshotObservation.addUnique((Object)new Double(d));
            basicEList.addUnique((Object)new Integer((int)Double.parseDouble(string5)));
        } else if (string.equals("TextObservation")) {
            SDSnapshotObservation sDSnapshotObservation;
            SDMemberDescriptor sDMemberDescriptor = (SDMemberDescriptor)this.sd;
            EList eList = sDMemberDescriptor.getSnapshotObservation();
            SDTextObservation sDTextObservation = null;
            int n = 0;
            while (n < eList.size()) {
                sDSnapshotObservation = (SDSnapshotObservation)eList.get(n);
                if (sDSnapshotObservation instanceof SDTextObservation) {
                    sDTextObservation = (SDTextObservation)sDSnapshotObservation;
                    break;
                }
                ++n;
            }
            if (sDTextObservation == null) {
                sDTextObservation = this.factory.createSDTextObservation();
                sDTextObservation.setMemberDescriptor(sDMemberDescriptor);
                sDTextObservation.setWindow(this.window);
                eList.add(sDTextObservation);
                this.modelChanged((SDDescriptor)sDMemberDescriptor);
            }
            sDSnapshotObservation = (BasicEList)sDTextObservation.getCreationTime();
            BasicEList basicEList = (BasicEList)sDTextObservation.getTextValue();
            if (string5 == null) {
                throw new NullPointerException("null value for SDTextObservation");
            }
            sDSnapshotObservation.addUnique((Object)new Double(d));
            basicEList.addUnique((Object)string5);
        }
    }

    public void endElement(String string) throws Exception {
        if (string.equals("description")) {
            this.inside_description = false;
            return;
        }
        if (string.equals("RangeRepresentation")) {
            return;
        }
        if (string.equals("GaugeRepresentation")) {
            return;
        }
    }

    public void startDocument() throws Exception {
    }

    public void endDocument() throws Exception {
    }

    public void text(String string) throws Exception {
        if (this.inside_description) {
            this.sd.setDescription(string);
        }
    }
}

