/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderFileSelectPage;
import org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderNoProjectsPage;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class HttpRecorderLaunchWizard
extends RecorderWizard {
    private HttpRecorderFileSelectPage fileSelectPage;
    private HttpRecorderNoProjectsPage newProjectPage;
    private boolean hasNoProjects = false;
    static /* synthetic */ Class class$org$eclipse$hyades$execution$recorder$http$ui$wizards$HttpRecorderNoProjectsPage;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (RecorderFactory.getInstance().getActiveRecorder() != null) {
            RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_ERROR"));
            return;
        }
        Recorder recorder = null;
        try {
            File file;
            File file2;
            String string;
            recorder = HttpRecorderPlugin.getDefault().getRecorder();
            String string2 = "port," + HttpRecorderPlugin.getPreference("default_proxy_port");
            String string3 = string2 + ";startupURL," + this.getStartupURL();
            String string4 = HttpRecorderPlugin.getPreference("application_under_test");
            recorder.setApplicationAdapterID(string4);
            if (!string4.equalsIgnoreCase("-1")) {
                RecorderAppAdapterFactory.getInstance().getClient(HttpRecorderPlugin.getPreference("application_under_test")).setInitString(string3);
            } else {
                string2 = "port," + HttpRecorderPlugin.getPreference("default_proxy_port");
            }
            if (this.hasNoProjects) {
                IProject iProject = this.newProjectPage.createJavaProject(this.monitor);
                if (iProject == null) throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.JAVA_PROJECT_NOT_CREATED_ERROR"));
                string = iProject.getFullPath().toString() + "/" + this.newProjectPage.getRecFile();
            } else {
                string = this.fileSelectPage.getSelectedFilePath();
            }
            String string5 = string.substring(0, string.lastIndexOf(46)) + ".testsuite";
            HttpRecorderPlugin.storePreference("recording_path", string);
            recorder.setConfigParams(string2);
            recorder.setRecordingPath(string);
            recorder.setScriptgenID(TestgenPlugin.getPreference((String)"default_test_generator"));
            recorder.setTestPath(string5);
            URL uRL = Platform.resolve((URL)new URL(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL(), "testkeys"));
            String string6 = uRL.toString();
            if (uRL.getProtocol().equals("file")) {
                string6 = uRL.getFile();
            }
            if ((file2 = new File(string6)).exists() && (file = new File("C:\\testkeys")).createNewFile()) {
                try {
                    int n;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    byte[] byArray = new byte[256];
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            recorder.Record();
            return;
        }
        catch (Exception exception) {
            if (recorder != null) {
                recorder.setActive(false);
            }
            exception.printStackTrace();
            RecorderControlView.getInstance().addMessage(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE") + exception.getMessage());
        }
    }

    public void addPages() {
        this.setWindowTitle(HttpRecorderPlugin.getResourceString("NAME"));
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (iProjectArray.length < 1) {
            this.hasNoProjects = true;
            this.newProjectPage = new HttpRecorderNoProjectsPage((class$org$eclipse$hyades$execution$recorder$http$ui$wizards$HttpRecorderNoProjectsPage == null ? (class$org$eclipse$hyades$execution$recorder$http$ui$wizards$HttpRecorderNoProjectsPage = HttpRecorderLaunchWizard.class$("org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderNoProjectsPage")) : class$org$eclipse$hyades$execution$recorder$http$ui$wizards$HttpRecorderNoProjectsPage).getName());
            this.addPage((IWizardPage)this.newProjectPage);
            this.newProjectPage.setInitialProjectName(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.DEFAULT_PROJECT_NAME"));
        } else {
            this.fileSelectPage = new HttpRecorderFileSelectPage();
            this.addPage((IWizardPage)this.fileSelectPage);
        }
    }

    protected String getStartupURL() throws IOException {
        String string;
        File file;
        String string2 = "readme";
        String string3 = ".html";
        URL uRL = Platform.resolve((URL)HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL());
        String string4 = null;
        if (uRL.getProtocol().equals("file")) {
            string4 = uRL.getFile() + string2;
        }
        if (!((file = new File(string = string4 + "_" + Locale.getDefault().toString() + string3)).exists() || (file = new File(string = string4 + "_" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() + string3)).exists() || (file = new File(string = string4 + "_" + Locale.getDefault().getLanguage() + string3)).exists() || (file = new File(string = string4 + string3)).exists())) {
            return "about:blank";
        }
        return "file://" + string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

