/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class XMLnodeLoader
extends IgnoredXMLFragmentLoader {
    private String hostname;
    private String ipaddress;
    private String nodeId;
    private double timezone;

    public void addAttribute(String string, String string2) {
        if (string.equals("nodeId")) {
            this.nodeId = string2;
        } else if (string.equals("hostname")) {
            this.hostname = string2;
        } else if (string.equals("ipaddress")) {
            this.ipaddress = string2;
        } else if (string.equals("timezone")) {
            this.timezone = Double.valueOf(string2);
        }
    }

    public void addYourselfInContext() {
        String string;
        TRCNode tRCNode;
        TRCMonitor tRCMonitor = this.context.getMonitor();
        if (tRCMonitor == null) {
            return;
        }
        if (this.nodeId == null) {
            return;
        }
        if (this.hostname == null) {
            this.hostname = "_unknown";
        }
        if ((tRCNode = this.context.getNode()) == null) {
            tRCNode = LoadersUtils.locateNodeFromMonitor(this.context.getMonitor(), this.hostname, this.ipaddress, this.nodeId);
        } else {
            string = tRCNode.getRuntimeId();
            if (string != null && !string.equals(this.nodeId)) {
                tRCNode = LoadersUtils.locateNodeFromMonitor(tRCMonitor, this.hostname, this.ipaddress, this.nodeId);
            }
        }
        if (tRCNode == null) {
            string = LoadersUtils.getMonitorFolder(tRCMonitor);
            Resource resource = null;
            if (string != null) {
                String string2 = StringUtil.change(tRCMonitor.getName().trim(), " ", "") + "_" + this.hostname.trim();
                String string3 = string + string2;
                resource = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(string3 + ".trcnxmi")).createResource(SaveUtil.createURI(string3 + ".trcnxmi"));
                resource.setModified(true);
                HierarchyResourceSetImpl.getInstance().getResources().add((Object)resource);
            }
            tRCNode = HierarchyFactory.eINSTANCE.createTRCNode();
            tRCNode.setName(this.hostname);
            tRCNode.setRuntimeId(this.nodeId);
            tRCNode.setMonitor(tRCMonitor);
            if (resource != null) {
                resource.getContents().add((Object)tRCNode);
            }
        } else {
            tRCNode.setIpAddress(this.ipaddress);
            tRCNode.setRuntimeId(this.nodeId);
            tRCNode.setTimezone(this.timezone);
        }
        this.context.setNode(tRCNode);
    }

    public void initialize(HierarchyContext hierarchyContext, String string) {
        super.initialize(hierarchyContext, string);
        this.hostname = null;
        this.ipaddress = null;
        this.nodeId = null;
        this.timezone = 0.0;
    }
}

