/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    public static String useXMLSymbols(String string) {
        if (string != null) {
            string = StringUtil.change(string, "&", "&amp;");
            string = StringUtil.change(string, "<", "&lt;");
            string = StringUtil.change(string, ">", "&gt;");
            string = StringUtil.change(string, "\"", "&quot;");
            string = StringUtil.change(string, "'", "&apos;");
            string = StringUtil.change(string, "\t", "&#x9;");
            string = StringUtil.change(string, "\n", "&#xA;");
            string = StringUtil.change(string, "\r", "&#xD;");
        }
        return string;
    }

    public static String removeXMLSymbols(String string) {
        if (string != null) {
            string = StringUtil.change(string, "&amp;", "&");
            string = StringUtil.change(string, "&lt;", "<");
            string = StringUtil.change(string, "&gt;", ">");
            string = StringUtil.change(string, "&quot;", "\"");
            string = StringUtil.change(string, "&apos;", "'");
            string = StringUtil.change(string, "&#x9;", "\t");
            string = StringUtil.change(string, "&#xA;", "\n");
            string = StringUtil.change(string, "&#xD;", "\r");
        }
        return string;
    }

    public static StringBuffer createXMLAttribute(String string, String string2, boolean bl) {
        if (string2 == null) {
            return new StringBuffer(0);
        }
        string2 = XMLUtil.useXMLSymbols(string2);
        if (bl) {
            return new StringBuffer("<").append(string).append(">").append(string2).append("</").append(string).append(">");
        }
        return new StringBuffer(" ").append(string).append("=\"").append(string2).append("\"");
    }

    public static Element loadDom(InputStream inputStream, String string) {
        Object object;
        if (inputStream == null || string == null) {
            return null;
        }
        Node node = null;
        try {
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setIgnoringComments(true);
            ((DocumentBuilderFactory)object).setValidating(true);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            documentBuilder.setErrorHandler(XMLUtil.createErrorHandler(false));
            node = documentBuilder.parse(inputStream);
        }
        catch (Throwable throwable) {
            LoadersUtils.log(throwable);
        }
        if (node == null) {
            return null;
        }
        if (string != null) {
            object = node.getElementsByTagName(string);
            if (object.getLength() > 0 && object.item(0) instanceof Element) {
                return (Element)object.item(0);
            }
            return null;
        }
        return (Element)node.getFirstChild();
    }

    public static Element loadDom(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        return XMLUtil.loadDom(new ByteArrayInputStream(string.getBytes()), string2);
    }

    public static String getValue(Element element, String string) {
        if (element == null || string == null) {
            return null;
        }
        String string2 = element.getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            NodeList nodeList = element.getElementsByTagName(string);
            int n = 0;
            int n2 = nodeList.getLength();
            while (n < n2) {
                String string3;
                Node node = nodeList.item(n);
                Node node2 = nodeList.item(0).getFirstChild();
                if (node2 != null && (string3 = node2.getNodeValue()) != null && node.getParentNode().equals(element)) {
                    string2 = string3;
                    break;
                }
                ++n;
            }
        }
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public static NodeList getChildrenByName(Element element, String string) {
        if (element == null || string == null) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            if (nodeList.item(n) instanceof Element && string.equals(((Element)nodeList.item(n)).getTagName())) {
                arrayList.add(nodeList.item(n));
            }
            ++n;
        }
        return XMLUtil.createNodeList(arrayList);
    }

    public static NodeList createNodeList(final List list) {
        if (list == null) {
            return null;
        }
        NodeList nodeList = new NodeList(){

            public int getLength() {
                return list.size();
            }

            public Node item(int n) {
                return (Node)list.get(n);
            }
        };
        return nodeList;
    }

    public static Document getXmlDom(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            File file = new File(string);
            documentBuilder.setErrorHandler(XMLUtil.createErrorHandler(false));
            return documentBuilder.parse(file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static ErrorHandler createErrorHandler(final boolean bl) {
        ErrorHandler errorHandler = new ErrorHandler(){

            public void error(SAXParseException sAXParseException) {
                if (bl) {
                    LoadersUtils.log(sAXParseException);
                }
            }

            public void fatalError(SAXParseException sAXParseException) {
                if (bl) {
                    LoadersUtils.log(sAXParseException);
                }
            }

            public void warning(SAXParseException sAXParseException) {
                if (bl) {
                    LoadersUtils.log(sAXParseException);
                }
            }
        };
        return errorHandler;
    }

    public static int getIntValue(Element element, String string) {
        try {
            return Integer.parseInt(XMLUtil.getValue(element, string));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String xmlVariable(String string, String string2) {
        return XMLUtil.createXMLAttribute(string, string2, false).toString();
    }

    public static String adjustXMLValue(String string) {
        return XMLUtil.useXMLSymbols(string);
    }
}

