/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.hyades.ui.sample.svg.generator.DOMDataRetriever;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputConstants;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommonDataRetriever
extends DOMDataRetriever
implements IDataInputProcessingExceptionCodes,
IDataInputConstants {
    CommonDataRetriever() {
    }

    public int getNumberOfDatasets(Document document) throws DataInputProcessingException {
        if (document == null) {
            this.throwException((short)114, "");
        }
        int n = this.getNumberOfElements(document, "dataSet");
        return n;
    }

    public Hashtable getConfigurationAttributes(Document document, Document document2) throws DataInputProcessingException {
        Document document3;
        Document document4 = document3 = document != null ? document : document2;
        if (document3 == null) {
            this.throwException((short)114, "");
        }
        Hashtable hashtable = this.getAttributesFromSingleElement(document3, "configuration");
        return hashtable;
    }

    public String[] getLegendLabels(Document document) throws DataInputProcessingException {
        Vector vector;
        if (document == null) {
            this.throwException((short)114, "");
        }
        if ((vector = this.getAttributeFromElements(document, "dataSet", "label")) == null) {
            this.throwException((short)118, "dataSet");
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        Vector vector2 = this.getAttributeFromElements(document, "dataSet", "position");
        if (vector2 == null) {
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)vector.get(n2);
                ++n2;
            }
            return stringArray;
        }
        if (n != vector2.size()) {
            this.throwException((short)107, "dataSet");
        }
        int n3 = 0;
        while (n3 < n) {
            short s = 0;
            try {
                s = Short.parseShort((String)vector2.get(n3));
            }
            catch (Exception exception) {
                this.throwException((short)102, "dataSet");
            }
            if (s > n - 1 || s < 0) {
                this.throwException((short)125, "dataSet");
            }
            String string = null;
            try {
                string = stringArray[s];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null) {
                this.throwException((short)101, "dataSet");
            }
            stringArray[s] = (String)vector.get(n3);
            ++n3;
        }
        return stringArray;
    }

    public String getTimestamp(Document document) throws DataInputProcessingException {
        if (document == null) {
            this.throwException((short)114, "");
        }
        String string = this.getAttributeFromSingleElement(document, "dataUpdate", "timestamp");
        return string;
    }

    public DataRange getDataRange(Document document, String string) throws DataInputProcessingException {
        Object object;
        Object object2;
        Object object3;
        NodeList nodeList = document.getElementsByTagName("dataRange");
        Element element = null;
        int n = nodeList.getLength();
        if (string == null || string.equals("")) {
            if (n <= 0) {
                return null;
            }
            element = (Element)nodeList.item(0);
        } else {
            int n2 = 0;
            while (n2 < n) {
                object3 = (Element)nodeList.item(n2);
                if (object3.getAttribute("location").equals(string)) {
                    element = object3;
                    break;
                }
                ++n2;
            }
        }
        if (element == null) {
            return null;
        }
        DataRange dataRange = new DataRange(string);
        if (element.hasAttribute("id")) {
            dataRange.setId(element.getAttribute("id"));
        }
        if (element.hasAttribute("label")) {
            dataRange.setLabel(element.getAttribute("label"));
        }
        if (element.hasAttribute("type") && (object3 = element.getAttribute("type")) != null) {
            if (((String)object3).equals("continuum")) {
                dataRange.setType(0);
            } else if (((String)object3).equals("categorization")) {
                dataRange.setType(1);
            }
        }
        object3 = element.getElementsByTagName("segmentMarker");
        int n3 = object3.getLength();
        TreeSet<SegmentMarker> treeSet = new TreeSet<SegmentMarker>(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                SegmentMarker segmentMarker = (SegmentMarker)object;
                SegmentMarker segmentMarker2 = (SegmentMarker)object2;
                double d2 = segmentMarker.getValue();
                return d2 == (d = segmentMarker2.getValue()) ? 0 : (d2 < d ? -1 : 1);
            }
        });
        int n4 = 0;
        while (n4 < n3) {
            object2 = (Element)object3.item(n4);
            SegmentMarker segmentMarker = new SegmentMarker(object2.getAttribute("value"));
            if (object2.hasAttribute("label")) {
                segmentMarker.setLabel(object2.getAttribute("label"));
            }
            if (object2.hasAttribute("type")) {
                object = object2.getAttribute("type");
                if (((String)object).equals("tick")) {
                    segmentMarker.setType(0);
                } else if (((String)object).equals("line")) {
                    segmentMarker.setType(1);
                }
            }
            treeSet.add(segmentMarker);
            ++n4;
        }
        object2 = new SegmentMarker[n3];
        int n5 = 0;
        object = treeSet.iterator();
        while (object.hasNext()) {
            object2[n5] = (SegmentMarker)object.next();
            ++n5;
        }
        dataRange.setSegmentMarkers((SegmentMarker[])object2);
        return dataRange;
    }

    private DataPoint[] getDatapointsFromList(NodeList nodeList) throws DataInputProcessingException {
        Object object;
        Object object2;
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                DataPoint dataPoint = (DataPoint)object;
                DataPoint dataPoint2 = (DataPoint)object2;
                double d2 = dataPoint.getValue1();
                return d2 == (d = dataPoint2.getValue1()) ? 0 : (d2 < d ? -1 : 1);
            }
        });
        int n2 = 0;
        while (n2 < n) {
            Object object3;
            object2 = (Element)nodeList.item(n2);
            String string = object2.getAttribute("value2");
            object = object2.hasAttribute("value1") ? new DataPoint(object2.getAttribute("value1"), string) : new DataPoint(string);
            if (object2.hasAttribute("type")) {
                object3 = object2.getAttribute("type");
                if (((String)object3).equals("actual")) {
                    ((DataPoint)object).setType(0);
                } else if (((String)object3).equals("hole")) {
                    ((DataPoint)object).setType(1);
                }
            }
            if (object2.hasAttribute("label")) {
                ((DataPoint)object).setLabel(object2.getAttribute("label"));
            }
            if ((object3 = object2.getElementsByTagName("image")).getLength() > 0) {
                int n3;
                String string2;
                Element element = (Element)object3.item(0);
                if (element.hasAttribute("type")) {
                    ((DataPoint)object).setImageType(element.getAttribute("type"));
                }
                if (element.hasAttribute("uri")) {
                    ((DataPoint)object).setImageURI(element.getAttribute("uri"));
                }
                if (element.hasAttribute("code")) {
                    ((DataPoint)object).setImageCode(element.getAttribute("code"));
                }
                if (element.hasAttribute("width")) {
                    string2 = element.getAttribute("width");
                    n3 = Integer.parseInt(string2);
                    if (n3 < 0) {
                        this.throwException((short)127, string2);
                    } else {
                        ((DataPoint)object).setImageWidth(n3);
                    }
                }
                if (element.hasAttribute("height")) {
                    string2 = element.getAttribute("height");
                    n3 = Integer.parseInt(string2);
                    if (n3 < 0) {
                        this.throwException((short)128, string2);
                    } else {
                        ((DataPoint)object).setImageHeight(n3);
                    }
                }
            }
            treeSet.add(object);
            ++n2;
        }
        object2 = new DataPoint[n];
        int n4 = 0;
        object = treeSet.iterator();
        while (object.hasNext()) {
            object2[n4] = (DataPoint)object.next();
            ++n4;
        }
        return object2;
    }

    private DataSet getDataSet(Element element, int n) throws DataInputProcessingException {
        DataSet dataSet = new DataSet(n);
        if (element.hasAttribute("label")) {
            dataSet.setLabel(element.getAttribute("label"));
        }
        if (element.hasAttribute("flyoverLabel")) {
            dataSet.setFlyoverLabel(element.getAttribute("flyoverLabel"));
        }
        if (element.hasAttribute("dataRange1Ref")) {
            dataSet.setDataRange1Ref(element.getAttribute("dataRange1Ref"));
        }
        if (element.hasAttribute("dataRange2Ref")) {
            dataSet.setDataRange2Ref(element.getAttribute("dataRange2Ref"));
        }
        if (element.hasAttribute("total")) {
            double d = Double.parseDouble(element.getAttribute("total"));
            if (d >= 0.0) {
                dataSet.setTotal(d);
            } else {
                throw new DataInputProcessingException(102, "total");
            }
        }
        dataSet.setDataPoints(this.getDatapointsFromList(element.getElementsByTagName("dataPoint")));
        return dataSet;
    }

    public DataSet getDatasetWithPosition(Document document, String string) throws DataInputProcessingException {
        Element element;
        if (document == null) {
            this.throwException((short)114, "");
        }
        if ((element = this.getElementWithAttribute(document, "dataSet", "position", string)) == null) {
            element = this.getElementWithDocOrderOrdinal(document, "dataSet", string);
        }
        if (element == null) {
            this.throwException((short)124, "dataSet");
        }
        return this.getDataSet(element, Integer.parseInt(string));
    }

    public DataSet getFirstDataset(Document document) throws DataInputProcessingException {
        Element element;
        if (document == null) {
            this.throwException((short)114, "");
        }
        if ((element = this.getFirstElement(document, "dataSet")) == null) {
            this.throwException((short)124, "dataPoint");
        }
        return this.getDataSet(element, 0);
    }

    protected void throwException(short s, String string) throws DataInputProcessingException {
        DataInputProcessingException dataInputProcessingException = new DataInputProcessingException(s, string);
        throw dataInputProcessingException;
    }
}

