/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;

public class DataRange {
    public static final int UNKNOWN = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int RIGHT = 4;
    public static final int CONTINUUM = 0;
    public static final int CATEGORIZATION = 1;
    private String id = null;
    private String label = null;
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private int location = 0;
    private int type = 0;
    private SegmentMarker[] segmentMarkers = null;

    public DataRange(String string) {
        if (string != null) {
            int n = 0;
            if (string.equals("S")) {
                n = 1;
            } else if (string.equals("W")) {
                n = 2;
            } else if (string.equals("N")) {
                n = 3;
            } else if (string.equals("E")) {
                n = 4;
            }
            this.setLocation(n);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int n) {
        this.location = n;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public SegmentMarker[] getSegmentMarkers() {
        return this.segmentMarkers;
    }

    public void setSegmentMarkers(SegmentMarker[] segmentMarkerArray) {
        this.segmentMarkers = segmentMarkerArray;
        if (segmentMarkerArray.length <= 0) {
            return;
        }
        this.maxValue = this.minValue = segmentMarkerArray[0].getValue();
        int n = 1;
        while (n < segmentMarkerArray.length) {
            double d = segmentMarkerArray[n].getValue();
            if (d < this.minValue) {
                this.minValue = d;
            }
            if (d > this.maxValue) {
                this.maxValue = d;
            }
            ++n;
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public SegmentMarker findSegmentMarker(double d) {
        int n = 0;
        while (n < this.segmentMarkers.length) {
            if (this.segmentMarkers[n].getValue() == d) {
                return this.segmentMarkers[n];
            }
            ++n;
        }
        return null;
    }
}

