/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.util.HashMap;
import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;

public class AdapterHashMapLogger
extends Sensor
implements ICBEPropertyConstants {
    public static final short OFF_LEVEL = -1;
    public static final short UNKNOWN_LEVEL = 0;
    public static final short INFO_LEVEL = 10;
    public static final short HARMLESS_LEVEL = 20;
    public static final short WARN_LEVEL = 30;
    public static final short MINOR_LEVEL = 40;
    public static final short CRITICAL_LEVEL = 50;
    public static final short FATAL_LEVEL = 60;
    public static final short TRACE_LEVEL = 70;
    public static final short FINE_LEVEL = 72;
    public static final short FINER_LEVEL = 74;
    public static final short FINEST_LEVEL = 76;
    public static final short ALL_LEVEL = 99;
    private int arraySize = 256;
    private HashMap[] events = new HashMap[this.arraySize];
    private int lastAddedEvent = -1;
    private int lastRemovedEvent = -1;
    private static AdapterHashMapLogger instance = null;
    private boolean availableToRead = true;

    public AdapterHashMapLogger() {
        instance = this;
    }

    public static synchronized AdapterHashMapLogger getInstance() {
        if (instance == null) {
            instance = new AdapterHashMapLogger();
        }
        return instance;
    }

    public synchronized Object[] testGetNext() {
        return this.testGetNextEvent();
    }

    public synchronized HashMap[] testGetNextEvent() {
        HashMap[] hashMapArray = new HashMap[]{new HashMap()};
        return hashMapArray;
    }

    public Object[] getNext() {
        return this.getNextEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap[] getNextEvent() {
        AdapterHashMapLogger adapterHashMapLogger = this;
        synchronized (adapterHashMapLogger) {
            if (this.lastAddedEvent == -1 || this.lastRemovedEvent == this.lastAddedEvent) {
                return null;
            }
            HashMap[] hashMapArray = new HashMap[this.lastAddedEvent - this.lastRemovedEvent];
            System.arraycopy(this.events, this.lastRemovedEvent + 1, hashMapArray, 0, this.lastAddedEvent - this.lastRemovedEvent);
            this.lastRemovedEvent = this.lastAddedEvent;
            return hashMapArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEvent(ICommonBaseEvent iCommonBaseEvent) {
        AdapterHashMapLogger adapterHashMapLogger = this;
        synchronized (adapterHashMapLogger) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = "CommonBaseEvent.";
            String string2 = string + "creationTime";
            hashMap.put(string2, iCommonBaseEvent.getCreationTime());
            string2 = string + "severity";
            hashMap.put(string2, String.valueOf(iCommonBaseEvent.getSeverity()));
            string2 = string + "msg";
            hashMap.put(string2, iCommonBaseEvent.getMsg());
            IComponentIdentification iComponentIdentification = iCommonBaseEvent.getSourceComponentId();
            string = string + "sourceComponentId.";
            string2 = string + "location";
            hashMap.put(string2, iComponentIdentification.getLocation());
            string2 = string + "locationType";
            hashMap.put(string2, iComponentIdentification.getLocationType());
            string2 = string + "component";
            hashMap.put(string2, iComponentIdentification.getComponent());
            string2 = string + "componentIdType";
            hashMap.put(string2, iComponentIdentification.getComponentIdType());
            string2 = string + "subComponent";
            hashMap.put(string2, iComponentIdentification.getSubComponent());
            if (this.lastAddedEvent + 1 == this.events.length) {
                this.increaseArraySize();
            }
            this.events[++this.lastAddedEvent] = hashMap;
        }
    }

    private synchronized void increaseArraySize() {
        HashMap[] hashMapArray = new HashMap[this.arraySize * 2];
        this.arraySize *= 2;
        this.compressArrayInto(hashMapArray);
        this.events = hashMapArray;
    }

    private synchronized void compressArrayInto(HashMap[] hashMapArray) {
        System.arraycopy(this.events, this.lastRemovedEvent + 1, hashMapArray, 0, this.lastAddedEvent - this.lastRemovedEvent);
        this.lastAddedEvent -= this.lastRemovedEvent;
        this.lastRemovedEvent = -1;
    }
}

