/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.sdb.internal.editors.DBDetails;
import org.eclipse.hyades.sdb.internal.editors.DirectiveDetails;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SolutionDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.editors.SymptomDetails;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DetailsContent
extends Composite {
    StackLayout detailsLayout;
    Composite details;
    DBDetails dbDetails;
    SymptomDetails symptoms;
    SolutionDetails solutions;
    DirectiveDetails directives;
    Composite composite;
    RASWidgetFactory factory;
    SymptomDBEditor editor;

    public DetailsContent(RASWidgetFactory rASWidgetFactory, Composite composite, int n) {
        super(composite, n);
        this.composite = composite;
        this.factory = rASWidgetFactory;
    }

    public Composite createContent() {
        this.detailsLayout = new StackLayout();
        this.setLayout((Layout)this.detailsLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 10;
        this.setLayoutData(gridData);
        this.dbDetails = new DBDetails(this.factory, this, 0);
        this.symptoms = new SymptomDetails(this.factory, this, 0);
        this.solutions = new SolutionDetails(this.factory, this, 0);
        this.directives = new DirectiveDetails(this.factory, this, 0);
        this.hideDetails();
        return this.details;
    }

    public void init(SymptomDBEditor symptomDBEditor) {
        this.editor = symptomDBEditor;
        this.dbDetails.init(symptomDBEditor);
        this.symptoms.init(symptomDBEditor);
        this.solutions.init(symptomDBEditor);
        this.directives.init(symptomDBEditor);
    }

    public void showDetailsFor(EObject eObject) {
        if (eObject instanceof SDBRuntime) {
            this.showDetail((Control)this.dbDetails, eObject);
        }
        if (eObject instanceof SDBSymptom) {
            this.showDetail((Control)this.symptoms, eObject);
        } else if (eObject instanceof SDBSolution) {
            this.showDetail((Control)this.solutions, eObject);
        } else if (eObject instanceof SDBDirective) {
            this.showDetail((Control)this.directives, eObject);
        }
    }

    public void setFocusFor(Object object) {
        if (object instanceof SDBRuntime) {
            this.dbDetails.setFocusToTextBox();
        }
        if (object instanceof SDBSymptom) {
            this.symptoms.setFocusToTextBox();
        } else if (object instanceof SDBSolution) {
            this.solutions.setFocusToTextBox();
        } else if (object instanceof SDBDirective) {
            this.directives.setFocusToTextBox();
        }
    }

    public boolean updateCurrentSelection(EObject eObject) {
        if (eObject instanceof SDBRuntime) {
            return this.dbDetails.updateCurrentSelection(eObject);
        }
        if (eObject instanceof SDBSymptom) {
            return this.symptoms.updateCurrentSelection(eObject);
        }
        if (eObject instanceof SDBSolution) {
            return this.solutions.updateCurrentSelection(eObject);
        }
        if (eObject instanceof SDBDirective) {
            return this.directives.updateCurrentSelection(eObject);
        }
        return false;
    }

    private void hideDetails() {
        this.dbDetails.setVisible(false);
        this.symptoms.setVisible(false);
        this.solutions.setVisible(false);
        this.directives.setVisible(false);
    }

    private void showDetail(Control control, EObject eObject) {
        ((IDetails)control).display(eObject);
        this.detailsLayout.topControl = control;
        this.layout();
    }

    protected void updateRegistry(EObject eObject, boolean bl) {
        if (eObject instanceof SDBSolution) {
            this.solutions.updateSolutionRegistry((SDBSolution)eObject, bl);
        } else if (eObject instanceof SDBDirective) {
            this.directives.updateDirectiveRegistry((SDBDirective)eObject, bl);
        }
    }
}

