/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Stack;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceMessageAndCallAssociation;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessage;

public class TraceCallStack {
    private final BaseTraceInteractions interactions;
    private TRCThread eThread;
    private Stack callStack;

    public TraceCallStack(BaseTraceInteractions baseTraceInteractions, TRCThread tRCThread) {
        this.setEThread(tRCThread);
        this.interactions = baseTraceInteractions;
        this.callStack = new Stack();
    }

    public void setEThread(TRCThread tRCThread) {
        this.eThread = tRCThread;
    }

    public TRCThread getEThread() {
        return this.eThread;
    }

    public void pushCall(TraceSyncMessage traceSyncMessage, TRCFullMethodInvocation tRCFullMethodInvocation) {
        this.callStack.push(new TraceMessageAndCallAssociation(traceSyncMessage, tRCFullMethodInvocation));
        this.interactions.sortTraceThreadList(this);
    }

    public TraceMessageAndCallAssociation popCall() {
        if (this.callStack.size() == 0) {
            return null;
        }
        TraceMessageAndCallAssociation traceMessageAndCallAssociation = (TraceMessageAndCallAssociation)this.callStack.pop();
        this.interactions.sortTraceThreadList(this);
        return traceMessageAndCallAssociation;
    }

    public TraceMessageAndCallAssociation getCurrentCall() {
        if (this.callStack.size() > 0) {
            return (TraceMessageAndCallAssociation)this.callStack.lastElement();
        }
        return null;
    }

    public double getCurrentExitTime() {
        if (this.callStack.size() > 0) {
            double d = TraceInteractionUtils.getAbsoluteExitTime(this.getCurrentCall().getMethodInvocation());
            if (d > 0.0) {
                return d;
            }
            return 1.7976931348623158E307;
        }
        return Double.MAX_VALUE;
    }
}

