/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterType;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.provider.AdapterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.provider.FormatterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.provider.SensorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.AdaptorEditor;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.ConfigurationPage;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.MigrationUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class AdaptorEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener {
    IFile file;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected TreeViewer parentViewer;
    protected TreeViewer treeViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection;
    protected RuleBuilderWidgetFactory widgetFactory;
    protected ConfigurationPage detailsViewer;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof ContentOutline) {
                if (((ContentOutline)iWorkbenchPart).getCurrentPage() == AdaptorEditor.this.contentOutlinePage) {
                    AdaptorEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)AdaptorEditor.this);
                    AdaptorEditor.this.setCurrentViewer((Viewer)AdaptorEditor.this.contentOutlineViewer);
                }
            } else if (iWorkbenchPart instanceof PropertySheet) {
                if (((PropertySheet)iWorkbenchPart).getCurrentPage() == AdaptorEditor.this.propertySheetPage) {
                    AdaptorEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)AdaptorEditor.this);
                    AdaptorEditor.this.handleActivate();
                }
            } else if (iWorkbenchPart == AdaptorEditor.this) {
                AdaptorEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    Collection removedResources = new ArrayList();
    Collection changedResources = new ArrayList();
    Collection savedResources = new ArrayList();
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            ResourceSet resourceSet = AdaptorEditor.this.editingDomain.getResourceSet();
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection changedResources;
                    protected Collection removedResources;
                    private final /* synthetic */ 2 this$1;

                    ResourceDeltaVisitor(2 var1_1) {
                        this.this$1 = var1_1;
                        this.resourceSet = 2.access$000(this.this$1).editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<E>();
                        this.removedResources = new ArrayList<E>();
                    }

                    public boolean visit(IResourceDelta iResourceDelta) {
                        Resource resource;
                        if (iResourceDelta.getFlags() != 131072 && iResourceDelta.getResource().getType() == 1 && (iResourceDelta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)iResourceDelta.getFullPath().toString()), false)) != null) {
                            if ((iResourceDelta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor(this);
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
                AdaptorEditor.this.removedResources.addAll(resourceDeltaVisitor.getRemovedResources());
                if (!resourceDeltaVisitor.getRemovedResources().isEmpty() && !AdaptorEditor.this.isDirty()) {
                    AdaptorEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            2.access$000(this.this$1).getSite().getPage().closeEditor((IEditorPart)2.access$000(this.this$1), false);
                            2.access$000(this.this$1).dispose();
                        }
                    });
                }
                AdaptorEditor.this.changedResources.addAll(resourceDeltaVisitor.getChangedResources());
            }
            catch (CoreException coreException) {
                AcadEditorPlugin.INSTANCE.log((Object)coreException);
            }
        }

        static /* synthetic */ AdaptorEditor access$000(2 var0) {
            return var0.AdaptorEditor.this;
        }
    };
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySheetPage;

    protected void handleActivate() {
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!this.isDirty() || this.handleDirtyConflict()) {
            Iterator iterator = this.changedResources.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException iOException) {
                    AcadEditorPlugin.INSTANCE.log(iOException);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)AdaptorEditor.getString("_UI_FileConflict_label"), (String)AdaptorEditor.getString("_WARN_FileConflict"));
    }

    public AdaptorEditor() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new ResourceItemProviderAdapterFactory());
        arrayList.add((Object)new ConfigurationItemProviderAdapterFactory());
        arrayList.add((Object)new ExtractorItemProviderAdapterFactory());
        arrayList.add((Object)new ContextItemProviderAdapterFactory());
        arrayList.add((Object)new OutputterItemProviderAdapterFactory());
        arrayList.add((Object)new SensorItemProviderAdapterFactory());
        arrayList.add((Object)new AdapterItemProviderAdapterFactory());
        arrayList.add((Object)new ParserItemProviderAdapterFactory());
        arrayList.add((Object)new FormatterItemProviderAdapterFactory());
        arrayList.add((Object)new UnitItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(arrayList);
        BasicCommandStack basicCommandStack = new BasicCommandStack();
        basicCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject eventObject) {
                AdaptorEditor.this.getContainer().getDisplay().asyncExec(new Runnable(this, eventObject){
                    private final /* synthetic */ EventObject val$event;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$event = eventObject;
                    }

                    public void run() {
                        4.access$100(this.this$1).firePropertyChange(257);
                        Command command = ((CommandStack)this.val$event.getSource()).getMostRecentCommand();
                        if (command != null) {
                            4.access$100(this.this$1).setSelectionToViewer(command.getAffectedObjects());
                        }
                        if (4.access$100(this.this$1).propertySheetPage != null && !4.access$100(this.this$1).propertySheetPage.getControl().isDisposed()) {
                            4.access$100(this.this$1).propertySheetPage.refresh();
                        }
                    }
                });
            }

            static /* synthetic */ AdaptorEditor access$100(4 var0) {
                return var0.AdaptorEditor.this;
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)basicCommandStack);
    }

    protected void firePropertyChange(int n) {
        super.firePropertyChange(n);
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection collection2 = collection;
        if (collection2 != null && !collection2.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (AdaptorEditor.this.currentViewer != null) {
                        AdaptorEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(collection2.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        AdaptorEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    protected void createContextMenuFor(StructuredViewer structuredViewer) {
        MenuManager menuManager = new MenuManager("#PopUp");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(structuredViewer.getControl());
        structuredViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)structuredViewer);
    }

    public void createPages() {
        Resource resource;
        String string;
        this.widgetFactory = new RuleBuilderWidgetFactory();
        IFileEditorInput iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        try {
            string = URI.createPlatformResourceURI((String)iFileEditorInput.getFile().getFullPath().toString()).toString();
            resource = this.editingDomain.getResourceSet().getResource(URI.createURI((String)string), true);
        }
        catch (Exception exception) {
            AcadEditorPlugin.INSTANCE.log(exception);
        }
        string = new ScrolledComposite(this.getContainer(), 768);
        string.setExpandHorizontal(true);
        string.setExpandVertical(true);
        resource = new GridLayout();
        resource.numColumns = 1;
        string.setLayout((Layout)resource);
        this.detailsViewer = new ConfigurationPage(this.widgetFactory, (EditingDomain)this.editingDomain);
        string.setContent(this.detailsViewer.getContent((Composite)string));
        Point point = this.detailsViewer.getContent().computeSize(-1, -1);
        string.setMinWidth(point.x);
        string.setMinHeight(point.y);
        int n = this.addPage((Control)string);
        this.setPageText(n, "First page");
        this.selectionViewer = this.detailsViewer.getViewer();
        this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
        EList eList = this.editingDomain.getResourceSet().getResources();
        if (eList.size() > 0) {
            Object object = eList.get(0);
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Resource resource2 = (Resource)iterator.next();
                if (!resource2.getURI().fileExtension().equals("adapter")) continue;
                EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)AdapterPackage.eINSTANCE);
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
                EObject eObject = (EObject)resource2.getContents().get(0);
                object = eObject;
                try {
                    MigrationUtil.migrateLoad((AdapterType)eObject.eGet(eStructuralFeature));
                }
                catch (Exception exception) {}
                break;
            }
            this.selectionViewer.setInput(object);
        } else {
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
        }
        this.createContextMenuFor((StructuredViewer)this.selectionViewer);
        this.addSelectionChangedListener(this.detailsViewer);
        this.setCurrentViewer((Viewer)this.selectionViewer);
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent controlEvent) {
                if (!this.guard) {
                    this.guard = true;
                    AdaptorEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            ((CTabFolder)this.getContainer()).setTabHeight(1);
            Point point = this.getContainer().getSize();
            this.getContainer().setSize(point.x, point.y + 2);
        }
    }

    protected void pageChange(int n) {
        super.pageChange(n);
        Control control = this.getControl(n);
        if (control != null) {
            control.setVisible(true);
            control.setFocus();
        }
        this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = AdaptorEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getContentOutlinePage();
        }
        if (clazz.equals(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = AdaptorEditor.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(clazz);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                private final /* synthetic */ AdaptorEditor this$0;

                MyContentOutlinePage(AdaptorEditor adaptorEditor) {
                    this.this$0 = adaptorEditor;
                }

                public void createControl(Composite composite) {
                    super.createControl(composite);
                    this.this$0.contentOutlineViewer = this.getTreeViewer();
                    this.this$0.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    this.this$0.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.this$0.adapterFactory));
                    this.this$0.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.this$0.adapterFactory));
                    this.this$0.contentOutlineViewer.setInput((Object)this.this$0.editingDomain.getResourceSet());
                    this.this$0.createContextMenuFor((StructuredViewer)this.this$0.contentOutlineViewer);
                    if (!this.this$0.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(this.this$0.editingDomain.getResourceSet().getResources().get(0));
                        this.this$0.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(arrayList), true);
                    }
                }

                public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
                    super.makeContributions(iMenuManager, iToolBarManager, iStatusLineManager);
                    this.this$0.contentOutlineStatusLineManager = iStatusLineManager;
                }

                public void setActionBars(IActionBars iActionBars) {
                    super.setActionBars(iActionBars);
                    this.this$0.getActionBarContributor().shareGlobalActions((IPage)this, iActionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage(this);
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    AdaptorEditor.this.handleContentOutlineSelection(selectionChangedEvent.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
                    super.makeContributions(iMenuManager, iToolBarManager, iStatusLineManager);
                }

                public void setActionBars(IActionBars iActionBars) {
                    super.setActionBars(iActionBars);
                    AdaptorEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, iActionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection iSelection) {
        Iterator iterator;
        if (this.currentViewerPane != null && !iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (iterator = ((IStructuredSelection)iSelection).iterator()).hasNext()) {
            Object e = iterator.next();
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList arrayList = new ArrayList();
                arrayList.add(e);
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(arrayList));
            } else if (this.currentViewerPane.getViewer().getInput() != e) {
                this.currentViewerPane.getViewer().setInput(e);
                this.currentViewerPane.setTitle(e);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    Resource resource = (Resource)AdaptorEditor.this.editingDomain.getResourceSet().getResources().get(0);
                    try {
                        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)AdapterPackage.eINSTANCE);
                        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
                        EObject eObject = (EObject)resource.getContents().get(0);
                        AdapterType adapterType = (AdapterType)eObject.eGet(eStructuralFeature);
                        MigrationUtil.migrateSave(adapterType);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    AdaptorEditor.this.savedResources.add(resource);
                    resource.save(Collections.EMPTY_MAP);
                }
                catch (Exception exception) {
                    AcadEditorPlugin.INSTANCE.log(exception);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)workspaceModifyOperation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            AcadEditorPlugin.INSTANCE.log(exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile iFile;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath iPath = saveAsDialog.getResult();
        if (iPath != null && (iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath)) != null) {
            ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(URI.createPlatformResourceURI((String)iFile.getFullPath().toString()));
            FileEditorInput fileEditorInput = new FileEditorInput(iFile);
            this.setInput((IEditorInput)fileEditorInput);
            this.setTitle(iFile.getName());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput.");
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setTitle(((IFileEditorInput)iEditorInput).getFile().getName());
        iEditorSite.setSelectionProvider((ISelectionProvider)this);
        iEditorSite.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        this.file = ((IFileEditorInput)iEditorInput).getFile();
        this.enableEditActions();
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection iSelection) {
        this.editorSelection = iSelection;
        Object[] objectArray = this.selectionChangedListeners.toArray();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, iSelection));
            ++n;
        }
        this.setStatusLineManager(iSelection);
    }

    public void setStatusLineManager(ISelection iSelection) {
        IStatusLineManager iStatusLineManager = this.getActionBars().getStatusLineManager();
        if (this.currentViewer == this.contentOutlineViewer) {
            iStatusLineManager = this.contentOutlineStatusLineManager;
        }
        if (iSelection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)iSelection).toList();
            switch (list.size()) {
                case 0: {
                    iStatusLineManager.setMessage(AdaptorEditor.getString("_UI_NoObjectSelected"));
                    break;
                }
                case 1: {
                    String string = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(list.iterator().next());
                    iStatusLineManager.setMessage(AdaptorEditor.getString("_UI_SingleObjectSelected", string));
                    break;
                }
                default: {
                    iStatusLineManager.setMessage(AdaptorEditor.getString("_UI_MultiObjectSelected", Integer.toString(list.size())));
                    break;
                }
            }
        } else {
            iStatusLineManager.setMessage("");
        }
    }

    private static String getString(String string) {
        return AcadEditorPlugin.INSTANCE.getString(string);
    }

    private static String getString(String string, Object object) {
        return AcadEditorPlugin.INSTANCE.getString(string, new Object[]{object});
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(iMenuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        AcadGuiModelManager.disposeModel(this.file);
        this.file = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        this.getActionBarContributor().setActiveEditor(null);
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object object2 = super.getParent(object);
            return (object2 == null ? Collections.EMPTY_SET : Collections.singleton(object2)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object object2 = super.getParent(object);
            return (object2 == null ? Collections.EMPTY_SET : Collections.singleton(object2)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object object2 = super.getParent(object);
            return object2 != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

