/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.Vector;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueueEntry;

public class ResultQueue {
    private Vector entries = new Vector();
    private Vector partialResults = new Vector();
    private boolean valid = true;
    private int lockCount = 0;
    private int maxSize = 10;

    public void insertExtractorResult(Object object) {
        ResultQueueEntry resultQueueEntry = new ResultQueueEntry();
        resultQueueEntry.extractorOutput = object;
        this.partialResults.add(resultQueueEntry);
    }

    public void insertFormatterResult(Object object) {
        ResultQueueEntry resultQueueEntry = (ResultQueueEntry)this.partialResults.remove(0);
        resultQueueEntry.formatterOutput = object;
        this.insert(resultQueueEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        int n2 = 200;
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            ++this.lockCount;
            while (n >= this.entries.size() && this.valid && n2 > 0) {
                --n2;
                try {
                    ResultQueue resultQueue2 = this;
                    synchronized (resultQueue2) {
                        this.wait(10L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            --this.lockCount;
            if (n >= this.entries.size()) {
                return null;
            }
            return this.entries.get(n);
        }
    }

    public Object getFirstEntry() {
        if (this.entries.size() > 0) {
            return this.entries.firstElement();
        }
        return "";
    }

    public Object getLastEntry() {
        if (this.entries.size() > 0) {
            return this.entries.lastElement();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Object object) {
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            ++this.lockCount;
            while (this.isFull() && this.valid) {
                ResultQueue resultQueue2 = this;
                synchronized (resultQueue2) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.isFull() && this.valid) {
                this.entries.add(object);
            }
            --this.lockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        boolean bl = this.isFull();
        Object e = this.entries.remove(0);
        if (bl) {
            ResultQueue resultQueue = this;
            synchronized (resultQueue) {
                this.notifyAll();
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            this.partialResults.removeAllElements();
            this.entries.removeAllElements();
            this.valid = false;
            while (this.lockCount-- > 0) {
                this.notifyAll();
            }
        }
    }

    public boolean isFull() {
        return this.entries.size() >= this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public int getSize() {
        return this.entries.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

